/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.naming.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.jorm.api.ClassMappedEvent;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PMapper;
import org.objectweb.jorm.api.PMapperListener;
import org.objectweb.jorm.api.PMappingRequiredEvent;
import org.objectweb.jorm.naming.api.KeyFilteredNamingContext;
import org.objectweb.jorm.naming.api.NamingFilterKeyProvider;
import org.objectweb.jorm.naming.api.PBinder;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.type.lib.PTypePAAH;
import org.objectweb.jorm.util.api.Loggable;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;

public class KFPNCManager
implements PMapperListener,
Loggable {
    private Logger logger;
    private LoggerFactory loggerFactory;
    private boolean debug;
    private Map cn2pnc;
    private Map scn2binderKey = new HashMap();

    public KFPNCManager() {
        this.cn2pnc = new HashMap();
    }

    public KFPNCManager(Map cn2pnc) {
        this.cn2pnc = cn2pnc;
    }

    public KeyFilteredNamingContext getKFPNC(String className) {
        Object pnc = this.cn2pnc.get(className);
        return (KeyFilteredNamingContext)(pnc instanceof KeyFilteredNamingContext ? pnc : null);
    }

    public void clean() {
        this.cn2pnc.clear();
        this.scn2binderKey.clear();
    }

    public void mappingRequired(PMappingRequiredEvent e) {
    }

    public void classMapped(ClassMappedEvent e) {
        block19: {
            PClassMapping pcm;
            PMapper mapper;
            String className;
            block18: {
                className = e.getJormClassName();
                mapper = e.getPMapper();
                PType type = mapper.getPTypeSpace().getPType(className);
                if (!(type instanceof PTypePAAH)) {
                    return;
                }
                pcm = mapper.lookup(className);
                PTypePAAH classType = (PTypePAAH)type;
                PType[] superTypes = classType.getInheritedPType();
                if (superTypes != null && superTypes.length != 0) break block18;
                Object pnc = this.cn2pnc.get(className);
                if (!(pnc instanceof KeyFilteredNamingContext)) {
                    return;
                }
                KeyFilteredNamingContext kfpnc = (KeyFilteredNamingContext)pnc;
                HashSet subPCMs = new HashSet();
                this.findSubPCM(className, subPCMs, mapper);
                Iterator it = subPCMs.iterator();
                while (it.hasNext()) {
                    PClassMapping subpcm = (PClassMapping)it.next();
                    if (!(subpcm instanceof NamingFilterKeyProvider)) continue;
                    Object key = ((NamingFilterKeyProvider)((Object)subpcm)).getNamingFilterKey();
                    if (this.debug) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("Register the binder of the '" + subpcm.getClassName() + "' sub class with the following key: " + key));
                    }
                    try {
                        kfpnc.exportClass(subpcm.getPBinder(), key);
                    }
                    catch (PException e1) {
                        this.logger.log(BasicLevel.ERROR, (Object)("Impossible to export a Binder into the KFPNC of the class " + className), (Throwable)e1);
                    }
                }
                List list = (List)this.scn2binderKey.remove(className);
                if (list == null) break block19;
                while (!list.isEmpty()) {
                    Object[] obj = (Object[])list.remove(0);
                    if (this.debug) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("Register the binder of the '" + ((PBinder)obj[0]).getBinderClassMapping().getClassName() + "' sub class with the following key: " + obj[1]));
                    }
                    try {
                        kfpnc.exportClass((PBinder)obj[0], obj[1]);
                    }
                    catch (PException e1) {
                        this.logger.log(BasicLevel.ERROR, (Object)("Impossible to export a Binder into the KFPNC of the class " + className), (Throwable)e1);
                    }
                }
                break block19;
            }
            if (pcm instanceof NamingFilterKeyProvider) {
                Object key = ((NamingFilterKeyProvider)((Object)pcm)).getNamingFilterKey();
                if (this.debug) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("The '" + pcm.getClassName() + "' provides the following key: " + key));
                }
                HashSet superClassNames = new HashSet();
                this.findAncestorNames(className, superClassNames, mapper);
                PBinder binder = pcm.getPBinder();
                Iterator it = superClassNames.iterator();
                while (it.hasNext()) {
                    String superClassName = (String)it.next();
                    KeyFilteredNamingContext kfpnc = this.getKFPNC(superClassName);
                    if (kfpnc == null) {
                        ArrayList<Object[]> list = (ArrayList<Object[]>)this.scn2binderKey.get(superClassName);
                        if (list == null) {
                            list = new ArrayList<Object[]>();
                            this.scn2binderKey.put(superClassName, list);
                        }
                        list.add(new Object[]{binder, key});
                        if (!this.debug) continue;
                        this.logger.log(BasicLevel.DEBUG, (Object)("No KPNC found for the ancestor " + superClassName + ". The register of the class " + pcm.getClassName() + " will be done later"));
                        continue;
                    }
                    if (this.debug) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("Register the binder of the '" + pcm.getClassName() + "' class with the following key: " + key + " into the KFPNc of the ancestor " + superClassName));
                    }
                    try {
                        kfpnc.exportClass(binder, key);
                    }
                    catch (PException e1) {
                        this.logger.log(BasicLevel.ERROR, (Object)("Impossible to export a Binder into the KFPNC of the class " + superClassName), (Throwable)e1);
                    }
                }
            }
        }
    }

    private void findSubPCM(String className, Set result, PMapper mapper) {
        PClassMapping pcm = mapper.lookup(className);
        if (pcm != null && result.add(pcm)) {
            PType classType = mapper.getPTypeSpace().getPType(className);
            PType[] subTypes = classType.getSubTypes();
            for (int i = 0; i < subTypes.length; ++i) {
                this.findSubPCM(subTypes[i].getJavaName(), result, mapper);
            }
        } else if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("The sub class " + className + " is not yet mapped"));
        }
    }

    private void findAncestorNames(String className, Set result, PMapper mapper) {
        PType type = mapper.getPTypeSpace().getPType(className);
        if (!(type instanceof PTypePAAH)) {
            return;
        }
        PTypePAAH classType = (PTypePAAH)type;
        PType[] superTypes = classType.getInheritedPType();
        if (superTypes == null || superTypes.length == 0) {
            result.add(className);
        } else {
            for (int i = 0; i < superTypes.length; ++i) {
                this.findAncestorNames(superTypes[i].getJormName(), result, mapper);
            }
        }
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
        this.debug = logger.isLoggable(BasicLevel.DEBUG);
    }
}

