/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.file.monolog;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.HandlerFactory;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.LevelFactory;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.objectweb.util.monolog.api.MonologFactory;
import org.objectweb.util.monolog.api.TopicalLogger;
import org.objectweb.util.monolog.file.DottedStringTools;
import org.objectweb.util.monolog.wrapper.common.LevelImpl;

public class PropertiesConfAccess
implements Serializable {
    private static final long serialVersionUID = -321110630195680214L;
    public static final String LOGGER_FIELD = "logger";
    public static final String ACTIVATION = "activation";
    public static final String ADDITIVITY_FIELD = "additivity";
    public static final String USE_PARENT_FIELD = "useParent";
    public static final String HANDLER_FIELD = "handler";
    public static final String LEVEL_FIELD = "level";
    public static final String TOPIC_FIELD = "topic";
    public static final String CLEAN_HANDLERS_FIELD = "cleanHandlers";
    public static final char DOT = '.';
    public static final String HANDLER_TYPE_ATTRIBUTE = "type";
    public static final String HANDLER_TYPE_ATTRIBUTE_FILE_VALUE = "file";
    public static final String HANDLER_TYPE_ATTRIBUTE_CONSOLE_VALUE = "console";
    public static final String HANDLER_TYPE_ATTRIBUTE_ROLLING_FILE_VALUE = "rollingfile";
    public static final String HANDLER_TYPE_ATTRIBUTE_NTEVENT_VALUE = "ntevent";
    public static final String HANDLER_TYPE_ATTRIBUTE_JMX_VALUE = "jmx";
    public static boolean debug = new Boolean(System.getProperty("monolog.debug"));
    protected Vector loggerCleaned = null;

    public static void load(Properties prop, LoggerFactory lof, HandlerFactory hf, LevelFactory lef) throws Exception {
        new PropertiesConfAccess().read(prop, lof, hf, lef);
    }

    public static void load(Properties prop, MonologFactory mf) throws Exception {
        new PropertiesConfAccess().read(prop, mf, mf, mf);
    }

    public static void store(Properties prop, LoggerFactory lof, HandlerFactory hf, LevelFactory lef) throws Exception {
        new PropertiesConfAccess().write(prop, lof, hf, lef);
    }

    public static void store(Properties prop, MonologFactory mf) throws Exception {
        new PropertiesConfAccess().write(prop, mf, mf, mf);
    }

    public void read(Properties prop, LoggerFactory lof, HandlerFactory hf, LevelFactory lef) throws Exception {
        this.read(prop, (MonologFactory)lof);
    }

    public void read(Properties prop, MonologFactory mf) throws Exception {
        String key;
        Enumeration<Object> e = prop.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (!key.startsWith("logger.") || !key.endsWith(".cleanHandlers") || !Boolean.getBoolean(prop.getProperty(key).trim())) continue;
            String loggerName = key.substring(LOGGER_FIELD.length() + 1, key.length() - 1 - CLEAN_HANDLERS_FIELD.length());
            ((TopicalLogger)mf.getLogger(loggerName)).removeAllHandlers();
        }
        Enumeration<Object> en = prop.keys();
        while (en.hasMoreElements()) {
            key = (String)en.nextElement();
            if (key.startsWith("logger.")) {
                this.parseLoggerProp(prop, key, mf);
                continue;
            }
            if (!key.startsWith("level.")) continue;
            this.parseLevelProp(prop, key, mf);
        }
        Vector<Handler> hs = new Vector<Handler>();
        Enumeration<Object> en2 = prop.keys();
        while (en2.hasMoreElements()) {
            String key2 = (String)en2.nextElement();
            if (!key2.startsWith("handler.")) continue;
            String handlerName = DottedStringTools.getBegin(DottedStringTools.getEnd(key2));
            Handler h = mf.getHandler(handlerName);
            if (h != null && !hs.contains(h)) {
                hs.addElement(h);
            }
            this.parseHandlerProp(prop, key2, mf);
        }
        for (int i = 0; i < hs.size(); ++i) {
            ((Handler)hs.elementAt(i)).setAttribute(ACTIVATION, mf);
        }
    }

    public void write(Properties prop, LoggerFactory lof, HandlerFactory hf, LevelFactory lef) throws Exception {
        String key = null;
        String val = null;
        Level[] levels = lef.getLevels();
        for (int i = 0; i < levels.length; ++i) {
            if (this.isDefaultLevel(levels[i])) continue;
            key = "level." + levels[i].getName();
            val = ((LevelImpl)levels[i]).getStringValue();
            this.debug(key + " " + val);
            prop.put(key, val.trim());
        }
        Handler[] handlers = hf.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            key = "handler." + handlers[i].getName() + '.' + HANDLER_TYPE_ATTRIBUTE;
            val = handlers[i].getType();
            this.debug(key + " " + val);
            prop.put(key, val);
            String[] ats = handlers[i].getAttributeNames();
            for (int j = 0; j < ats.length; ++j) {
                key = "handler." + handlers[i].getName() + '.' + ats[j];
                Object o = handlers[i].getAttribute(ats[j]);
                if (!(o instanceof String)) continue;
                val = (String)o;
                this.debug(key + " " + val);
                prop.put(key, val.trim());
            }
        }
        TopicalLogger[] loggers = (TopicalLogger[])lof.getLoggers();
        String topicPrefix = lof.getTopicPrefix();
        for (int i = 0; i < loggers.length; ++i) {
            int j;
            String sep;
            StringBuffer sb;
            Level level;
            String[] topics = loggers[i].getTopic();
            if (topics.length == 0) {
                throw new Exception("Impossible to set the definition of a logger without name");
            }
            String topic = loggers[i].getTopic()[0];
            if (topicPrefix != null && topic.startsWith(topicPrefix)) {
                topic = topic.substring(topicPrefix.length());
            }
            String begin = "logger." + topic;
            if (!loggers[i].getAdditivity()) {
                key = begin + '.' + ADDITIVITY_FIELD;
                val = "false";
                this.debug(key + " " + val);
                prop.put(key, val.trim());
            }
            if ((level = loggers[i].getCurrentLevel()) != null && level.getIntValue() != BasicLevel.INHERIT) {
                key = begin + '.' + LEVEL_FIELD;
                val = " " + level.getName();
                this.debug(key + " " + val);
                prop.put(key, val.trim());
            }
            if ((handlers = loggers[i].getHandler()) != null && handlers.length > 0) {
                sb = new StringBuffer();
                sep = "";
                for (j = 0; j < handlers.length; ++j) {
                    if (handlers[j].getName() == null) continue;
                    sb.append(sep);
                    sep = ", ";
                    sb.append(handlers[j].getName());
                }
                this.debug(begin + '.' + HANDLER_FIELD + " " + sb.toString());
                prop.put(begin + '.' + HANDLER_FIELD, sb.toString());
            }
            if (topics.length <= 1) continue;
            sb = new StringBuffer();
            sep = "";
            for (j = 1; j < topics.length; ++j) {
                sb.append(sep);
                sep = ", ";
                String ntopic = topics[j];
                if (topicPrefix != null && ntopic.startsWith(topicPrefix)) {
                    ntopic = ntopic.substring(topicPrefix.length());
                }
                sb.append(ntopic);
            }
            this.debug(begin + '.' + TOPIC_FIELD + " " + sb.toString());
            prop.put(begin + '.' + TOPIC_FIELD, sb.toString());
        }
    }

    protected boolean isDefaultLevel(Level l) {
        return l.getName().equalsIgnoreCase("DEBUG") || l.getName().equalsIgnoreCase("INFO") || l.getName().equalsIgnoreCase("WARN") || l.getName().equalsIgnoreCase("ERROR") || l.getName().equalsIgnoreCase("FATAL") || l.getName().equalsIgnoreCase("INHERIT");
    }

    protected Logger parseLoggerProp(Properties prop, String key, LoggerFactory lof, HandlerFactory hf, LevelFactory lef) throws Exception {
        return this.parseLoggerProp(prop, key, (MonologFactory)lof);
    }

    protected Logger parseLoggerProp(Properties prop, String key, MonologFactory mf) throws Exception {
        if (prop == null || key == null || mf == null) {
            throw new Exception("The null parameters are not allowed");
        }
        String temp = DottedStringTools.getFirst(key);
        if (temp == null || !temp.equalsIgnoreCase(LOGGER_FIELD)) {
            throw new Exception("This key is not a Logger property:" + key);
        }
        TopicalLogger logger = null;
        temp = DottedStringTools.getEnd(key);
        String last = DottedStringTools.getLast(temp);
        if (last.equalsIgnoreCase(LEVEL_FIELD)) {
            logger = (TopicalLogger)mf.getLogger(DottedStringTools.getBegin(temp));
            String levelName = prop.getProperty(key).trim();
            Level l = mf.getLevel(levelName);
            if (l == null) {
                l = this.parseLevelProp(prop, "level." + levelName, mf);
            }
            if (debug) {
                this.debug("set level to " + l.getName() + " to the logger " + logger.getName());
            }
            logger.setLevel(l);
        } else if (ADDITIVITY_FIELD.equalsIgnoreCase(last) || USE_PARENT_FIELD.equalsIgnoreCase(last)) {
            logger = (TopicalLogger)mf.getLogger(DottedStringTools.getBegin(temp));
            boolean a = Boolean.getBoolean(prop.getProperty(key).trim());
            if (debug) {
                this.debug("set additivity to " + a + " to the logger " + logger.getName());
            }
            logger.setAdditivity(a);
        } else if (!CLEAN_HANDLERS_FIELD.equalsIgnoreCase(last)) {
            if (HANDLER_FIELD.equalsIgnoreCase(last)) {
                String value = prop.getProperty(key).trim();
                StringTokenizer st = new StringTokenizer(value, ", ;:", false);
                logger = (TopicalLogger)mf.getLogger(DottedStringTools.getBegin(temp));
                this.cleanOldHandler(logger);
                while (st.hasMoreTokens()) {
                    String hn = st.nextToken();
                    Handler h = mf.getHandler(hn);
                    if (h == null) {
                        h = this.parseHandlerProp(prop, "handler." + value + '.' + HANDLER_TYPE_ATTRIBUTE, mf);
                    }
                    if (debug) {
                        this.debug("add handler " + h.getName() + " to the logger " + logger.getName());
                    }
                    logger.addHandler(h);
                }
            } else if (TOPIC_FIELD.equalsIgnoreCase(last)) {
                logger = (TopicalLogger)mf.getLogger(DottedStringTools.getBegin(temp));
                String value = prop.getProperty(key).trim();
                StringTokenizer st = new StringTokenizer(value, ", ;:", false);
                this.cleanOldHandler(logger);
                while (st.hasMoreTokens()) {
                    String topic = st.nextToken();
                    if (debug) {
                        this.debug("add topic " + topic + " to the logger " + logger.getName());
                    }
                    logger.addTopic(topic);
                }
            } else {
                temp = DottedStringTools.getBegin(temp);
                last = DottedStringTools.getLast(temp);
                temp = DottedStringTools.getBegin(temp);
                logger = (TopicalLogger)mf.getLogger(temp);
                if (last.equalsIgnoreCase(HANDLER_FIELD)) {
                    String value = prop.getProperty(key).trim();
                    Handler h = mf.getHandler(value);
                    if (h == null) {
                        h = this.parseHandlerProp(prop, "handler." + value + '.' + HANDLER_TYPE_ATTRIBUTE, mf);
                    }
                    this.cleanOldHandler(logger);
                    if (debug) {
                        this.debug("add handler " + h.getName() + " to the logger " + logger.getName());
                    }
                    logger.addHandler(h);
                } else if (last.equalsIgnoreCase(TOPIC_FIELD)) {
                    String topic = prop.getProperty(key).trim();
                    if (debug) {
                        this.debug("add topic " + topic + " to the logger " + logger.getName());
                    }
                    logger.addTopic(topic);
                } else {
                    throw new Exception("Unknown definition" + key + " " + prop.getProperty(key));
                }
            }
        }
        return logger;
    }

    protected Handler parseHandlerProp(Properties prop, String key, HandlerFactory hf) throws Exception {
        if (prop == null || key == null || hf == null) {
            throw new Exception("The null parameters are not allowed");
        }
        String temp = DottedStringTools.getFirst(key);
        if (temp == null || !temp.equalsIgnoreCase(HANDLER_FIELD)) {
            throw new Exception("This key is not a Handler field:" + key);
        }
        temp = DottedStringTools.getEnd(key);
        String attribute = DottedStringTools.getLast(temp);
        String handlerName = DottedStringTools.getBegin(temp);
        Handler hc = hf.getHandler(handlerName);
        if (hc == null) {
            String stringType = prop.getProperty("handler." + handlerName + '.' + HANDLER_TYPE_ATTRIBUTE, null);
            if (stringType == null) {
                throw new Exception("Impossible to define the handler " + temp + ": the type is not defined");
            }
            hc = hf.createHandler(handlerName, stringType);
            if (hc == null) {
                throw new Exception("The HandlerFactory does not create the Handler: name=" + handlerName + " / type=" + stringType);
            }
        }
        if (hc != null && !HANDLER_TYPE_ATTRIBUTE.equalsIgnoreCase(attribute)) {
            String v = prop.getProperty(key).trim();
            if (debug) {
                this.debug("assign property (" + attribute + ", " + v + ") to the handler '" + handlerName);
            }
            hc.setAttribute(attribute, v);
        }
        return hc;
    }

    protected Level parseLevelProp(Properties prop, String key, LevelFactory lef) throws Exception {
        return this.parseLevelProp(prop, key, lef, new Vector());
    }

    protected Level parseLevelProp(Properties prop, String key, LevelFactory lef, Vector currentLevelParse) throws Exception {
        if (prop == null || key == null || lef == null) {
            throw new Exception("The null parameters are not allowed");
        }
        String temp = DottedStringTools.getFirst(key);
        if (temp == null || !temp.equalsIgnoreCase(LEVEL_FIELD)) {
            throw new Exception("This key is not a level field:" + key);
        }
        temp = DottedStringTools.getEnd(key);
        Level l = lef.getLevel(temp);
        if (l == null) {
            if (!prop.containsKey(key)) {
                throw new Exception("Level definition not found: " + key);
            }
            if (currentLevelParse.contains(temp)) {
                throw new Exception("Circular level definition: " + temp);
            }
            String levelValue = prop.getProperty(key).trim();
            String[] depends = this.getDependsLevel(levelValue);
            if (depends.length > 0) {
                currentLevelParse.addElement(temp);
                for (int i = 0; i < depends.length; ++i) {
                    this.parseLevelProp(prop, "level." + depends[i], lef, currentLevelParse);
                }
                currentLevelParse.removeElement(temp);
            }
            l = lef.defineLevel(temp, levelValue);
        }
        return l;
    }

    protected String[] getDependsLevel(String expr) {
        Vector<String> res = new Vector<String>();
        StringTokenizer st = new StringTokenizer(expr, " +-", true);
        while (st.hasMoreTokens()) {
            String elem = st.nextToken();
            if (!Character.isLetter(elem.charAt(0))) continue;
            res.addElement(elem);
        }
        Object[] r = new String[res.size()];
        res.copyInto(r);
        return r;
    }

    protected void cleanOldHandler(TopicalLogger l) throws Exception {
        if (this.loggerCleaned == null) {
            this.loggerCleaned = new Vector();
        }
        if (!this.loggerCleaned.contains(l)) {
            this.loggerCleaned.addElement(l);
            l.removeAllHandlers();
        }
    }

    public void debug(String m) {
        if (debug) {
            System.out.println(m);
        }
    }

    class NestedException
    extends Exception {
        private static final long serialVersionUID = -1218233947556357710L;
        Exception nestedException = null;

        public NestedException() {
        }

        public NestedException(Exception e) {
            this.nestedException = e;
        }

        public NestedException(Exception e, String msg) {
            super(msg);
            this.nestedException = e;
        }

        public Exception getNestedException() {
            return this.nestedException;
        }

        public void printStackTrace(PrintStream ps) {
            if (this.nestedException != null) {
                ps.println("Nested: " + this.getMessage());
                this.nestedException.printStackTrace(ps);
            } else {
                super.printStackTrace(ps);
            }
        }

        public void printStackTrace(PrintWriter w) {
            if (this.nestedException != null) {
                w.println("Nested: " + this.getMessage());
                this.nestedException.printStackTrace(w);
            } else {
                super.printStackTrace(w);
            }
        }

        public void printStackTrace() {
            this.printStackTrace(new PrintStream(System.out));
        }
    }
}

