/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLAttributeDesignator;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectQuery;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAttributeQuery
extends SAMLSubjectQuery
implements Cloneable {
    protected String resource = null;
    protected ArrayList designators = new ArrayList();

    public SAMLAttributeQuery() {
    }

    public SAMLAttributeQuery(SAMLSubject sAMLSubject, String string, Collection collection) throws SAMLException {
        super(sAMLSubject);
        this.resource = string;
        if (collection != null) {
            this.designators.addAll(collection);
        }
    }

    public SAMLAttributeQuery(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLAttributeQuery(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLAttributeQuery.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        Object object;
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "AttributeQuery")) {
            object = QName.getQNameAttribute(element, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "Query") && XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "SubjectQuery") && object != null && "urn:oasis:names:tc:SAML:1.0:protocol".equals(((QName)object).getNamespaceURI()) && "AttributeQueryType".equals(((QName)object).getLocalName()))) {
                throw new MalformedException(SAMLException.REQUESTER, "SAMLAttributeQuery() requires samlp:AttributeQuery at root");
            }
        }
        if (element.hasAttributeNS(null, "Resource")) {
            this.resource = element.getAttributeNS(null, "Resource");
        }
        object = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "AttributeDesignator");
        while (object != null) {
            this.designators.add(new SAMLAttributeDesignator((Element)object));
            object = XML.getNextSiblingElement((Node)object, "urn:oasis:names:tc:SAML:1.0:assertion", "AttributeDesignator");
        }
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String string) {
        this.resource = string;
        if (this.root != null) {
            ((Element)this.root).removeAttributeNS(null, "Resource");
            if (!XML.isEmpty(string)) {
                ((Element)this.root).setAttributeNS(null, "Resource", string);
            }
        }
    }

    public Iterator getDesignators() {
        return this.designators.iterator();
    }

    public void setDesignators(Collection collection) throws SAMLException {
        while (this.designators.size() > 0) {
            this.removeDesignator(0);
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addDesignator((SAMLAttributeDesignator)iterator.next());
            }
        }
    }

    public void addDesignator(SAMLAttributeDesignator sAMLAttributeDesignator) throws SAMLException {
        if (sAMLAttributeDesignator != null) {
            if (this.root != null) {
                sAMLAttributeDesignator.checkValidity();
                Element element = XML.getLastChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "AttributeDesignator");
                if (element == null) {
                    this.root.insertBefore(sAMLAttributeDesignator.toDOM(this.root.getOwnerDocument()), this.subject.root.getNextSibling());
                } else {
                    this.root.insertBefore(sAMLAttributeDesignator.toDOM(this.root.getOwnerDocument()), element.getNextSibling());
                }
            }
        } else {
            throw new IllegalArgumentException("designator cannot be null");
        }
        this.designators.add(sAMLAttributeDesignator);
    }

    public void removeDesignator(int n) {
        this.designators.remove(n);
        if (this.root != null) {
            Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "AttributeDesignator");
            while (element != null && n > 0) {
                element = XML.getNextSiblingElement(element);
                --n;
            }
            if (element != null) {
                this.root.removeChild(element);
            } else {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        this.root = super.toDOM(document, bl);
        if (this.root != null) {
            if (bl) {
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
            }
            return this.root;
        }
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "AttributeQuery");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
        }
        if (this.resource != null && this.resource.length() > 0) {
            element.setAttributeNS(null, "Resource", this.resource);
        }
        element.appendChild(this.subject.toDOM(document));
        Iterator iterator = this.designators.iterator();
        while (iterator.hasNext()) {
            SAMLAttributeDesignator sAMLAttributeDesignator = (SAMLAttributeDesignator)iterator.next();
            sAMLAttributeDesignator.checkValidity();
            element.appendChild(sAMLAttributeDesignator.toDOM(document, true));
        }
        this.root = element;
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAttributeQuery sAMLAttributeQuery = (SAMLAttributeQuery)super.clone();
        Iterator iterator = this.designators.iterator();
        while (iterator.hasNext()) {
            sAMLAttributeQuery.designators.add(((SAMLAttributeDesignator)iterator.next()).clone());
        }
        return sAMLAttributeQuery;
    }
}

