/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.irmi;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.rmi.server.RMIClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RMIObjectInputStream
extends ObjectInputStream {
    private List cache = new ArrayList();
    private Map resolved = new HashMap();

    public RMIObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        Class<?> result = (Class<?>)this.resolved.get(desc);
        if (result == null) {
            String annotation = this.readUTF();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            result = RMIClassLoader.loadClass(annotation, desc.getName(), cl);
            this.resolved.put(desc, result);
        }
        return result;
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ArrayList<String> key = new ArrayList<String>(Arrays.asList(interfaces));
        Class<?> result = (Class<?>)this.resolved.get(key);
        if (result == null) {
            String annotation = this.readUTF();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            result = RMIClassLoader.loadProxyClass(annotation, interfaces, cl);
            this.resolved.put(key, result);
        }
        return result;
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass result;
        short num = this.readShort();
        if (num == -1) {
            result = super.readClassDescriptor();
            this.cache.add(result);
        } else {
            result = (ObjectStreamClass)this.cache.get(num);
        }
        return result;
    }

    protected void readStreamHeader() {
    }
}

