/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.helper;

import javax.ejb.TransactionManagementType;
import javax.naming.Context;
import javax.naming.NamingException;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.container.EasyBeansEJBContext;
import org.ow2.easybeans.deployment.helper.JavaContextHelperException;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarClassMetadata;
import org.ow2.easybeans.naming.NamingManager;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IEnvEntry;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaContextHelper {
    private static Log logger = LogFactory.getLog(JavaContextHelper.class);

    private JavaContextHelper() {
    }

    public static Context build(EjbJarClassMetadata bean, Factory<?, ?> easyBeansFactory) throws JavaContextHelperException {
        Context envCtx;
        Context compCtx;
        Context javaCtx = null;
        try {
            javaCtx = NamingManager.getInstance().createEnvironmentContext(bean.getClassName());
        }
        catch (NamingException e) {
            throw new IllegalStateException("Cannot build a new environment", e);
        }
        try {
            compCtx = (Context)javaCtx.lookup("comp");
        }
        catch (NamingException e) {
            throw new JavaContextHelperException("Cannot create subcontext", e);
        }
        if (easyBeansFactory.getBeanInfo().getTransactionManagementType() == TransactionManagementType.CONTAINER) {
            logger.debug("Bean is container managed so remove availability of java:comp/UserTransaction object", new Object[0]);
            try {
                compCtx.unbind("UserTransaction");
            }
            catch (NamingException e) {
                throw new IllegalStateException("Cannot remove java:comp/UserTransaction object", e);
            }
        }
        EasyBeansEJBContext context = new EasyBeansEJBContext(easyBeansFactory);
        try {
            compCtx.bind("EJBContext", context);
        }
        catch (NamingException e) {
            throw new JavaContextHelperException("Cannot bind EJBContext", e);
        }
        try {
            compCtx.bind("TimerService", (Object)context.getTimerService());
        }
        catch (NamingException e) {
            throw new JavaContextHelperException("Cannot bind EJBContext", e);
        }
        try {
            envCtx = compCtx.createSubcontext("env");
        }
        catch (NamingException e) {
            throw new JavaContextHelperException("Cannot create subcontext", e);
        }
        for (IEnvEntry envEntry : bean.getEnvEntryCollection()) {
            String name = envEntry.getName();
            Object value = JavaContextHelper.getEnvEntryValue(envEntry);
            if (value == null) continue;
            try {
                envCtx.rebind(name, value);
            }
            catch (NamingException e) {
                throw new JavaContextHelperException("Cannot bind element '" + name + "'.", e);
            }
        }
        return javaCtx;
    }

    private static Object getEnvEntryValue(IEnvEntry envEntry) {
        String type = envEntry.getType();
        String value = envEntry.getValue();
        Object returnedValue = null;
        if (type.equals(Boolean.class.getName())) {
            if ("true".equalsIgnoreCase(value)) {
                returnedValue = Boolean.TRUE;
            } else if ("false".equalsIgnoreCase(value)) {
                returnedValue = Boolean.FALSE;
            }
        } else if (type.equals(String.class.getName())) {
            returnedValue = value;
        } else if (type.equals(Integer.class.getName())) {
            if (value != null) {
                returnedValue = new Integer(value);
            }
        } else if (type.equals(Character.class.getName())) {
            if (value != null) {
                if (value.length() != 1) {
                    throw new IllegalStateException("The value '" + value + "' is not a valid value for env-entry of type java.lang.Character.");
                }
                returnedValue = new Character(value.charAt(0));
            }
        } else if (type.equals(Double.class.getName())) {
            if (value != null) {
                returnedValue = new Double(value);
            }
        } else if (type.equals(Byte.class.getName())) {
            if (value != null) {
                returnedValue = new Byte(value);
            }
        } else if (type.equals(Short.class.getName())) {
            if (value != null) {
                returnedValue = new Short(value);
            }
        } else if (type.equals(Long.class.getName())) {
            if (value != null) {
                returnedValue = new Long(value);
            }
        } else if (type.equals(Float.class.getName())) {
            if (value != null) {
                returnedValue = new Float(value);
            }
        } else {
            throw new IllegalStateException(type + " is not a valid type for env-entry.");
        }
        return returnedValue;
    }
}

