/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.loader;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.spi.ClassTransformer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyBeansClassLoader
extends URLClassLoader
implements Cloneable {
    private static final int BUF_APPEND = 1000;
    private static Log logger = LogFactory.getLog(EasyBeansClassLoader.class);
    private boolean recomputeToString = true;
    private String toStringValue = null;
    private Class javaLangClassLoaderClass = null;
    private Method defineClassMethod = null;
    private Map<String, byte[]> mapDefined = new HashMap<String, byte[]>();
    private List<ClassTransformer> classTransformers = null;

    public EasyBeansClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public EasyBeansClassLoader(URL[] urls) {
        super(urls);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class clazz = this.searchingDefinedClass(name);
        if (clazz != null) {
            return clazz;
        }
        return super.findClass(name);
    }

    /*
     * Exception decompiling
     */
    private Class<?> defineInternalClass(String className, byte[] bytecode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addClassDefinition(String className, byte[] bytecode) {
        if (this.mapDefined.get(className) != null) {
            logger.warn("There is already a bytecode defined for the class named '" + className + "'. Not replacing. This could be due to a duplicated class in the given package.", new Object[0]);
        }
        this.mapDefined.put(className, bytecode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        this.searchingDefinedClass(name);
        if (this.classTransformers == null) {
            return super.loadClass(name, false);
        }
        if (this.findLoadedClass(name) != null) {
            return super.loadClass(name, false);
        }
        StringBuilder sb = new StringBuilder(name.replace(".", "/"));
        sb.append(".class");
        String resourceName = sb.toString();
        URL resourceURL = this.findResource(resourceName);
        if (resourceURL == null) {
            return super.loadClass(name, false);
        }
        InputStream inputStream = this.getResourceAsStream(resourceName);
        if (inputStream == null) {
            throw new ClassNotFoundException("The resource '" + resourceName + "' was not found");
        }
        byte[] bytes = null;
        try {
            bytes = EasyBeansClassLoader.readClass(inputStream);
        }
        catch (IOException e) {
            try {
                throw new ClassNotFoundException("Cannot read the class ''.", e);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    logger.error("Cannot close the stream", e2);
                }
                throw throwable;
            }
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            logger.error("Cannot close the stream", e);
        }
        Iterator<ClassTransformer> i$ = this.classTransformers.iterator();
        while (i$.hasNext()) {
            ClassTransformer classTransformer = i$.next();
            try {
                byte[] updatedBytes = classTransformer.transform(this, name.replace(".", "/"), null, null, bytes);
                if (updatedBytes == null) continue;
                bytes = updatedBytes;
            }
            catch (IllegalClassFormatException e) {
                throw new ClassNotFoundException("Cannot transform the resource '" + resourceName + "'", e);
            }
        }
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    private Class searchingDefinedClass(String className) {
        Class<?> clazz;
        byte[] defined;
        if (this.mapDefined != null && (defined = this.mapDefined.get(className)) != null && (clazz = this.defineInternalClass(className, defined)) != null) {
            this.mapDefined.remove(className);
            return clazz;
        }
        return null;
    }

    public String toString() {
        if (this.recomputeToString) {
            this.computeToString();
        }
        return this.toStringValue;
    }

    private void computeToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[");
        sb.append("urls=");
        URL[] urls = this.getURLs();
        for (int u = 0; u < urls.length; ++u) {
            sb.append(urls[u]);
            if (u == urls.length - 1) continue;
            sb.append(";");
        }
        sb.append("]");
        this.toStringValue = sb.toString();
        this.recomputeToString = false;
    }

    public Object clone() {
        return new EasyBeansClassLoader(this.getURLs(), this.getParent());
    }

    public void addTransformer(ClassTransformer transformer) {
        if (this.classTransformers == null) {
            this.classTransformers = new ArrayList<ClassTransformer>();
        }
        this.classTransformers.add(transformer);
    }

    private static byte[] readClass(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("Given input stream is null");
        }
        byte[] b = new byte[is.available()];
        int len = 0;
        while (true) {
            byte[] c;
            int n;
            if ((n = is.read(b, len, b.length - len)) == -1) {
                if (len < b.length) {
                    c = new byte[len];
                    System.arraycopy(b, 0, c, 0, len);
                    b = c;
                }
                return b;
            }
            if ((len += n) != b.length) continue;
            c = new byte[b.length + 1000];
            System.arraycopy(b, 0, c, 0, len);
            b = c;
        }
    }
}

