/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.osgi.extension;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.binding.BindingException;
import org.ow2.easybeans.api.binding.EZBBindingFactory;
import org.ow2.easybeans.api.binding.EZBRef;
import org.ow2.easybeans.container.session.stateless.StatelessSessionFactory;
import org.ow2.easybeans.proxy.client.EJBLocalHomeInvocationHandler;
import org.ow2.easybeans.proxy.client.LocalCallInvocationHandler;

public class OSGiBindingFactory
implements EZBBindingFactory {
    private final Map<EZBRef, ServiceRegistration> registrations = new HashMap<EZBRef, ServiceRegistration>();

    public void bind(EZBRef ref) throws BindingException {
        Factory<?, ?> factory = ref.getFactory();
        if (factory instanceof StatelessSessionFactory) {
            EZBContainer container = factory.getContainer();
            ClassLoader loader = container.getClassLoader();
            String interfaceName = ref.getItfClassName();
            Class<Object> clz = null;
            try {
                clz = loader.loadClass(interfaceName);
            }
            catch (ClassNotFoundException e) {
                throw new BindingException("Cannot find the class '" + interfaceName + "' in Classloader '" + loader + "'.", e);
            }
            LocalCallInvocationHandler handler = null;
            handler = clz.isAssignableFrom(EJBLocalHome.class) ? new EJBLocalHomeInvocationHandler() : (clz.isAssignableFrom(EJBHome.class) ? new EJBLocalHomeInvocationHandler() : new LocalCallInvocationHandler());
            handler.setInterfaceClass(clz);
            handler.setFactory(factory);
            BundleContext context = container.getExtension(BundleContext.class);
            Object proxy = Proxy.newProxyInstance(loader, new Class[]{clz}, (InvocationHandler)handler);
            ServiceRegistration registration = null;
            registration = context.registerService(clz.getName(), proxy, null);
            this.registrations.put(ref, registration);
        }
    }

    public void unbind(EZBRef ref) throws BindingException {
        ServiceRegistration reg = this.registrations.get(ref);
        if (reg != null) {
            reg.unregister();
        }
    }
}

