/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.security.propagation.jonas;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.acl.Group;
import javax.security.auth.Subject;
import org.ow2.easybeans.security.api.EZBSecurityContext;
import org.ow2.easybeans.security.struct.JPrincipal;

public class JOnASSecurityContext
implements EZBSecurityContext {
    private Object jonasSecurityContext = null;

    public JOnASSecurityContext(Object jonasSecurityContext) {
        this.jonasSecurityContext = jonasSecurityContext;
    }

    public Principal getCallerPrincipal(boolean runAsBean) {
        Method m = null;
        try {
            m = this.jonasSecurityContext.getClass().getMethod("getCallerPrincipal", Boolean.TYPE);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Cannot get the method getCallerPrincipal on the JOnAS security context", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Cannot get the method getCallerPrincipal on the JOnAS security context", e);
        }
        try {
            return (Principal)m.invoke(this.jonasSecurityContext, runAsBean);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Cannot call getCallerPrincipal method on the JOnAS security context", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot call getCallerPrincipal method on the JOnAS security context", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Cannot call getCallerPrincipal method on the JOnAS security context", e);
        }
    }

    public Principal[] getCallerRoles(boolean runAsBean) {
        Method m = null;
        try {
            m = this.jonasSecurityContext.getClass().getMethod("getCallerPrincipalRoles", Boolean.TYPE);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Cannot get the method getCallerPrincipalRoles on the JOnAS security context", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Cannot get the method getCallerPrincipalRoles on the JOnAS security context", e);
        }
        String[] roles = null;
        try {
            roles = (String[])m.invoke(this.jonasSecurityContext, runAsBean);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Cannot call getCallerPrincipalRoles method on the JOnAS security context", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot call getCallerPrincipalRoles method on the JOnAS security context", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Cannot call getCallerPrincipalRoles method on the JOnAS security context", e);
        }
        if (roles == null) {
            throw new IllegalStateException("No roles found on the JOnAS security context");
        }
        Principal[] principals = new Principal[roles.length];
        int i = 0;
        for (String role : roles) {
            principals[i++] = new JPrincipal(role);
        }
        return principals;
    }

    public Subject enterRunAs(Subject runAsSubject) {
        Method m = null;
        try {
            m = this.jonasSecurityContext.getClass().getMethod("pushRunAs", String.class, String.class, String[].class);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Cannot get the method pushRunAs on the JOnAS security context", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Cannot get the method pushRunAs on the JOnAS security context", e);
        }
        String principalName = null;
        for (Principal principal : runAsSubject.getPrincipals(Principal.class)) {
            if (principal instanceof Group) continue;
            principalName = principal.getName();
            break;
        }
        String role = null;
        for (Principal principal : runAsSubject.getPrincipals(Principal.class)) {
            if (!(principal instanceof Group)) continue;
            role = ((Principal)((Group)principal).members().nextElement()).getName();
        }
        try {
            m.invoke(this.jonasSecurityContext, role, principalName, new String[]{role});
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Cannot call pushRunAs method on the JOnAS security context", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot call pushRunAs method on the JOnAS security context", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Cannot call pushRunAs method on the JOnAS security context", e);
        }
        return null;
    }

    public void endsRunAs(Subject oldSubject) {
        Method m = null;
        try {
            m = this.jonasSecurityContext.getClass().getMethod("popRunAs", new Class[0]);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Cannot get the method popRunAs on the JOnAS security context", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Cannot get the method popRunAs on the JOnAS security context", e);
        }
        try {
            m.invoke(this.jonasSecurityContext, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Cannot call popRunAs method on the JOnAS security context", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot call popRunAs method on the JOnAS security context", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Cannot call popRunAs method on the JOnAS security context", e);
        }
    }
}

