/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.server;

import java.net.URL;
import org.ow2.easybeans.server.Embedded;
import org.ow2.easybeans.server.EmbeddedException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xmlconfig.XMLConfiguration;
import org.ow2.util.xmlconfig.XMLConfigurationException;
import org.ow2.util.xmlconfig.properties.SystemPropertyResolver;

public final class EmbeddedConfigurator {
    private static final String CONFIGURATION_FILE_NAME = "easybeans.xml";
    private static Log logger = LogFactory.getLog(EmbeddedConfigurator.class);

    private EmbeddedConfigurator() {
    }

    public static Embedded init(Embedded embedded, URL xmlConfigurationURL) throws EmbeddedException {
        EmbeddedConfigurator.configure(embedded, xmlConfigurationURL);
        return embedded;
    }

    public static Embedded create(URL xmlConfigurationURL) throws EmbeddedException {
        return EmbeddedConfigurator.init(new Embedded(), xmlConfigurationURL);
    }

    public static Embedded create() throws EmbeddedException {
        URL xmlConfigurationURL = Thread.currentThread().getContextClassLoader().getResource(CONFIGURATION_FILE_NAME);
        if (xmlConfigurationURL == null) {
            throw new EmbeddedException("No configuration file with name 'easybeans.xml' was found in classpath.");
        }
        return EmbeddedConfigurator.create(xmlConfigurationURL);
    }

    private static void configure(Embedded embedded, URL xmlConfigurationURL) throws EmbeddedException {
        long tStart = System.currentTimeMillis();
        logger.debug("Starting configuration of EasyBeans server", new Object[0]);
        XMLConfiguration xmlConfiguration = new XMLConfiguration(xmlConfigurationURL, "easybeans-mapping.xml");
        xmlConfiguration.setPropertyResolver(new SystemPropertyResolver());
        try {
            xmlConfiguration.configure(embedded);
        }
        catch (XMLConfigurationException e) {
            throw new EmbeddedException("Cannot configure the embedded server", e);
        }
        if (logger.isInfoEnabled()) {
            logger.debug("Configuration done in : " + (System.currentTimeMillis() - tStart) + " ms", new Object[0]);
        }
    }
}

