/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.dbm.internal.cm.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.dbm.internal.cm.ConnectionManager;
import org.ow2.jonas.lib.util.Log;

public class DataSourceFactory
implements ObjectFactory {
    private static Logger logger = null;

    public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env) throws Exception {
        Reference ref = (Reference)refObj;
        String clname = ref.getClassName();
        if (logger == null) {
            logger = Log.getLogger("org.ow2.jonas.dbm");
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        if (clname.equals(ConnectionManager.class.getName())) {
            String dsname = (String)ref.get("datasource.name").getContent();
            ConnectionManager ds = ConnectionManager.getConnectionManager(dsname);
            if (ds == null) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Creating a new Connection Manager for " + dsname));
                }
                try {
                    String jBase = System.getProperty("jonas.base");
                    if (jBase == null) {
                        ds = new ConnectionManager(true);
                        ds.setDSName(dsname);
                        ds.setUrl((String)ref.get("datasource.url").getContent());
                        ds.setClassName((String)ref.get("datasource.classname").getContent());
                        ds.setUserName((String)ref.get("datasource.username").getContent());
                        ds.setPassword((String)ref.get("datasource.password").getContent());
                        return ds;
                    }
                    ds = new ConnectionManager(null);
                    ds.setDSName(dsname);
                    ds.setUrl((String)ref.get("datasource.url").getContent());
                    ds.setClassName((String)ref.get("datasource.classname").getContent());
                    ds.setUserName((String)ref.get("datasource.username").getContent());
                    ds.setPassword((String)ref.get("datasource.password").getContent());
                    ds.setTransactionIsolation((String)ref.get("datasource.isolationlevel").getContent());
                    ds.setMapperName((String)ref.get("datasource.mapper").getContent());
                    ds.poolConfigure((String)ref.get("connchecklevel").getContent(), (String)ref.get("connmaxage").getContent(), (String)ref.get("maxopentime").getContent(), (String)ref.get("connteststmt").getContent(), (String)ref.get("pstmtmax").getContent(), (String)ref.get("minconpool").getContent(), (String)ref.get("maxconpool").getContent(), (String)ref.get("maxwaittime").getContent(), (String)ref.get("maxwaiters").getContent(), (String)ref.get("samplingperiod").getContent(), (String)ref.get("adjustperiod").getContent());
                }
                catch (Exception e) {
                    logger.log(BasicLevel.ERROR, (Object)"DataSourceFactory error", (Throwable)e);
                }
            }
            return ds;
        }
        logger.log(BasicLevel.ERROR, (Object)("no object found for " + clname));
        return null;
    }
}

