/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genbase.archive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.Attributes;
import javax.xml.parsers.ParserConfigurationException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.api.IServiceRefDesc;
import org.ow2.jonas.deployment.client.ClientContainerDeploymentDesc;
import org.ow2.jonas.deployment.client.lib.ClientDeploymentDescManager;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.EjbRefDesc;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Application;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.EjbRefModule;
import org.ow2.jonas.generators.genbase.archive.J2EEArchive;
import org.ow2.jonas.generators.genbase.archive.WsClient;
import org.ow2.jonas.generators.genbase.utils.XMLUtils;
import org.ow2.jonas.lib.loader.ClientClassLoader;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Client
extends J2EEArchive
implements EjbRefModule,
WsClient {
    private Application app = null;
    private ClientContainerDeploymentDesc clientDD = null;
    private List sRefs;
    private List ejbRefs;
    private Map descriptors;
    private Document jclientDoc;

    public Client(Archive archive) throws GenBaseException {
        super(archive);
        if (Client.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Client.getLogger().log(BasicLevel.DEBUG, (Object)("Wrapping '" + archive.getName() + "' in Client"));
        }
        this.init();
    }

    public Client(Archive archive, Application app) throws GenBaseException {
        super(archive);
        this.setApplication(app);
        if (Client.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Client.getLogger().log(BasicLevel.DEBUG, (Object)("Wrapping '" + archive.getName() + "' in Client"));
        }
        this.init();
    }

    private void init() throws GenBaseException {
        this.loadDescriptors();
    }

    private void loadDescriptors() throws GenBaseException {
        this.descriptors = new Hashtable();
        InputStream jcis = null;
        try {
            jcis = this.getJonasClientInputStream();
            if (jcis != null) {
                this.jclientDoc = XMLUtils.newDocument(jcis, "META-INF/jonas-client.xml", this.isDTDsAllowed());
                this.descriptors.put("META-INF/jonas-client.xml", this.jclientDoc);
            }
        }
        catch (SAXException saxe) {
            String err = Client.getI18n().getMessage("Client.loadDescriptors.parseError");
            throw new GenBaseException(err, saxe);
        }
        catch (ParserConfigurationException pce) {
            String err = Client.getI18n().getMessage("Client.loadDescriptors.prepare");
            throw new GenBaseException(err, pce);
        }
        catch (IOException ioe) {
            String err = Client.getI18n().getMessage("Client.loadDescriptors.parseError");
            throw new GenBaseException(err, ioe);
        }
    }

    public void setApplication(Application app) {
        this.app = app;
    }

    public Application getApplication() {
        return this.app;
    }

    public List getServiceRefDescs() {
        return this.sRefs;
    }

    public void addClasses(File classes) {
        this.addDirectory(classes);
    }

    public Map getDescriptors() {
        return this.descriptors;
    }

    public boolean omit(String name) {
        return name.equals("META-INF/jonas-client.xml") || name.equals("META-INF\\jonas-client.xml");
    }

    public Document getJonasClientDoc() {
        return this.jclientDoc;
    }

    public InputStream getJonasClientInputStream() throws IOException {
        InputStream is = null;
        is = this.isPacked() ? this.getInputStream("META-INF/jonas-client.xml") : this.getInputStream("META-INF" + File.separator + "jonas-client.xml");
        return is;
    }

    public void initialize() throws GenBaseException {
        try {
            if (this.app == null) {
                this.setModuleClassloader(new ClientClassLoader(this.getArchive().getRootFile().toURL(), Thread.currentThread().getContextClassLoader()));
            } else {
                this.setModuleClassloader(this.createClientClassLoaderWithinApplication(this.getApplication().getEJBClassLoader()));
            }
        }
        catch (IOException ioe) {
            String err = Client.getI18n().getMessage("Client.init.loader", this.getArchive().getRootFile());
            throw new GenBaseException(err, ioe);
        }
        try {
            this.clientDD = ClientDeploymentDescManager.getInstance(this.getRootFile().getAbsolutePath(), this.getModuleClassloader());
        }
        catch (DeploymentDescException dde) {
            throw new GenBaseException(dde);
        }
        this.sRefs = new Vector();
        IServiceRefDesc[] refs = this.clientDD.getServiceRefDesc();
        for (int i = 0; i < refs.length; ++i) {
            this.sRefs.add(refs[i]);
        }
        this.ejbRefs = new Vector();
        EjbRefDesc[] refDesc = this.clientDD.getEjbRefDesc();
        for (int i = 0; i < refDesc.length; ++i) {
            this.ejbRefs.add(refDesc[i]);
        }
    }

    private ClientClassLoader createClientClassLoaderWithinApplication(ClassLoader parent) throws GenBaseException {
        String classpath = this.getManifest().getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        URL[] urls = new URL[1];
        if (classpath != null) {
            String[] paths = classpath.split(" ");
            urls = new URL[paths.length + 1];
            for (int i = 0; i < paths.length; ++i) {
                try {
                    URL path;
                    urls[i] = path = new File(this.app.getRootFile(), paths[i]).toURL();
                    continue;
                }
                catch (IOException ioe) {
                    String err = "Cannot transform '" + paths[i] + "' as a URL";
                    throw new GenBaseException(err, ioe);
                }
            }
        }
        ClientClassLoader ccl = null;
        try {
            urls[urls.length - 1] = this.getArchive().getRootFile().toURL();
            ccl = new ClientClassLoader(urls, parent);
        }
        catch (IOException e) {
            String err = "Cannot create Client ClassLoader for " + this.getArchive().getName();
            throw new GenBaseException(err, e);
        }
        return ccl;
    }

    public List getEjbRefDescs() {
        return this.ejbRefs;
    }

    public void close() {
        super.close();
        this.ejbRefs = null;
        this.clientDD = null;
        this.app = null;
        this.descriptors = null;
        this.jclientDoc = null;
    }
}

