/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genclientstub.modifier;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Application;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.Client;
import org.ow2.jonas.generators.genbase.archive.EjbJar;
import org.ow2.jonas.generators.genbase.archive.FileArchive;
import org.ow2.jonas.generators.genbase.archive.J2EEArchive;
import org.ow2.jonas.generators.genbase.archive.JarArchive;
import org.ow2.jonas.generators.genbase.archive.WebApp;
import org.ow2.jonas.generators.genbase.modifier.AbsModifierFactory;
import org.ow2.jonas.generators.genbase.modifier.ArchiveModifier;
import org.ow2.jonas.generators.genclientstub.ClientStubGenException;
import org.ow2.jonas.generators.genclientstub.modifier.ApplicationModifier;
import org.ow2.jonas.generators.genclientstub.modifier.ClientModifier;
import org.ow2.jonas.generators.genclientstub.modifier.EjbJarModifier;
import org.ow2.jonas.generators.genclientstub.modifier.WebAppModifier;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.CARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;

public class ModifierFactory
extends AbsModifierFactory {
    private static I18n i18n = I18n.getInstance(ModifierFactory.class);

    private ModifierFactory() {
    }

    public static ArchiveModifier getModifier(String filename) throws GenBaseException {
        return ModifierFactory.getModifier(filename, true, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArchiveModifier getModifier(String filename, boolean init, IDeployable deployable) throws GenBaseException {
        void var5_13;
        int mode;
        void var3_6;
        Object var3_3 = null;
        J2EEArchive j2eeArchive = null;
        Object var5_8 = null;
        IDeployable<?> localDeployable = null;
        File file = new File(filename);
        if (!file.exists()) {
            String err = i18n.getMessage("ModifierFactory.getModifier.notfound", filename);
            throw new ClientStubGenException(err);
        }
        if (file.isFile()) {
            try {
                JarFile jarfile = new JarFile(file);
            }
            catch (IOException ioe) {
                String err = i18n.getMessage("ModifierFactory.getModifier.notjar", filename);
                throw new ClientStubGenException(err);
            }
            JarArchive jarArchive = new JarArchive(file);
        } else {
            FileArchive fileArchive = new FileArchive(file);
        }
        try {
            if (deployable == null) {
                IArchive fileArchive = ArchiveManager.getInstance().getArchive(file);
                localDeployable = DeployableHelper.getDeployable(fileArchive);
            } else {
                localDeployable = deployable;
            }
        }
        catch (DeployableHelperException e) {
            throw new ClientStubGenException("Cannot get a deployable for the archive '" + var3_6 + "'", e);
        }
        if (localDeployable instanceof EARDeployable) {
            j2eeArchive = new Application((Archive)var3_6, localDeployable);
            mode = 0;
        } else if (localDeployable instanceof EJBDeployable) {
            j2eeArchive = new EjbJar((Archive)var3_6);
            mode = 1;
        } else if (localDeployable instanceof WARDeployable) {
            j2eeArchive = new WebApp((Archive)var3_6);
            mode = 2;
        } else {
            if (!(localDeployable instanceof CARDeployable)) {
                String err = i18n.getMessage("ModifierFactory.getModifier.unsupported", filename);
                throw new ClientStubGenException(err);
            }
            j2eeArchive = new Client((Archive)var3_6);
            mode = 3;
        }
        if (init) {
            j2eeArchive.initialize();
        }
        switch (mode) {
            case 0: {
                ApplicationModifier applicationModifier = new ApplicationModifier((Application)j2eeArchive);
                return var5_13;
            }
            case 1: {
                EjbJarModifier ejbJarModifier = new EjbJarModifier((EjbJar)j2eeArchive);
                return var5_13;
            }
            case 2: {
                WebAppModifier webAppModifier = new WebAppModifier((WebApp)j2eeArchive);
                return var5_13;
            }
            case 3: {
                ClientModifier clientModifier = new ClientModifier((Client)j2eeArchive);
                return var5_13;
            }
        }
        return var5_13;
    }
}

