/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.ddmodifier;

import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class DeploymentDescModifier {
    protected static final String J2EE_NS = "http://java.sun.com/xml/ns/j2ee";
    protected static final String JONAS_NS = "http://www.objectweb.org/jonas/ns";
    private static Logger logger = Log.getLogger("org.ow2.jonas.generators.wsgen");
    private Element element;
    private Element parent;
    private Document doc;

    public DeploymentDescModifier(Element element, Document doc) {
        this(element, doc, null);
    }

    public DeploymentDescModifier(Element element, Document doc, Element parent) {
        this.element = element;
        this.doc = doc;
        this.parent = parent;
    }

    protected Element newJ2EEElement(String name) {
        return this.doc.createElementNS(J2EE_NS, name);
    }

    protected Element newJ2EEElement(String name, String text) {
        Element e = this.doc.createElementNS(J2EE_NS, name);
        Text txt = this.doc.createTextNode(text);
        e.appendChild(txt);
        return e;
    }

    protected Element newJOnASElement(String name) {
        return this.doc.createElementNS(JONAS_NS, name);
    }

    protected Element newJOnASElement(String name, String text) {
        Element e = this.doc.createElementNS(JONAS_NS, name);
        Text txt = this.doc.createTextNode(text);
        e.appendChild(txt);
        return e;
    }

    protected Element newElement(String name) {
        return this.doc.createElement(name);
    }

    protected Element newElement(String name, String text) {
        Element e = this.doc.createElement(name);
        Text txt = this.doc.createTextNode(text);
        e.appendChild(txt);
        return e;
    }

    public static Logger getLogger() {
        return logger;
    }

    public Element getParent() {
        return this.parent;
    }

    public Element getElement() {
        return this.element;
    }

    public Document getDocument() {
        return this.doc;
    }

    public void setDocument(Document doc) {
        this.doc = doc;
        this.parent = doc.getDocumentElement();
    }

    public void setElement(Element e) {
        this.element = e;
        this.getParent().appendChild(e);
    }
}

