/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.carol.util.csiv2.SasHelper;
import org.ow2.jonas.cmi.CmiService;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.EntityDesc;
import org.ow2.jonas.deployment.ejb.SessionDesc;
import org.ow2.jonas.deployment.ejb.SessionStatefulDesc;
import org.ow2.jonas.deployment.ejb.SessionStatelessDesc;
import org.ow2.jonas.lib.ejb21.EJBInvocation;
import org.ow2.jonas.lib.ejb21.JFactory;
import org.ow2.jonas.lib.ejb21.JHomeHandle;
import org.ow2.jonas.lib.ejb21.RequestCtx;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.svc.JHomeHandleIIOP;
import org.ow2.jonas.lib.svc.JMetaData;

public abstract class JHome
extends PortableRemoteObject
implements EJBHome {
    protected JMetaData ejbMetaData = null;
    protected BeanDesc dd;
    protected JFactory bf;
    protected boolean unregistered = true;

    public JHome(BeanDesc dd, JFactory bf) throws RemoteException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"JHome constructor");
        }
        this.dd = dd;
        this.bf = bf;
    }

    public EJBMetaData getEJBMetaData() throws RemoteException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"JHome getEJBMetaData");
        }
        if (this.ejbMetaData == null) {
            if (this.dd instanceof SessionDesc) {
                boolean isSession = true;
                boolean isStatelessSession = this.dd instanceof SessionStatelessDesc;
                Class primaryKeyClass = null;
                this.ejbMetaData = new JMetaData(this, this.dd.getHomeClass(), this.dd.getRemoteClass(), isSession, isStatelessSession, primaryKeyClass);
            } else if (this.dd instanceof EntityDesc) {
                boolean isSession = false;
                boolean isStatelessSession = false;
                Class primaryKeyClass = ((EntityDesc)this.dd).getPrimaryKeyClass();
                this.ejbMetaData = new JMetaData(this, this.dd.getHomeClass(), this.dd.getRemoteClass(), isSession, isStatelessSession, primaryKeyClass);
            }
        }
        return this.ejbMetaData;
    }

    public HomeHandle getHomeHandle() throws RemoteException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        String protocol = ConfigurationRepository.getCurrentConfiguration().getProtocol().getName();
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("Current protocol = " + protocol));
        }
        if (protocol.equals("iiop")) {
            return new JHomeHandleIIOP(this, this.bf.myClassLoader());
        }
        return new JHomeHandle(this.dd.getJndiName());
    }

    public abstract void remove(Handle var1) throws RemoteException, RemoveException;

    public abstract void remove(Object var1) throws RemoteException, RemoveException;

    protected void register() throws NamingException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        final String name = this.dd.getJndiName();
        CmiService cmiService = this.bf.cont.getCmiService();
        if (cmiService != null && cmiService.isStarted()) {
            try {
                cmiService.addClusteredObject(name, this.dd.getClusterPolicy(), this.dd.getHomeClass(), this.dd.getRemoteClass(), this.bf.cont.getClassLoader(), this.dd instanceof SessionStatefulDesc || this.dd instanceof EntityDesc, this.dd.isClusterReplicated());
            }
            catch (Exception e) {
                TraceEjb.interp.log(BasicLevel.ERROR, (Object)("Cannot add the object with name " + name + " to the cluster"), (Throwable)e);
            }
        }
        final JHome jhome = this;
        IExecution<Void> rebinder = new IExecution<Void>(){

            @Override
            public Void execute() throws Exception {
                SasHelper.rebind(name, jhome, JHome.this.dd.getSasComponent());
                return null;
            }
        };
        ExecutionResult<Void> result = RunnableHelper.execute(this.getClass().getClassLoader(), rebinder);
        if (result.hasException()) {
            TraceEjb.interp.log(BasicLevel.ERROR, (Object)"Cannot register bean");
            throw new RuntimeException("Cannot register bean:", result.getException());
        }
        this.unregistered = false;
    }

    protected void unregister() throws NamingException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        String name = this.dd.getJndiName();
        this.bf.getInitialContext().unbind(name);
        try {
            PortableRemoteObject.unexportObject((Remote)this);
        }
        catch (NoSuchObjectException e) {
            TraceEjb.interp.log(BasicLevel.ERROR, (Object)"unexportObject(JHome) failed", (Throwable)e);
        }
        this.unregistered = true;
    }

    public String getJndiName() {
        return this.dd.getJndiName();
    }

    public RequestCtx preInvoke(int txa) throws RemoteException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        return this.bf.preInvokeRemote(txa);
    }

    public void checkSecurity(EJBInvocation ejbInv) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        this.bf.checkSecurity(ejbInv);
    }

    public void postInvoke(RequestCtx rctx) throws RemoteException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        this.bf.postInvokeRemote(rctx);
    }

    public BeanDesc getDd() {
        return this.dd;
    }

    public JFactory getBf() {
        return this.bf;
    }
}

