/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.security.jacc;

import java.net.SocketPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.security.jacc.JPolicyConfiguration;
import org.ow2.jonas.lib.security.jacc.JPolicyConfigurationKeeper;
import org.ow2.jonas.lib.security.jacc.JPolicyException;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.jonas.lib.util.Log;

public final class JPolicy
extends Policy {
    private static Logger logger = Log.getLogger("org.ow2.jonas.security");
    private static JPolicy unique = null;
    private static Policy initialPolicy = null;
    private static I18n i18n = I18n.getInstance(JPolicy.class);
    private static PolicyConfigurationFactory policyConfigurationFactory = null;

    public JPolicy() {
        initialPolicy = Policy.getPolicy();
    }

    private void initPolicyConfigurationFactory() throws JPolicyException {
        try {
            policyConfigurationFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        }
        catch (ClassNotFoundException cnfe) {
            throw new JPolicyException("PolicyConfigurationFactory class implementation was not found : '" + cnfe.getMessage() + "'.");
        }
        catch (PolicyContextException pce) {
            throw new JPolicyException("PolicyContextException in PolicyConfigurationFactory : '" + pce.getMessage() + "'.");
        }
    }

    public static JPolicy getInstance() {
        if (unique == null) {
            unique = new JPolicy();
        }
        return unique;
    }

    public boolean implies(ProtectionDomain domain, Permission permission) {
        if (permission instanceof RuntimePermission || permission instanceof SocketPermission) {
            return initialPolicy.implies(domain, permission);
        }
        String contextID = PolicyContext.getContextID();
        if (contextID == null) {
            return initialPolicy.implies(domain, permission);
        }
        if (!(permission instanceof EJBMethodPermission || permission instanceof EJBRoleRefPermission || permission instanceof WebUserDataPermission || permission instanceof WebRoleRefPermission || permission instanceof WebResourcePermission)) {
            return initialPolicy.implies(domain, permission);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("!= null, Permission being checked = " + permission));
        }
        try {
            if (policyConfigurationFactory == null) {
                this.initPolicyConfigurationFactory();
            }
            if (!policyConfigurationFactory.inService(contextID)) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"Not in service, return false");
                }
                return false;
            }
        }
        catch (JPolicyException jpe) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)i18n.getMessage("JPolicy.implies.canNotCheck", jpe.getMessage()));
            }
            return false;
        }
        catch (PolicyContextException pce) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)i18n.getMessage("JPolicy.implies.canNotCheck", pce.getMessage()));
            }
            return false;
        }
        JPolicyConfiguration jPolicyConfiguration = null;
        try {
            PolicyConfiguration pc = policyConfigurationFactory.getPolicyConfiguration(contextID, false);
            if (pc instanceof JPolicyConfiguration) {
                jPolicyConfiguration = (JPolicyConfiguration)pc;
            } else {
                jPolicyConfiguration = JPolicyConfigurationKeeper.getConfiguration(contextID);
                if (jPolicyConfiguration == null) {
                    throw new RuntimeException("This policy provider can only manage JPolicyConfiguration objects");
                }
            }
        }
        catch (PolicyContextException pce) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)i18n.getMessage("JPolicy.implies.canNotRetrieve", contextID, pce.getMessage()));
            }
            return false;
        }
        PermissionCollection excludedPermissions = jPolicyConfiguration.getExcludedPermissions();
        PermissionCollection uncheckedPermissions = jPolicyConfiguration.getUncheckedPermissions();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Check permission");
            logger.log(BasicLevel.DEBUG, (Object)("Excluded permissions = " + excludedPermissions));
            logger.log(BasicLevel.DEBUG, (Object)("unchecked permissions = " + uncheckedPermissions));
        }
        if (excludedPermissions.implies(permission)) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Permission '" + permission + "' is excluded, return false"));
            }
            return false;
        }
        if (uncheckedPermissions.implies(permission)) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Permission '" + permission + "' is unchecked, return true"));
            }
            return true;
        }
        if (domain.getPrincipals().length > 0) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"There are principals, checking principals...");
            }
            return this.isImpliedPermissionForPrincipals(jPolicyConfiguration, permission, domain.getPrincipals());
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Principals length = 0, there is no principal on this domain");
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Permission '" + permission + "' not found, return false"));
        }
        return false;
    }

    public PermissionCollection getPermissions(ProtectionDomain domain) {
        return initialPolicy.getPermissions(domain);
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        return initialPolicy.getPermissions(codeSource);
    }

    public void refresh() {
        initialPolicy.refresh();
    }

    private boolean isImpliedPermissionForPrincipals(JPolicyConfiguration jPolicyConfiguration, Permission permission, Principal[] principals) {
        PermissionCollection permissions = null;
        boolean implied = false;
        for (int i = 0; i < principals.length && !implied; ++i) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Checking permission '" + permission + "' with permissions of Principal '" + principals[i].getName() + "'."));
            }
            if (!(permissions = jPolicyConfiguration.getPermissionsForPrincipal(principals[i])).implies(permission)) continue;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Permission implied with principal '" + principals[i].getName() + "'."));
            }
            implied = true;
        }
        if (logger.isLoggable(BasicLevel.DEBUG) && !implied) {
            logger.log(BasicLevel.DEBUG, (Object)("Permission '" + permission + "' was not found in each permissions of the given roles, return false"));
        }
        return implied;
    }
}

