/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.base.factory;

import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.ws.WSServiceException;
import org.ow2.jonas.ws.base.factory.JServiceFactory;

public final class JServiceFactoryFinder {
    private static JProp props = null;
    private static ClassLoader jonasCL = Thread.currentThread().getContextClassLoader();
    private static final String JONAS_SERVICE_FACTORY = "jonas.service.ws.factory.class";
    private static String factoryClassName = null;

    private JServiceFactoryFinder() {
    }

    public static JServiceFactory getJOnASServiceFactory() throws WSServiceException {
        JServiceFactory factory = null;
        if (props == null) {
            try {
                props = JProp.getInstance();
                factoryClassName = props.getValue(JONAS_SERVICE_FACTORY);
            }
            catch (Exception e) {
                String err = "Error when trying to get jonas property 'jonas.service.ws.factory.class'";
                throw new WSServiceException(err, e);
            }
        }
        if (factoryClassName == null) {
            String err = "jonas property 'jonas.service.ws.factory.class' must be set!";
            throw new WSServiceException(err);
        }
        try {
            factory = (JServiceFactory)jonasCL.loadClass(factoryClassName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            String err = "ClassNotFound '" + factoryClassName + "' in JOnAS ClassLoader";
            throw new WSServiceException(err);
        }
        catch (InstantiationException ie) {
            String err = "Instantiation error for new '" + factoryClassName + "'";
            throw new WSServiceException(err);
        }
        catch (IllegalAccessException ie) {
            String err = "Illegal Access for new '" + factoryClassName + "'";
            throw new WSServiceException(err);
        }
        return factory;
    }
}

