/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.base.handler;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Properties;
import javax.wsdl.WSDLException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.ws.ServiceDesc;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.ws.WSServiceException;
import org.ow2.jonas.ws.base.JDefinitionWriter;
import org.ow2.jonas.ws.base.handler.WSDLHandler;

public class FileWSDLHandler
implements WSDLHandler {
    private File location;
    private Charset cs;
    private static final String OUTPUT_DIRECTORY = "jonas.service.publish.file.directory";
    private static final String ENCODING = "jonas.service.publish.file.encoding";
    private static Logger logger = Log.getLogger("org.ow2.jonas.ws");

    public FileWSDLHandler(Properties props) throws WSServiceException {
        String directory = props.getProperty(OUTPUT_DIRECTORY);
        if (directory == null) {
            String jonasBase = JProp.getJonasBase();
            directory = new File(jonasBase, "wsdls").getPath();
        }
        String encoding = props.getProperty(ENCODING, "UTF-8");
        try {
            this.location = new File(directory).getCanonicalFile();
            if (!this.location.exists()) {
                this.location.mkdirs();
            }
            this.cs = Charset.forName(encoding);
        }
        catch (IOException ioe) {
            throw new WSServiceException("cannot find/create the publishing directory '" + directory + "'", ioe);
        }
        catch (IllegalCharsetNameException icsne) {
            throw new WSServiceException("Illegal Charset '" + encoding + "'", icsne);
        }
        catch (UnsupportedCharsetException ucse) {
            throw new WSServiceException("Charset '" + encoding + "' not supported on this platform.", ucse);
        }
    }

    public void publish(ServiceDesc sd) throws WSServiceException {
        String filePath = sd.getWSDL().getName();
        String[] pathElements = filePath.split("/");
        if (pathElements.length <= 2) {
            throw new WSServiceException("invalid filename");
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 2; i < pathElements.length; ++i) {
            buf.append(pathElements[i]);
            if (i == pathElements.length - 1) continue;
            buf.append(File.separator);
        }
        String fileName = buf.toString();
        logger.log(BasicLevel.DEBUG, (Object)("Attempting to publish '" + fileName + "'"));
        File sLoc = null;
        File pubDirectory = sd.getPublicationDirectory();
        sLoc = pubDirectory == null ? new File(this.location, sd.getName()) : pubDirectory;
        try {
            sLoc = sLoc.getCanonicalFile();
            logger.log(BasicLevel.DEBUG, (Object)("Publishing into directory '" + sLoc + "'"));
            this.createDirIfNeeded(sLoc);
            JDefinitionWriter jdw = new JDefinitionWriter(sd.getWSDL().getDefinition(), sLoc, this.cs, fileName);
            jdw.write();
        }
        catch (IOException ioe) {
            throw new WSServiceException("Error with writer of file '" + fileName + "'", ioe);
        }
        catch (WSDLException we) {
            throw new WSServiceException("Error with wsdl file '" + filePath + "' publishing in directory '" + this.location + "'", we);
        }
    }

    private void createDirIfNeeded(File file) throws IOException {
        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new IOException("Cannot create directory " + file.getCanonicalPath());
            }
        } else if (!file.isDirectory()) {
            throw new IOException("Parent " + file.getCanonicalPath() + " already exists but is not a directory.");
        }
    }
}

