/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.event.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.event.api.IEventListener;
import org.ow2.util.event.api.IEventProvider;
import org.ow2.util.event.api.IEventService;
import org.ow2.util.event.api.IEventToken;
import org.ow2.util.event.api.exception.EventFilterMalformed;
import org.ow2.util.event.api.exception.EventIdAlreadyExists;
import org.ow2.util.event.api.exception.EventIdMalformed;
import org.ow2.util.event.api.exception.EventIdNotExists;
import org.ow2.util.event.impl.EventDispatcher;

public class EventService
implements IEventService {
    private boolean available;
    private EventProvider rootProvider;
    private EventDispatcher rootDispatcher;
    private HashMap<String, EventProvider> providers;
    private HashMap<IEventListener, String> filters;

    public EventService() {
        this.start();
    }

    public synchronized IEventProvider createProvider(String id) throws EventIdMalformed, EventIdAlreadyExists {
        if (!this.available) {
            throw new IllegalStateException();
        }
        if (this.providers.containsKey(id)) {
            throw new EventIdAlreadyExists();
        }
        EventProvider provider = new EventProvider(id);
        this.providers.put(id, provider);
        return provider;
    }

    public synchronized void destroyProvider(String id) throws EventIdNotExists {
        if (!this.available) {
            throw new IllegalStateException();
        }
        EventProvider provider = this.providers.remove(id);
        if (provider != null) {
            while (!this.providers.containsKey(provider.parent.id)) {
                provider = provider.parent;
            }
        } else {
            throw new EventIdNotExists();
        }
        provider.destroy();
    }

    public synchronized void registerListener(IEventListener listener, String filter) throws EventFilterMalformed {
        if (!this.available) {
            throw new IllegalStateException();
        }
        if (!filter.matches("(/[\\w\\*]+)+")) {
            throw new EventFilterMalformed();
        }
        String newregexp = filter.replaceAll("\\*\\*", "[/\\\\w]#").replaceAll("\\*", "\\\\w#").replaceAll("#", "*");
        String oldregexp = this.filters.put(listener, newregexp);
        for (Map.Entry<String, EventProvider> entry : this.providers.entrySet()) {
            if (oldregexp != null && entry.getKey().matches(oldregexp)) {
                entry.getValue().removeListener(listener);
            }
            if (!entry.getKey().matches(newregexp)) continue;
            entry.getValue().addListener(listener);
        }
    }

    public synchronized void unregisterListener(IEventListener listener) {
        if (!this.available) {
            throw new IllegalStateException();
        }
        String oldregexp = this.filters.remove(listener);
        if (oldregexp != null) {
            for (Map.Entry<String, EventProvider> entry : this.providers.entrySet()) {
                if (!entry.getKey().matches(oldregexp)) continue;
                entry.getValue().removeListener(listener);
            }
        }
    }

    public synchronized void start() {
        if (!this.available) {
            this.available = true;
            this.rootDispatcher = new EventDispatcher();
            this.rootDispatcher.start();
            this.rootProvider = new EventProvider();
            this.rootProvider.setDispatcher(this.rootDispatcher);
            this.providers = new HashMap();
            this.providers.put("/", this.rootProvider);
            this.filters = new HashMap();
        }
    }

    public synchronized void stop() {
        if (this.available) {
            this.available = false;
            this.filters.clear();
            this.filters = null;
            this.providers.clear();
            this.providers = null;
            this.rootProvider.destroy();
            this.rootProvider = null;
            this.rootDispatcher.stop();
            this.rootDispatcher = null;
        }
    }

    private final class EventProvider
    implements IEventProvider {
        private String id;
        private IEventDispatcher dispatcher;
        private List<IEventListener> listeners;
        private EventProvider parent;
        private Map<String, EventProvider> childs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EventProvider() {
            EventService eventService2 = EventService.this;
            synchronized (eventService2) {
                this.id = "/";
                this.dispatcher = new EventDispatcher();
                this.listeners = new LinkedList<IEventListener>();
                this.parent = null;
                this.childs = new HashMap<String, EventProvider>();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EventProvider(String id) throws EventIdMalformed, EventIdAlreadyExists {
            EventService eventService2 = EventService.this;
            synchronized (eventService2) {
                if (!id.matches("(/\\w+)+")) {
                    throw new EventIdMalformed();
                }
                String parentId = id.substring(0, id.lastIndexOf("/"));
                EventProvider parent = parentId.equals("") ? EventService.this.rootProvider : (EventProvider)EventService.this.providers.get(parentId);
                this.id = id;
                this.parent = parent == null ? new EventProvider(parentId) : parent;
                this.childs = new HashMap<String, EventProvider>();
                this.dispatcher = this.parent.dispatcher;
                this.listeners = new LinkedList<IEventListener>();
                this.parent.childs.put(id, this);
                for (Map.Entry entry : EventService.this.filters.entrySet()) {
                    if (!this.id.matches((String)entry.getValue())) continue;
                    this.addListener((IEventListener)entry.getKey());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void destroy() {
            EventService eventService = EventService.this;
            synchronized (eventService) {
                for (IEventListener listener : this.listeners) {
                    this.dispatcher.removeListener(listener);
                }
                for (EventProvider child : this.childs.values()) {
                    child.destroy();
                }
                if (this.parent != null) {
                    this.parent.childs.remove(this.id);
                    this.parent = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getId() {
            EventService eventService = EventService.this;
            synchronized (eventService) {
                return this.id;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(IEventListener listener) {
            EventService eventService = EventService.this;
            synchronized (eventService) {
                this.listeners.add(listener);
                this.dispatcher.addListener(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IEventToken dispatch(IEvent event) {
            EventService eventService = EventService.this;
            synchronized (eventService) {
                return this.dispatcher.dispatch(event);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IEventToken dispatch(IEvent event, long timeout) {
            EventService eventService = EventService.this;
            synchronized (eventService) {
                return this.dispatcher.dispatch(event, timeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(IEventListener listener) {
            EventService eventService = EventService.this;
            synchronized (eventService) {
                this.listeners.remove(listener);
                this.dispatcher.removeListener(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IEventDispatcher getDispatcher() {
            EventService eventService = EventService.this;
            synchronized (eventService) {
                return this.dispatcher;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDispatcher(IEventDispatcher dispatcher) {
            EventService eventService = EventService.this;
            synchronized (eventService) {
                IEventDispatcher newDispatcher;
                IEventDispatcher oldDispatcher = this.dispatcher;
                this.dispatcher = newDispatcher = dispatcher == null ? this.parent.dispatcher : dispatcher;
                for (IEventListener listener : this.listeners) {
                    newDispatcher.addListener(listener);
                    oldDispatcher.removeListener(listener);
                }
                for (EventProvider child : this.childs.values()) {
                    if (child.dispatcher != oldDispatcher) continue;
                    child.setDispatcher(newDispatcher);
                }
            }
        }
    }
}

