/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.scan.api.metadata.structures;

import java.util.Arrays;

public final class JMethod {
    private String name = null;
    private int access;
    private String descriptor = null;
    private String signature;
    private final String[] exceptions;

    public JMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.access = access;
        this.name = name;
        this.descriptor = descriptor;
        this.signature = signature;
        String[] tmpExceptions = exceptions;
        this.exceptions = tmpExceptions != null ? (String[])tmpExceptions.clone() : null;
    }

    public int getAccess() {
        return this.access;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof JMethod) {
            JMethod other = (JMethod)obj;
            if (!this.name.equals(other.name)) {
                return false;
            }
            return this.descriptor == null || this.descriptor.equals(other.descriptor);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String[] getExceptions() {
        return this.exceptions;
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.signature;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1));
        sb.append("[name=");
        sb.append(this.name);
        sb.append(", access=");
        sb.append(this.access);
        if (this.descriptor != null) {
            sb.append(", descriptor=");
            sb.append(this.descriptor);
        }
        if (this.signature != null) {
            sb.append(", signature=");
            sb.append(this.signature);
        }
        if (this.exceptions != null) {
            sb.append(", exceptions=");
            sb.append(Arrays.asList(this.exceptions));
        }
        sb.append("]");
        return sb.toString();
    }
}

