/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.jmbeans;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.management.javaee.J2EEManagedObject;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.properties.ServerProperties;

public class JavaVm
extends J2EEManagedObject {
    private static final String JAVA_VERSION = "java.version";
    private static final String JAVA_VENDOR = "java.vendor";
    private static final String JAVA_VM_NAME = "java.vm.name";
    private static final String JAVA_VM_VERSION = "java.vm.version";
    private static final String NODE_LOCAL = "localhost";
    private static final String JAVA_HOME = "java.home";
    private static Logger sLogger = null;
    private String javaVersion = null;
    private String javaVendor = null;
    private String node = null;
    private String javaHome = null;

    public JavaVm(String pObjectName, ServerProperties props) {
        super(pObjectName);
        this.javaVersion = props.getValue(JAVA_VERSION);
        this.javaVendor = props.getValue(JAVA_VM_NAME) + "-" + props.getValue(JAVA_VM_VERSION) + " / " + props.getValue(JAVA_VENDOR);
        this.javaHome = props.getValue(JAVA_HOME);
        try {
            InetAddress oInet = InetAddress.getLocalHost();
            this.node = oInet.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            this.node = NODE_LOCAL;
        }
        sLogger = Log.getLogger((String)"org.ow2.jonas.server");
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getJavaVendor() {
        return this.javaVendor;
    }

    public String getNode() {
        return this.node;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    protected ThreadGroup getTopLevelThreadGroup() {
        ThreadGroup parentg = null;
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while ((parentg = tg.getParent()) != null) {
            tg = parentg;
        }
        return tg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAllThreadsCount() {
        ThreadGroup tg = this.getTopLevelThreadGroup();
        int realnbthread = 0;
        JavaVm javaVm = this;
        synchronized (javaVm) {
            int count = tg.activeCount();
            sLogger.log(BasicLevel.DEBUG, (Object)("number of active threads = " + count));
            Thread[] array = new Thread[count];
            tg.enumerate(array, true);
            for (int j = 0; j < count; ++j) {
                if (array[j] == null) continue;
                ++realnbthread;
            }
        }
        return realnbthread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getThreadGroups() {
        ThreadGroup tg = this.getTopLevelThreadGroup();
        Vector<String> v = new Vector<String>();
        JavaVm javaVm = this;
        synchronized (javaVm) {
            int counttg = tg.activeGroupCount();
            ThreadGroup[] array = new ThreadGroup[counttg];
            v.addElement(tg.getName());
            tg.enumerate(array, true);
            for (int i = 0; i < counttg; ++i) {
                if (array[i] == null) continue;
                v.addElement(array[i].getName());
            }
        }
        Object[] ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listThreads(String name) {
        ThreadGroup tg = this.getTopLevelThreadGroup();
        Vector<String> v = new Vector<String>();
        Object[] ret = null;
        JavaVm javaVm = this;
        synchronized (javaVm) {
            int counttg = tg.activeGroupCount();
            ThreadGroup[] array = new ThreadGroup[counttg];
            tg.enumerate(array, true);
            for (int i = 0; i < counttg; ++i) {
                if (!array[i].getName().equals(name)) continue;
                int counth = tg.activeCount();
                Thread[] tharray = new Thread[counth];
                array[i].enumerate(tharray);
                for (int j = 0; j < counth; ++j) {
                    if (tharray[j] == null) continue;
                    v.addElement(tharray[j].getName());
                }
                ret = new String[v.size()];
                v.copyInto(ret);
                break;
            }
        }
        return ret;
    }
}

