/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.HandlerFactory;
import org.objectweb.util.monolog.api.LevelFactory;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.objectweb.util.monolog.api.MonologFactory;
import org.objectweb.util.monolog.file.DottedStringTools;
import org.objectweb.util.monolog.file.monolog.PropertiesConfAccess;
import org.objectweb.util.monolog.wrapper.printwriter.PrintWriterImpl;
import org.ow2.jonas.lib.bootstrap.JProp;

public class Log {
    private static String configFile = "trace";
    private static LoggerFactory lf = null;
    private static Properties props = null;
    private static String configFileName = null;
    public static final String JONAS_ADMIN_PREFIX = "org.ow2.jonas.admin";
    public static final String JONAS_BOOTSTRAP_PREFIX = "org.ow2.jonas.bootstrap";
    public static final String JONAS_CLUSTER_DAEMON = "org.ow2.jonas.cluster.daemon";
    public static final String JONAS_DB_PREFIX = "org.ow2.jonas.db";
    public static final String JONAS_DBM_PREFIX = "org.ow2.jonas.dbm";
    public static final String JONAS_DEPLOY_PREFIX = "org.ow2.jonas.deployment";
    public static final String JONAS_DISCOVERY_PREFIX = "org.ow2.jonas.discovery";
    public static final String JONAS_EAR_PREFIX = "org.ow2.jonas.ear";
    public static final String JONAS_EJB_PREFIX = "org.ow2.jonas.ejb";
    public static final String SPY_LOGGER_NAME = "org.ow2.jonas.ee.jdbc.sql";
    public static final String JONAS_JAXR_PREFIX = "org.ow2.jonas.ee.scout";
    public static final String JONAS_GENBASE_PREFIX = "org.ow2.jonas.generators.genbase";
    public static final String JONAS_GENIC_PREFIX = "org.ow2.jonas.generators.genic";
    public static final String JONAS_GENIC_VELOCITY_PREFIX = "org.ow2.jonas.generators.genic.velocity";
    public static final String JONAS_WSGEN_PREFIX = "org.ow2.jonas.generators.wsgen";
    public static final String JONAS_WSGEN_EWS_PREFIX = "org.ow2.jonas.generators.wsgen.ews";
    public static final String JONAS_JCA_PREFIX = "org.ow2.jonas.jca";
    public static final String JONAS_JMX_PREFIX = "org.ow2.jonas.jmx";
    public static final String JONAS_WORK_MGR_PREFIX = "org.ow2.jonas.lib.work";
    public static final String JONAS_LOADER_PREFIX = "org.ow2.jonas.loader";
    public static final String JONAS_MAIL_PREFIX = "org.ow2.jonas.mail";
    public static final String JONAS_MANAGEMENT_PREFIX = "org.ow2.jonas.management";
    public static final String JONAS_MANAGEMENT_EVENT_PREFIX = "org.ow2.jonas.management.event";
    public static final String JONAS_NAMING_PREFIX = "org.ow2.jonas.naming";
    public static final String JONAS_PROPCTX_PREFIX = "org.ow2.jonas.propagation";
    public static final String JONAS_REGISTRY_PREFIX = "org.ow2.jonas.registry";
    public static final String JONAS_SECURITY_PREFIX = "org.ow2.jonas.security";
    public static final String JONAS_CSIV2_SECURITY_PREFIX = "org.ow2.jonas.security.csiv2";
    public static final String JONAS_CSIV2_DETAILS_SECURITY_PREFIX = "org.ow2.jonas.security.csiv2_details";
    public static final String JONAS_JACC_SECURITY_PREFIX = "org.ow2.jonas.security.jacc";
    public static final String JONAS_WS_SECURITY_PREFIX = "org.ow2.jonas.security.ws";
    public static final String JONAS_SERVER_PREFIX = "org.ow2.jonas.server";
    public static final String JONAS_WEB_PREFIX = "org.ow2.jonas.web";
    public static final String JONAS_DEPLOY_WORK_PREFIX = "org.ow2.jonas.work";
    public static final String JONAS_TESTS_PREFIX = "org.ow2.jonas_tests";
    private static final String HANDLER_OUTPUT_ATTRIBUTE = "output";
    private static final String AUTOMATIC_CONFIG = "automatic";
    private static final String LOG_DIRECTORY = "logs";
    private static final String TIMESTAMP_FORMAT = "-yyyy-MM-dd";
    private static final String SUFFIX_LOGFILE = "log";
    private static final String DEFAULT_LOGGERFACTORY = "org.objectweb.util.monolog.wrapper.javaLog.LoggerFactory";
    private static boolean clientcontainer = false;
    private static final String JPROP_CLASSNAME = "org.ow2.jonas.lib.bootstrap.JProp";
    private static String JMX_HANDLER_TYPE = "jmx";

    private Log() {
    }

    public static void configure(String file) {
        configFile = file;
        Log.getLoggerFactory();
        if (!clientcontainer) {
            // empty if block
        }
    }

    public static Handler getJmxHandler() {
        Handler[] handlers = Monolog.getMonologFactory().getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            if (!handler.getType().equals(JMX_HANDLER_TYPE)) continue;
            return handler;
        }
        return null;
    }

    public static Handler getHandler(String handlerName) {
        Handler[] handlers = Monolog.getMonologFactory().getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            String handType = handler.getType();
            String handName = handler.getName();
            String[] attNames = handler.getAttributeNames();
        }
        return Monolog.getMonologFactory().getHandler(handlerName);
    }

    public static synchronized LoggerFactory getLoggerFactory() {
        if (lf == null) {
            try {
                if (Log.isClient()) {
                    clientcontainer = true;
                    InputStream is = null;
                    String traceClient = System.getProperty("jonas.client.trace.file");
                    if (traceClient != null) {
                        try {
                            is = new FileInputStream(new File(traceClient));
                        }
                        catch (FileNotFoundException fne) {
                            System.err.println("Can not init logger with the supplied file '" + traceClient + "'" + ", this file doesn't exist. Init with default values.");
                        }
                    } else {
                        is = Thread.currentThread().getContextClassLoader().getResourceAsStream("traceclient.properties");
                    }
                    if (is == null) {
                        props = new Properties();
                        props.put("log.config.classname", DEFAULT_LOGGERFACTORY);
                        props.put("logger.root.level", "INFO");
                    } else {
                        props = new Properties();
                        props.load(is);
                    }
                    lf = Monolog.getMonologFactory((Properties)props);
                    return lf;
                }
                JProp jProp = null;
                try {
                    jProp = JProp.getInstance();
                    JProp.getInstance(configFile);
                }
                catch (Exception e) {
                    System.err.println("Can't read jonas.properties. Check that you have defined a $JONAS_BASE variable");
                }
                props = JProp.getInstance(configFile).getConfigFileEnv();
                configFileName = JProp.getInstance(configFile).getPropFileName();
                String jonasBase = null;
                String nameOfServer = null;
                if (jProp != null) {
                    jonasBase = JProp.getJonasBase();
                    nameOfServer = jProp.getValue("jonas.name", "jonas");
                } else {
                    jonasBase = ".";
                    nameOfServer = "jonas";
                }
                File logFirFile = new File(jonasBase + File.separator + LOG_DIRECTORY);
                Properties updatedProps = null;
                SimpleDateFormat sdf = new SimpleDateFormat(TIMESTAMP_FORMAT);
                String date = sdf.format(new Date());
                int nbAut = 0;
                File logFile = null;
                Enumeration<Object> keys = props.keys();
                while (keys.hasMoreElements()) {
                    String temp;
                    String key = (String)keys.nextElement();
                    if (key == null || !key.startsWith("handler") || (temp = DottedStringTools.getFirst((String)key)) == null || (temp = DottedStringTools.getEnd((String)key)) == null) continue;
                    String handlerName = DottedStringTools.getBegin((String)temp);
                    String stringType = props.getProperty("handler." + handlerName + '.' + "type", null);
                    String stringOutput = props.getProperty("handler." + handlerName + '.' + HANDLER_OUTPUT_ATTRIBUTE, null);
                    if (stringType == null || stringOutput == null || !"file".equalsIgnoreCase(stringType) && !"rollingfile".equalsIgnoreCase(stringType)) continue;
                    if (stringOutput.equalsIgnoreCase(AUTOMATIC_CONFIG)) {
                        String fileName = null;
                        if (nbAut > 0) {
                            fileName = nameOfServer + date + '.' + nbAut + '.' + SUFFIX_LOGFILE;
                        } else {
                            updatedProps = (Properties)props.clone();
                            fileName = nameOfServer + date + '.' + SUFFIX_LOGFILE;
                        }
                        logFile = logFirFile.exists() ? new File(logFirFile, fileName) : new File(fileName);
                        updatedProps.setProperty("handler." + handlerName + '.' + HANDLER_OUTPUT_ATTRIBUTE, logFile.getPath());
                        ++nbAut;
                        continue;
                    }
                    logFile = new File(stringOutput);
                    if (logFile.isAbsolute()) continue;
                    logFile = logFirFile.exists() ? new File(logFirFile, stringOutput) : new File(stringOutput);
                    if (nbAut == 0) {
                        updatedProps = (Properties)props.clone();
                        ++nbAut;
                    }
                    if (stringOutput.endsWith(".automatic") || stringOutput.endsWith(".auto")) {
                        String autoStr = logFile.getPath().substring(0, logFile.getPath().lastIndexOf(46)) + date + '.' + ++nbAut + '.' + SUFFIX_LOGFILE;
                        logFile = new File(autoStr);
                    }
                    updatedProps.setProperty("handler." + handlerName + '.' + HANDLER_OUTPUT_ATTRIBUTE, logFile.getPath());
                }
                String b = props.getProperty("log.config.classname", null);
                if (b == null) {
                    System.err.println("Malformed configuration log file: log.config.classname not available");
                    return null;
                }
                lf = (LoggerFactory)Class.forName(b).newInstance();
                if (updatedProps == null) {
                    PropertiesConfAccess.load((Properties)props, (LoggerFactory)lf, (HandlerFactory)((HandlerFactory)lf), (LevelFactory)((LevelFactory)lf));
                } else {
                    PropertiesConfAccess.load(updatedProps, (LoggerFactory)lf, (HandlerFactory)((HandlerFactory)lf), (LevelFactory)((LevelFactory)lf));
                }
                Monolog.monologFactory = (MonologFactory)lf;
            }
            catch (Exception e) {
                System.err.println("Cannot get LoggerFactory:" + e);
                e.printStackTrace();
            }
        }
        return lf;
    }

    private static boolean isClient() {
        boolean hasJonasBase = System.getProperty("jonas.base") != null;
        boolean hasJonasRoot = System.getProperty("jonas.root") != null;
        boolean hasJProp = true;
        try {
            Log.class.getClassLoader().loadClass(JPROP_CLASSNAME);
        }
        catch (ClassNotFoundException cnfe) {
            hasJProp = false;
        }
        return !hasJProp || !hasJonasBase || !hasJonasRoot;
    }

    public static void reset() {
        lf = null;
    }

    public static PrintWriter getLogWriter(String topic) {
        return new PrintWriterImpl(Log.getLogger(topic), Log.getLoggerFactory());
    }

    public static LevelFactory getLevelFactory() {
        return (LevelFactory)Log.getLoggerFactory();
    }

    public static Logger getLogger(String topic) {
        return Log.getLoggerFactory().getLogger(topic);
    }

    public static Properties getProperties() {
        return props;
    }

    public static String getConfigFileName() {
        return configFileName;
    }

    public static void setConfigFileName(String configFileName) {
        Log.configFileName = configFileName;
    }
}

