/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis;

import java.lang.reflect.Method;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.rpc.handler.MessageContext;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.i18n.Messages;
import org.apache.axis.providers.java.RPCProvider;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.ejb21.JServiceEndpoint;
import org.ow2.jonas.lib.ejb21.JServiceEndpointHome;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.security.ws.SecurityContextHelper;

public class JOnASEJBProvider
extends RPCProvider {
    private static final long serialVersionUID = -3754705462547648319L;
    private static Logger logger = null;
    public static final String OPTION_SEINTERFACENAME = "serviceEndpointInterfaceName";
    public static final String OPTION_SEJNDINAME = "serviceEndpointJndiName";
    private static InitialContext cachedContext;

    public JOnASEJBProvider() {
        logger = Log.getLogger((String)"org.ow2.jonas.lib.ejb21.endpoint");
        logger.log(BasicLevel.DEBUG, (Object)"");
    }

    protected Object makeNewServiceObject(org.apache.axis.MessageContext msgContext, String seiName) throws Exception {
        logger.log(BasicLevel.DEBUG, (Object)seiName);
        if (seiName == null) {
            logger.log(BasicLevel.ERROR, (Object)"Service Endpoint Interface classname is null");
            throw new AxisFault(Messages.getMessage((String)"noOption00", (String)OPTION_SEINTERFACENAME, (String)msgContext.getService().getName()));
        }
        String jndiName = this.getStrOption(OPTION_SEJNDINAME, (Handler)msgContext.getService());
        if (jndiName == null) {
            logger.log(BasicLevel.ERROR, (Object)"Service Endpoint JNDI name is null");
            throw new AxisFault("Missing parameter in service : serviceEndpointJndiName");
        }
        JServiceEndpointHome sehome = null;
        try {
            InitialContext ic = this.getCachedContext();
            sehome = (JServiceEndpointHome)ic.lookup(jndiName);
        }
        catch (NamingException ne) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot lookup ServiceEndpointHome");
            throw new AxisFault("Cannot lookup ServiceEndpointHome: " + jndiName);
        }
        JServiceEndpoint se = sehome.create();
        se.setMessageContext((MessageContext)msgContext);
        return se;
    }

    protected Object invokeMethod(org.apache.axis.MessageContext msgContext, Method method, Object obj, Object[] argValues) throws Exception {
        logger.log(BasicLevel.DEBUG, (Object)"");
        String username = msgContext.getUsername();
        if (username != null) {
            SecurityContextHelper.getInstance().login(username, msgContext.getPassword());
        }
        return super.invokeMethod(msgContext, method, obj, argValues);
    }

    protected String getServiceClassNameOptionName() {
        logger.log(BasicLevel.DEBUG, (Object)"");
        return OPTION_SEINTERFACENAME;
    }

    private String getStrOption(String optionName, Handler service) {
        String value = null;
        if (service != null) {
            value = (String)service.getOption(optionName);
        }
        if (value == null) {
            value = (String)this.getOption(optionName);
        }
        return value;
    }

    private InitialContext getCachedContext() throws NamingException {
        if (cachedContext == null) {
            cachedContext = new InitialContext();
        }
        return cachedContext;
    }
}

