/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.ArrayTypeSpec;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.CharType;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Declaration;
import org.jacorb.idl.FixedPointType;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.Operation;
import org.jacorb.idl.ParamDecl;
import org.jacorb.idl.RaisesExpr;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.StringType;
import org.jacorb.idl.StructType;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.VoidTypeSpec;
import org.jacorb.idl.parser;

public class OpDecl
extends Declaration
implements Operation {
    public static final int NO_ATTRIBUTE = 0;
    public static final int ONEWAY = 1;
    public int opAttribute;
    public TypeSpec opTypeSpec;
    public Vector paramDecls;
    public RaisesExpr raisesExpr;
    public IdlSymbol myInterface;

    public OpDecl(int n) {
        super(n);
        this.paramDecls = new Vector();
    }

    public OpDecl(IdlSymbol idlSymbol, int n, TypeSpec typeSpec, String string, List list, RaisesExpr raisesExpr) {
        super(OpDecl.new_num());
        this.myInterface = idlSymbol;
        this.opAttribute = n;
        this.opTypeSpec = typeSpec;
        this.name = string;
        this.paramDecls = new Vector(list);
        this.raisesExpr = raisesExpr;
        this.setEnclosingSymbol(idlSymbol);
        this.pack_name = idlSymbol.full_name();
    }

    public OpDecl(IdlSymbol idlSymbol, String string, List list) {
        this(idlSymbol, 0, new VoidTypeSpec(OpDecl.new_num()), string, list, new RaisesExpr(OpDecl.new_num()));
    }

    public void setPackage(String string) {
        string = parser.pack_replace(string);
        this.pack_name = this.pack_name.length() > 0 ? string + "." + this.pack_name : string;
        this.opTypeSpec.setPackage(string);
        Enumeration enumeration = this.paramDecls.elements();
        while (enumeration.hasMoreElements()) {
            ((ParamDecl)enumeration.nextElement()).setPackage(string);
        }
        this.raisesExpr.setPackage(string);
    }

    public void setEnclosingSymbol(IdlSymbol idlSymbol) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("opDecl.setEnclosingSymbol " + idlSymbol);
        }
        if (this.enclosing_symbol != null && this.enclosing_symbol != idlSymbol) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        if (idlSymbol == null) {
            throw new RuntimeException("Compiler Error: enclosing symbol is null!");
        }
        this.enclosing_symbol = idlSymbol;
        this.raisesExpr.setEnclosingSymbol(idlSymbol);
    }

    public void parse() {
        if (this.enclosing_symbol == null) {
            throw new RuntimeException("Compiler Error: enclosing symbol in parse is null!");
        }
        this.myInterface = this.enclosing_symbol;
        if (this.opAttribute == 1) {
            if (!this.raisesExpr.empty()) {
                parser.error("Oneway operation " + this.full_name() + " may not define a raises clause.", this.token);
            }
            if (!(this.opTypeSpec.typeSpec() instanceof VoidTypeSpec)) {
                parser.error("Oneway operation " + this.full_name() + " may only define void as return type.", this.token);
            }
        }
        try {
            NameTable.define(this.full_name(), "operation");
        }
        catch (NameAlreadyDefined nameAlreadyDefined) {
            parser.error("Operation " + this.full_name() + " already defined", this.token);
        }
        Object object = this.paramDecls.elements();
        while (object.hasMoreElements()) {
            ParamDecl paramDecl = (ParamDecl)object.nextElement();
            paramDecl.parse();
            try {
                NameTable.define(this.full_name() + "." + paramDecl.simple_declarator.name(), "argument");
            }
            catch (NameAlreadyDefined nameAlreadyDefined) {
                parser.error("Argument " + paramDecl.simple_declarator.name() + " already defined in operation " + this.full_name(), this.token);
            }
            if (paramDecl.paramAttribute != 1) {
                this.myInterface.addImportedNameHolder(paramDecl.paramTypeSpec.holderName());
            }
            if (!(paramDecl.paramTypeSpec.typeSpec() instanceof BaseType)) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("classname: " + paramDecl.paramTypeSpec.typeSpec().getClass().getName());
                }
                this.myInterface.addImportedName(paramDecl.paramTypeSpec.typeSpec().full_name(), paramDecl.paramTypeSpec.typeSpec());
            }
            if (!(paramDecl.paramTypeSpec.typeSpec() instanceof ConstrTypeSpec) || !(((ConstrTypeSpec)paramDecl.paramTypeSpec.typeSpec()).c_type_spec instanceof StructType) || !((StructType)((ConstrTypeSpec)paramDecl.paramTypeSpec.typeSpec()).c_type_spec).exc) continue;
            parser.error("Can't pass an exception as a parameter.");
        }
        if (this.opTypeSpec.typeSpec() instanceof ScopedName) {
            object = ((ScopedName)this.opTypeSpec.typeSpec()).resolvedTypeSpec();
            if (object != null) {
                this.opTypeSpec = object;
            }
            this.myInterface.addImportedName(this.opTypeSpec.typeName());
        }
        this.raisesExpr.parse();
    }

    public void print(PrintWriter printWriter) {
        if (this.is_pseudo) {
            printWriter.print("\tpublic abstract " + this.opTypeSpec.toString());
        } else {
            printWriter.print("\t" + this.opTypeSpec.toString());
        }
        printWriter.print(" ");
        printWriter.print(this.name);
        printWriter.print("(");
        Enumeration enumeration = this.paramDecls.elements();
        if (enumeration.hasMoreElements()) {
            ((ParamDecl)enumeration.nextElement()).print(printWriter);
        }
        while (enumeration.hasMoreElements()) {
            printWriter.print(", ");
            ((ParamDecl)enumeration.nextElement()).print(printWriter);
        }
        printWriter.print(")");
        this.raisesExpr.print(printWriter);
        printWriter.println(";");
    }

    public void printMethod(PrintWriter printWriter, String string, boolean bl, boolean bl2) {
        String[] stringArray;
        String string2 = this.name.startsWith("_") ? this.name.substring(1) : this.name;
        printWriter.print("\tpublic " + this.opTypeSpec.toString() + " " + this.name + "(");
        Enumeration enumeration = this.paramDecls.elements();
        if (enumeration.hasMoreElements()) {
            ((ParamDecl)enumeration.nextElement()).print(printWriter);
        }
        while (enumeration.hasMoreElements()) {
            printWriter.print(", ");
            ((ParamDecl)enumeration.nextElement()).print(printWriter);
        }
        printWriter.print(")");
        this.raisesExpr.print(printWriter);
        printWriter.println("\n\t{");
        printWriter.println("\t\twhile(true)");
        printWriter.println("\t\t{");
        if (!bl) {
            String[] stringArray2;
            printWriter.println("\t\tif(! this._is_local())");
            printWriter.println("\t\t{");
            printWriter.println("\t\t\torg.omg.CORBA.portable.InputStream _is = null;");
            printWriter.println("\t\t\ttry");
            printWriter.println("\t\t\t{");
            printWriter.print("\t\t\t\torg.omg.CORBA.portable.OutputStream _os = _request( \"" + string2 + "\",");
            if (this.opAttribute == 0) {
                printWriter.println(" true);");
            } else {
                printWriter.println(" false);");
            }
            enumeration = this.paramDecls.elements();
            while (enumeration.hasMoreElements()) {
                stringArray = (ParamDecl)enumeration.nextElement();
                if (stringArray.paramAttribute == 2) continue;
                printWriter.println("\t\t\t\t" + stringArray.printWriteStatement("_os"));
            }
            printWriter.println("\t\t\t\t_is = _invoke(_os);");
            if (this.opAttribute == 0 && !(this.opTypeSpec.typeSpec() instanceof VoidTypeSpec)) {
                printWriter.println("\t\t\t\t" + this.opTypeSpec.toString() + " _result = " + this.opTypeSpec.typeSpec().printReadExpression("_is") + ";");
            }
            stringArray = this.paramDecls.elements();
            while (stringArray.hasMoreElements()) {
                stringArray2 = (String[])stringArray.nextElement();
                if (stringArray2.paramAttribute == 1) continue;
                printWriter.println("\t\t\t\t" + stringArray2.simple_declarator + ".value = " + stringArray2.printReadExpression("_is") + ";");
            }
            if (this.opAttribute == 0 && !(this.opTypeSpec.typeSpec() instanceof VoidTypeSpec)) {
                printWriter.println("\t\t\t\treturn _result;");
            } else {
                printWriter.println("\t\t\t\treturn;");
            }
            printWriter.println("\t\t\t}");
            printWriter.println("\t\t\tcatch( org.omg.CORBA.portable.RemarshalException _rx ){}");
            printWriter.println("\t\t\tcatch( org.omg.CORBA.portable.ApplicationException _ax )");
            printWriter.println("\t\t\t{");
            printWriter.println("\t\t\t\tString _id = _ax.getId();");
            if (!this.raisesExpr.empty()) {
                stringArray = this.raisesExpr.getExceptionIds();
                stringArray2 = this.raisesExpr.getExceptionClassNames();
                printWriter.print("\t\t\t\t");
                for (int i = 0; i < stringArray.length; ++i) {
                    printWriter.println("if( _id.equals(\"" + stringArray[i] + "\"))");
                    printWriter.println("\t\t\t\t{");
                    printWriter.println("\t\t\t\t\tthrow " + stringArray2[i] + "Helper.read(_ax.getInputStream());");
                    printWriter.println("\t\t\t\t}");
                    printWriter.print("\t\t\t\telse ");
                }
                printWriter.print("\n\t");
            }
            printWriter.println("\t\t\t\tthrow new RuntimeException(\"Unexpected exception \" + _id );");
            printWriter.println("\t\t\t}");
            printWriter.println("\t\t\tfinally");
            printWriter.println("\t\t\t{");
            printWriter.println("\t\t\t\tthis._releaseReply(_is);");
            printWriter.println("\t\t\t}");
            printWriter.println("\t\t}");
            printWriter.println("\t\telse");
            printWriter.println("\t\t{");
        }
        printWriter.println("\t\t\torg.omg.CORBA.portable.ServantObject _so = _servant_preinvoke( \"" + string2 + "\", _opsClass );");
        printWriter.println("\t\t\tif( _so == null )");
        printWriter.println("\t\t\t\tthrow new org.omg.CORBA.UNKNOWN(\"local invocations not supported!\");");
        if (bl2) {
            printWriter.println("\t\t\t" + string + " _localServant = (" + string + ")_so.servant;");
        } else {
            printWriter.println("\t\t\t" + string + "Operations _localServant = (" + string + "Operations)_so.servant;");
        }
        if (this.opAttribute == 0 && !(this.opTypeSpec.typeSpec() instanceof VoidTypeSpec)) {
            printWriter.print("\t\t\t" + this.opTypeSpec.toString() + " _result;");
        }
        printWriter.println("\t\t\ttry");
        printWriter.println("\t\t\t{");
        if (this.opAttribute == 0 && !(this.opTypeSpec.typeSpec() instanceof VoidTypeSpec)) {
            printWriter.print("\t\t\t_result = ");
        } else {
            printWriter.print("\t\t\t");
        }
        printWriter.print("_localServant." + this.name + "(");
        enumeration = this.paramDecls.elements();
        while (enumeration.hasMoreElements()) {
            stringArray = (ParamDecl)enumeration.nextElement();
            printWriter.print(stringArray.simple_declarator.toString());
            if (!enumeration.hasMoreElements()) continue;
            printWriter.print(",");
        }
        printWriter.println(");");
        printWriter.println("\t\t\t}");
        printWriter.println("\t\t\tfinally");
        printWriter.println("\t\t\t{");
        printWriter.println("\t\t\t\t_servant_postinvoke(_so);");
        printWriter.println("\t\t\t}");
        if (this.opAttribute == 0 && !(this.opTypeSpec.typeSpec() instanceof VoidTypeSpec)) {
            printWriter.println("\t\t\treturn _result;");
        } else {
            printWriter.println("\t\t\treturn;");
        }
        if (!bl) {
            printWriter.println("\t\t}\n");
        }
        printWriter.println("\t\t}\n");
        printWriter.println("\t}\n");
    }

    public void print_sendc_Method(PrintWriter printWriter, String string) {
        ParamDecl paramDecl;
        String string2 = this.name.startsWith("_") ? this.name.substring(1) : this.name;
        printWriter.print("\tpublic void sendc_" + this.name + "(");
        printWriter.print("AMI_" + string + "Handler ami_handler");
        Iterator iterator = this.paramDecls.iterator();
        while (iterator.hasNext()) {
            paramDecl = (ParamDecl)iterator.next();
            if (paramDecl.paramAttribute == 2) continue;
            printWriter.print(", ");
            paramDecl.asIn().print(printWriter);
        }
        printWriter.print(")");
        printWriter.println("\n\t{");
        printWriter.println("\t\twhile(true)");
        printWriter.println("\t\t{");
        printWriter.println("\t\t\ttry");
        printWriter.println("\t\t\t{");
        printWriter.print("\t\t\t\torg.omg.CORBA.portable.OutputStream _os = _request( \"" + string2 + "\",");
        if (this.opAttribute == 0) {
            printWriter.println(" true);");
        } else {
            printWriter.println(" false);");
        }
        iterator = this.paramDecls.iterator();
        while (iterator.hasNext()) {
            paramDecl = (ParamDecl)iterator.next();
            if (paramDecl.paramAttribute == 2) continue;
            printWriter.println("\t\t\t\t" + paramDecl.asIn().printWriteStatement("_os"));
        }
        printWriter.println("\t\t\t\t((org.jacorb.orb.Delegate)_get_delegate()).invoke(this, _os, ami_handler);");
        printWriter.println("\t\t\t\treturn;");
        printWriter.println("\t\t\t}");
        printWriter.println("\t\t\tcatch( org.omg.CORBA.portable.RemarshalException _rx ){}");
        printWriter.println("\t\t\tcatch( org.omg.CORBA.portable.ApplicationException _ax )");
        printWriter.println("\t\t\t{");
        printWriter.println("\t\t\t\tString _id = _ax.getId();");
        printWriter.println("\t\t\t}");
        printWriter.println("\t\t}\n");
        printWriter.println("\t}\n");
    }

    public void printDelegatedMethod(PrintWriter printWriter) {
        printWriter.print("\tpublic " + this.opTypeSpec.toString() + " " + this.name + "(");
        Enumeration enumeration = this.paramDecls.elements();
        if (enumeration.hasMoreElements()) {
            ((ParamDecl)enumeration.nextElement()).print(printWriter);
        }
        while (enumeration.hasMoreElements()) {
            printWriter.print(", ");
            ((ParamDecl)enumeration.nextElement()).print(printWriter);
        }
        printWriter.print(")");
        this.raisesExpr.print(printWriter);
        printWriter.println("\n\t{");
        if (this.opAttribute == 0 && !(this.opTypeSpec.typeSpec() instanceof VoidTypeSpec)) {
            printWriter.print("\t\treturn ");
        }
        printWriter.print("_delegate." + this.name + "(");
        enumeration = this.paramDecls.elements();
        if (enumeration.hasMoreElements()) {
            printWriter.print(((ParamDecl)enumeration.nextElement()).simple_declarator);
        }
        while (enumeration.hasMoreElements()) {
            printWriter.print(",");
            printWriter.print(((ParamDecl)enumeration.nextElement()).simple_declarator);
        }
        printWriter.println(");");
        printWriter.println("\t}\n");
    }

    public void printInvocation(PrintWriter printWriter) {
        String[] stringArray;
        int n;
        Object object;
        Object object2;
        if (!this.raisesExpr.empty()) {
            printWriter.println("\t\t\ttry");
            printWriter.println("\t\t\t{");
        }
        int n2 = 0;
        boolean bl = false;
        Enumeration enumeration = this.paramDecls.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (ParamDecl)enumeration.nextElement();
            object = ((ParamDecl)object2).paramTypeSpec.typeSpec();
            boolean bl2 = object instanceof StringType && ((StringType)object).isWide();
            int n3 = n = object instanceof CharType && ((CharType)object).isWide() ? 1 : 0;
            if (((ParamDecl)object2).paramAttribute == 1) {
                printWriter.println("\t\t\t\t" + ((TypeSpec)object).toString() + " _arg" + n2++ + "=" + ((TypeSpec)object).printReadExpression("_input") + ";");
                continue;
            }
            bl = true;
            printWriter.println("\t\t\t\t" + ((TypeSpec)object).holderName() + " _arg" + n2++ + "= new " + ((TypeSpec)object).holderName() + "();");
            if (((ParamDecl)object2).paramAttribute != 3) continue;
            if (n != 0) {
                printWriter.println("\t\t\t\t_arg" + (n2 - 1) + ".value = _input.read_wchar ();");
                continue;
            }
            if (bl2) {
                printWriter.println("\t\t\t\t_arg" + (n2 - 1) + ".value = _input.read_wstring ();");
                continue;
            }
            printWriter.println("\t\t\t\t_arg" + (n2 - 1) + "._read (_input);");
        }
        boolean bl3 = this.opTypeSpec.typeSpec() instanceof ArrayTypeSpec || this.opTypeSpec.typeSpec() instanceof FixedPointType;
        object2 = null;
        object = null;
        String string = null;
        printWriter.println("\t\t\t\t_out = handler.createReply();");
        if (!(this.opTypeSpec.typeSpec() instanceof VoidTypeSpec) && !bl3) {
            object2 = this.opTypeSpec.typeSpec().printWriteStatement("**", "_out");
            n = ((String)object2).indexOf("**");
            object = ((String)object2).substring(0, n);
            string = ((String)object2).substring(n + 2);
            printWriter.print("\t\t\t\t" + (String)object);
        } else {
            printWriter.print("\t\t\t\t");
        }
        if (bl3) {
            printWriter.print(this.opTypeSpec.typeSpec().typeName() + " _result = ");
        }
        printWriter.print(this.name + "(");
        for (n = 0; n < n2; ++n) {
            printWriter.print("_arg" + n);
            if (n >= n2 - 1) continue;
            printWriter.print(",");
        }
        if (!(this.opTypeSpec.typeSpec() instanceof VoidTypeSpec)) {
            printWriter.print(")");
        }
        if (!bl3) {
            if (this.opTypeSpec.typeSpec() instanceof VoidTypeSpec) {
                printWriter.println(");");
            } else {
                printWriter.println(string);
            }
        } else {
            printWriter.println(";");
            printWriter.println(this.opTypeSpec.typeSpec().printWriteStatement("_result", "_out"));
        }
        n2 = 0;
        String[] stringArray2 = this.paramDecls.elements();
        while (stringArray2.hasMoreElements()) {
            stringArray = (String[])stringArray2.nextElement();
            TypeSpec typeSpec = stringArray.paramTypeSpec;
            if (stringArray.paramAttribute != 1) {
                printWriter.println("\t\t\t\t" + stringArray.printWriteStatement("_arg" + n2, "_out"));
            }
            ++n2;
        }
        if (!this.raisesExpr.empty()) {
            printWriter.println("\t\t\t}");
            stringArray2 = this.raisesExpr.getExceptionNames();
            stringArray = this.raisesExpr.getExceptionClassNames();
            for (int i = 0; i < stringArray2.length; ++i) {
                printWriter.println("\t\t\tcatch(" + stringArray2[i] + " _ex" + i + ")");
                printWriter.println("\t\t\t{");
                printWriter.println("\t\t\t\t_out = handler.createExceptionReply();");
                printWriter.println("\t\t\t\t" + stringArray[i] + "Helper.write(_out, _ex" + i + ");");
                printWriter.println("\t\t\t}");
            }
        }
    }

    public String signature() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name + "(");
        Enumeration enumeration = this.paramDecls.elements();
        if (enumeration.hasMoreElements()) {
            stringBuffer.append(((ParamDecl)enumeration.nextElement()).paramTypeSpec.toString());
        }
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("," + ((ParamDecl)enumeration.nextElement()).paramTypeSpec.toString());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String name() {
        return this.name;
    }

    public String opName() {
        return this.name();
    }

    public void printSignature(PrintWriter printWriter) {
        this.printSignature(printWriter, false);
    }

    public void printSignature(PrintWriter printWriter, boolean bl) {
        printWriter.print("\t");
        if (bl) {
            printWriter.print("public abstract ");
        }
        printWriter.print(this.opTypeSpec.toString() + " " + this.name + "(");
        Enumeration enumeration = this.paramDecls.elements();
        while (enumeration.hasMoreElements()) {
            ((ParamDecl)enumeration.nextElement()).print(printWriter);
            if (!enumeration.hasMoreElements()) continue;
            printWriter.print(", ");
        }
        printWriter.print(")");
        this.raisesExpr.print(printWriter);
        printWriter.println(";");
    }

    public void getIRInfo(Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        TypeSpec typeSpec = this.opTypeSpec.typeSpec();
        if (typeSpec instanceof AliasTypeSpec) {
            stringBuffer.append(typeSpec.full_name());
            bl = true;
        }
        stringBuffer.append("(");
        Enumeration enumeration = this.paramDecls.elements();
        while (enumeration.hasMoreElements()) {
            ParamDecl paramDecl = (ParamDecl)enumeration.nextElement();
            if (paramDecl.paramAttribute == 3) {
                stringBuffer.append("inout:" + paramDecl.simple_declarator.name + " ");
                bl = true;
            } else if (paramDecl.paramAttribute == 2) {
                stringBuffer.append("out:" + paramDecl.simple_declarator.name + " ");
                bl = true;
            } else {
                stringBuffer.append("in:" + paramDecl.simple_declarator.name + " ");
            }
            typeSpec = paramDecl.paramTypeSpec.typeSpec();
            if (typeSpec instanceof AliasTypeSpec) {
                stringBuffer.append(typeSpec.full_name());
                bl = true;
            }
            stringBuffer.append(",");
        }
        if (this.paramDecls.size() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        stringBuffer.append(")");
        if (this.opAttribute == 1) {
            stringBuffer.append("-oneway");
        }
        hashtable.put(this.name, stringBuffer.toString());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("OpInfo for " + this.name + " : " + stringBuffer.toString());
        }
    }

    public void accept(IDLTreeVisitor iDLTreeVisitor) {
        iDLTreeVisitor.visitOpDecl(this);
    }
}

