/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.registry.carol.delegate;

import javax.naming.Context;
import javax.naming.NamingException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.omg.CORBA.ORB;
import org.ow2.carol.jndi.ns.JacORBCosNaming;
import org.ow2.carol.rmi.exception.NamingExceptionHelper;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.naming.JComponentContextFactoryDelegate;

public class ORBCCFDelegate
implements JComponentContextFactoryDelegate {
    private static final String ORB = "ORB";
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.naming");

    public void modify(final Context componentContext) throws NamingException {
        final ORB orb = JacORBCosNaming.getOrb();
        IExecution<Void> initORB = new IExecution<Void>(){

            public Void execute() throws Exception {
                if (orb != null) {
                    try {
                        componentContext.rebind(ORBCCFDelegate.ORB, (Object)orb);
                    }
                    catch (NamingException ne) {
                        String err = "Cannot bind java:comp/ORB object : " + ne.getMessage();
                        logger.log(BasicLevel.ERROR, (Object)err);
                        throw ne;
                    }
                }
                return null;
            }
        };
        ExecutionResult result = RunnableHelper.execute((ClassLoader)this.getClass().getClassLoader(), (IExecution)initORB);
        if (result.hasException()) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot init the ORB", (Throwable)result.getException());
            throw NamingExceptionHelper.create((String)"Cannot init the ORB", (Exception)result.getException());
        }
    }

    public void undo(Context componentContext) throws NamingException {
        if (JacORBCosNaming.getOrb() != null) {
            componentContext.unbind(ORB);
        }
    }
}

