/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.ant.archive.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.ow2.easybeans.ant.archive.AbsArchive;
import org.ow2.easybeans.ant.archive.Client;
import org.ow2.easybeans.ant.archive.Ejb;
import org.ow2.easybeans.ant.archive.War;
import org.ow2.easybeans.ant.archive.api.IEar;
import org.ow2.easybeans.ant.archive.info.ArchiveInfo;
import org.ow2.easybeans.ant.archive.info.EarInfo;

public class EarFile
extends Jar
implements IEar {
    private static final String DEPLOYMENT_DESCRIPTOR = "META-INF/application.xml";
    private EarInfo earInfo = null;

    public EarFile(Project p) {
        this.setProject(p);
    }

    public void setEarInfo(EarInfo earInfo) {
        this.earInfo = earInfo;
    }

    public void execute() {
        List<Ejb> ejbs = this.earInfo.getEjbs();
        List<War> wars = this.earInfo.getWars();
        List<Client> clients = this.earInfo.getClients();
        ArrayList<AbsArchive> archives = new ArrayList<AbsArchive>();
        if (ejbs != null) {
            for (Ejb ejb : ejbs) {
                archives.add(ejb);
            }
        }
        if (wars != null) {
            for (War war : wars) {
                archives.add(war);
            }
        }
        if (clients != null) {
            for (Client client : clients) {
                archives.add(client);
            }
        }
        for (AbsArchive archive : archives) {
            this.updateArchive(archive);
            archive.execute();
            this.addArchiveInFileSet(archive);
        }
        if (this.earInfo.getDD() != null) {
            this.setDD(this.earInfo.getDD());
        }
        this.setDestFile(this.earInfo.getDest());
        for (FileSet fileSet : this.earInfo.getFileSetList()) {
            this.addFileset(fileSet);
        }
        File earFileParentDirectory = this.earInfo.getDest().getParentFile();
        if (!earFileParentDirectory.exists()) {
            this.log("Creating directory '" + earFileParentDirectory + "'", 2);
            earFileParentDirectory.mkdirs();
        }
        super.execute();
        for (AbsArchive archive : archives) {
            File tmpFile = archive.getDest();
            if (!tmpFile.exists()) continue;
            tmpFile.delete();
        }
    }

    void updateArchive(AbsArchive archive) {
        if (archive.isExploded() && !this.earInfo.isExploded()) {
            this.log("Changing exploded mode to false as the EAR is not in exploded mode.", 2);
            archive.setExploded(false);
        }
        if (archive.getName() == null) {
            archive.setName(archive.getDest().getName());
        }
        try {
            archive.setDest(File.createTempFile("easybeans-ant", ".tmp"));
        }
        catch (IOException e) {
            throw new BuildException("Cannot create a temp file", (Throwable)e);
        }
        archive.getDest().delete();
    }

    public void setDD(File dd) {
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setFile(dd);
        zipFileSet.setFullpath(DEPLOYMENT_DESCRIPTOR);
        this.addFileset((FileSet)zipFileSet);
    }

    public void addArchiveInFileSet(AbsArchive archive) {
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setFile(archive.getDest());
        zipFileSet.setFullpath(archive.getName());
        this.addFileset((FileSet)zipFileSet);
    }

    public void setArchiveInfo(ArchiveInfo archiveInfo) {
    }
}

