/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionSynchronization;
import javax.ejb.TimerService;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.xml.rpc.handler.MessageContext;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.ejb21.JSessionContext;
import org.ow2.jonas.lib.ejb21.JSessionFactory;
import org.ow2.jonas.lib.ejb21.JStatefulSwitch;
import org.ow2.jonas.lib.ejb21.TraceEjb;

public class JStatefulContext
extends JSessionContext
implements Synchronization {
    boolean synchro = false;
    boolean timedout = false;

    public JStatefulContext(JSessionFactory bf, SessionBean sb, boolean sync) {
        super(bf, sb);
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        this.synchro = sync;
        try {
            Context c = bf.naming.getComponentContext();
            c.rebind("MY_SF_CONTEXT", (Object)this);
        }
        catch (NamingException ne) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"Cannot bind EJBContext", (Throwable)ne);
        }
    }

    public void setInstance(SessionBean sb) {
        TraceEjb.logger.log(BasicLevel.DEBUG, (Object)("Set to " + sb));
        this.myinstance = sb;
    }

    public TimerService getTimerService() throws IllegalStateException {
        throw new IllegalStateException("getTimerService Not Allowed on Stateful Session Beans");
    }

    public MessageContext getMessageContext() throws IllegalStateException {
        throw new IllegalStateException("getMessageContext Not Allowed on Stateful Session Beans");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion() {
        if (TraceEjb.isDebugTx()) {
            TraceEjb.tx.log(BasicLevel.DEBUG, (Object)" Starting transaction completion process");
        }
        if (this.synchro) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.bf.myClassLoader());
            Context bnctx = this.bf.setComponentContext();
            try {
                SessionSynchronization ss = (SessionSynchronization)this.getInstance();
                ss.beforeCompletion();
            }
            catch (RemoteException e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"exception:", (Throwable)e);
            }
            finally {
                this.bf.resetComponentContext(bnctx);
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int status) {
        if (TraceEjb.isDebugTx()) {
            TraceEjb.tx.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.synchro) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.bf.myClassLoader());
            Context bnctx = this.bf.setComponentContext();
            try {
                SessionSynchronization ss = (SessionSynchronization)this.getInstance();
                this.setState(3);
                ss.afterCompletion(status == 3);
                this.setState(2);
            }
            catch (RemoteException e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"exception:", (Throwable)e);
            }
            finally {
                this.bf.resetComponentContext(bnctx);
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        JStatefulSwitch jss = (JStatefulSwitch)this.bs;
        jss.txCompleted();
        if (this.timedout) {
            TraceEjb.logger.log(BasicLevel.WARN, (Object)"timeout expired during the transaction");
            this.timedout = false;
        }
    }

    public void setRemoved() throws RemoteException, RemoveException {
        JStatefulSwitch jss;
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        if ((jss = (JStatefulSwitch)this.bs).isInTransaction()) {
            throw new RemoveException("Cannot remove a statefull session inside a transaction");
        }
        SessionBean sb = (SessionBean)this.myinstance;
        if (sb != null) {
            sb.ejbRemove();
        } else {
            TraceEjb.interp.log(BasicLevel.WARN, (Object)"remove a passivated instance ?");
        }
        this.ismarkedremoved = true;
    }

    public void setConnectionList(List conlist) {
        JStatefulSwitch jss = (JStatefulSwitch)this.bs;
        jss.setConnectionList(conlist);
    }
}

