/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import javax.ejb.TimerService;
import javax.transaction.TransactionManager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.ejb21.JContainer;
import org.ow2.jonas.lib.ejb21.JEntityFactory;
import org.ow2.jonas.lib.ejb21.JEntitySwitch;
import org.ow2.jonas.lib.ejb21.JFactory;
import org.ow2.jonas.lib.ejb21.JMdbEndpointFactory;
import org.ow2.jonas.lib.ejb21.JMdbFactory;
import org.ow2.jonas.lib.ejb21.JStatelessFactory;
import org.ow2.jonas.lib.ejb21.JTimer;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.timer.TraceTimer;

public class JTimerService
implements TimerService {
    private ArrayList mytimers = new ArrayList();
    private JFactory bf = null;
    private JEntitySwitch es = null;
    private TransactionManager tm;
    private int timerCount = 0;
    private static final long MAX_DURATION = 5000000000L;

    public JTimerService(JFactory bf) {
        this.bf = bf;
        this.tm = bf.getTransactionManager();
    }

    public JTimerService(JEntitySwitch es) {
        this.es = es;
        this.bf = es.getBeanFactory();
        this.tm = this.bf.getTransactionManager();
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public void notify(Timer timer) {
        if (this.es != null) {
            this.es.notifyTimeout(timer);
        } else if (this.bf instanceof JMdbFactory) {
            ((JMdbFactory)this.bf).notifyTimeout(timer);
        } else if (this.bf instanceof JMdbEndpointFactory) {
            ((JMdbEndpointFactory)this.bf).notifyTimeout(timer);
        } else if (this.bf instanceof JStatelessFactory) {
            ((JStatelessFactory)this.bf).notifyTimeout(timer);
        } else {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)("Cannot notify this type of bean: " + this.bf));
            Thread.dumpStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Timer timer) {
        JTimerService jTimerService = this;
        synchronized (jTimerService) {
            int index = this.mytimers.lastIndexOf(timer);
            if (index == -1) {
                TraceTimer.logger.log(BasicLevel.WARN, (Object)"try to remove unexisting timer");
            } else {
                this.mytimers.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllTimers() {
        JTimerService jTimerService = this;
        synchronized (jTimerService) {
            this.es = null;
            for (JTimer timer : this.mytimers) {
                timer.stopTimer();
            }
            this.mytimers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer getTimerByTime(long initialDuration, long intervalDuration, Serializable info) {
        JTimer dummy = new JTimer(this, initialDuration, intervalDuration, info);
        JTimerService jTimerService = this;
        synchronized (jTimerService) {
            for (JTimer timer : this.mytimers) {
                if (!timer.sameas(dummy)) continue;
                return timer;
            }
        }
        return null;
    }

    public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialExpiration == null) {
            throw new IllegalArgumentException("expiration date is null");
        }
        long initialDuration = initialExpiration.getTime() - System.currentTimeMillis() + 20L;
        return this.createTimer(initialDuration, intervalDuration, info);
    }

    public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        return this.createTimer(expiration, 0L, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (this.es != null) {
            this.es.getPrimaryKey();
        }
        if (initialDuration < 0L || intervalDuration < 0L) {
            throw new IllegalArgumentException("duration is negative");
        }
        if (initialDuration > 5000000000L) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)("Too high duration: " + initialDuration));
        }
        if (intervalDuration > 5000000000L) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)("Too high duration: " + intervalDuration));
        }
        JTimer timer = new JTimer(this, initialDuration, intervalDuration, info);
        File pdir = this.bf.getPassivationDir();
        File timerfile = null;
        JTimerService jTimerService = this;
        synchronized (jTimerService) {
            int tid;
            do {
                ++this.timerCount;
            } while ((timerfile = new File(pdir, String.valueOf(tid) + ".tim")).exists());
        }
        if (this.mytimers.add(timer)) {
            timer.startTimer();
        } else {
            TraceTimer.logger.log(BasicLevel.WARN, (Object)"create a timer already known");
        }
        TimerHandle th = timer.getHandle();
        ObjectOutputStream oos = null;
        FileOutputStream fos = null;
        try {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"Writing Timer on disk");
            fos = new FileOutputStream(timerfile);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(th);
            timer.setFile(timerfile);
        }
        catch (IOException e) {
            TraceTimer.logger.log(BasicLevel.ERROR, (Object)"Cannot write Timer on storage");
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception e) {
                TraceTimer.logger.log(BasicLevel.WARN, (Object)("Cannot close OutputStream:" + e));
            }
        }
        return timer;
    }

    public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        return this.createTimer(duration, 0L, info);
    }

    public Collection getTimers() throws IllegalStateException, EJBException {
        if (this.es != null) {
            this.es.getPrimaryKey();
        }
        ArrayList<JTimer> ret = new ArrayList<JTimer>();
        for (JTimer t : this.mytimers) {
            if (t.isCancelled()) continue;
            ret.add(t);
        }
        return ret;
    }

    public String getEjbName() {
        if (this.bf != null) {
            return this.bf.getEJBName();
        }
        if (this.es != null) {
            return this.es.getBeanFactory().getEJBName();
        }
        return null;
    }

    public Serializable getPK() {
        if (this.es != null) {
            JEntityFactory ef = (JEntityFactory)this.es.getBeanFactory();
            Serializable pks = (Serializable)this.es.getPrimaryKey();
            Serializable pk = ef.encodePK(pks);
            if (TraceEjb.isDebugIc()) {
                TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("pk = " + pks));
                TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("encoded pk = " + pk));
            }
            return pk;
        }
        return null;
    }

    public String getContainer() {
        JContainer cont = this.bf.getContainer();
        return cont.getExternalFileName();
    }
}

