/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.jetty6;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.xml.XmlConfiguration;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.web.JWebContainerService;
import org.ow2.jonas.web.JWebContainerServiceException;
import org.ow2.jonas.web.base.BaseWebContainerService;

public class Jetty6Service
extends BaseWebContainerService
implements JWebContainerService,
Pojo {
    private InstanceManager _cm;
    private static final String JETTY_CONFIGURATION_FILE = BaseWebContainerService.JONAS_BASE + File.separator + "conf" + File.separator + "jetty6.xml";
    private static final String JETTY_DEFAULT_WEB_XML_FILE = BaseWebContainerService.JONAS_BASE + File.separator + "conf" + File.separator + "jetty6-web.xml";
    private static String config = null;
    private boolean _Fserver;
    private Server server;
    private boolean _FdefaultHandler;
    private DefaultHandler defaultHandler;
    private boolean _FrequestLogHandler;
    private RequestLogHandler requestLogHandler;
    private boolean _FwebAppContexts;
    private ContextHandlerCollection webAppContexts;
    private boolean _Fhandlers;
    private HandlerCollection handlers;
    private boolean _M$initorg_apache_felix_ipojo_InstanceManager;
    private boolean _MinitHandlers;
    private boolean _MdoStart;
    private boolean _MdoStop;
    private boolean _MdoRegisterWarjavax_naming_Context;
    private boolean _MgetDummyJSR77ObjectNamejava_lang_Stringjava_lang_Stringjava_lang_String;
    private boolean _MgetJOnASClassPathjava_lang_ClassLoader;
    private boolean _MdoUnRegisterWarjavax_naming_Context;
    private boolean _MupdateServerInfos;
    private boolean _MgetDefaultHost;
    private boolean _MgetDefaultHttpPort;
    private boolean _MgetDefaultHttpsPort;
    private boolean _MgetFirstListenerFromSchemejava_lang_String;

    private Server _getserver() {
        if (!this._Fserver) {
            return this.server;
        }
        return (Server)this._cm.getterCallback("server");
    }

    private void _setserver(Server server) {
        if (!this._Fserver) {
            this.server = server;
            return;
        }
        this._cm.setterCallback("server", (Object)server);
    }

    private DefaultHandler _getdefaultHandler() {
        if (!this._FdefaultHandler) {
            return this.defaultHandler;
        }
        return (DefaultHandler)this._cm.getterCallback("defaultHandler");
    }

    private void _setdefaultHandler(DefaultHandler defaultHandler) {
        if (!this._FdefaultHandler) {
            this.defaultHandler = defaultHandler;
            return;
        }
        this._cm.setterCallback("defaultHandler", (Object)defaultHandler);
    }

    private RequestLogHandler _getrequestLogHandler() {
        if (!this._FrequestLogHandler) {
            return this.requestLogHandler;
        }
        return (RequestLogHandler)this._cm.getterCallback("requestLogHandler");
    }

    private void _setrequestLogHandler(RequestLogHandler requestLogHandler) {
        if (!this._FrequestLogHandler) {
            this.requestLogHandler = requestLogHandler;
            return;
        }
        this._cm.setterCallback("requestLogHandler", (Object)requestLogHandler);
    }

    private ContextHandlerCollection _getwebAppContexts() {
        if (!this._FwebAppContexts) {
            return this.webAppContexts;
        }
        return (ContextHandlerCollection)this._cm.getterCallback("webAppContexts");
    }

    private void _setwebAppContexts(ContextHandlerCollection contextHandlerCollection) {
        if (!this._FwebAppContexts) {
            this.webAppContexts = contextHandlerCollection;
            return;
        }
        this._cm.setterCallback("webAppContexts", (Object)contextHandlerCollection);
    }

    private HandlerCollection _gethandlers() {
        if (!this._Fhandlers) {
            return this.handlers;
        }
        return (HandlerCollection)this._cm.getterCallback("handlers");
    }

    private void _sethandlers(HandlerCollection handlerCollection) {
        if (!this._Fhandlers) {
            this.handlers = handlerCollection;
            return;
        }
        this._cm.setterCallback("handlers", (Object)handlerCollection);
    }

    public Jetty6Service(InstanceManager _manager) {
        this._setComponentManager(_manager);
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.entryCallback("$initorg_apache_felix_ipojo_InstanceManager");
        }
        this._setserver(null);
        this._setdefaultHandler(null);
        this._setrequestLogHandler(null);
        this._setwebAppContexts(null);
        Object var3_2 = null;
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.exitCallback("$initorg_apache_felix_ipojo_InstanceManager", var3_2);
        }
    }

    private void initHandlers() {
        if (this._MinitHandlers) {
            this._cm.entryCallback("initHandlers");
        }
        this._setdefaultHandler(new DefaultHandler());
        this._setrequestLogHandler(new RequestLogHandler());
        this._setwebAppContexts(new ContextHandlerCollection());
        this._sethandlers(new HandlerCollection());
        this._gethandlers().setHandlers(new Handler[]{this._getwebAppContexts(), this._getdefaultHandler(), this._getrequestLogHandler()});
        this._getserver().setHandler((Handler)this._gethandlers());
        Object var1_1 = null;
        if (this._MinitHandlers) {
            this._cm.exitCallback("initHandlers", var1_1);
        }
    }

    public void doStart() throws ServiceException {
        if (this._MdoStart) {
            this._cm.entryCallback("doStart");
        }
        if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)"");
        }
        config = JETTY_CONFIGURATION_FILE;
        Jetty6Service.getLogger().log(BasicLevel.LEVEL_DEBUG, (Object)("Using configuration file " + config));
        this._setserver(new Server());
        this.initHandlers();
        if (this._getserver() != null) {
            if (config != null) {
                IExecution<Server> jettyServerConfiguration = new IExecution<Server>(){

                    public Server execute() throws Exception {
                        XmlConfiguration configuration = new XmlConfiguration(new File(config).toURL());
                        configuration.configure((Object)Jetty6Service.this.server);
                        Jetty6Service.this.server.start();
                        return Jetty6Service.this.server;
                    }
                };
                ExecutionResult result = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)jettyServerConfiguration);
                if (result.hasException()) {
                    Jetty6Service.getLogger().log(BasicLevel.LEVEL_ERROR, (Object)("Error has occured while starting Jetty server using configuration file " + config), (Throwable)result.getException());
                }
            }
        } else {
            ServiceException serviceException = new ServiceException("Cannot start Jetty server.");
            if (this._MdoStart) {
                this._cm.exitCallback("doStart", (Object)serviceException);
            }
            throw serviceException;
        }
        super.doStart();
        Jetty6Service.getLogger().log(BasicLevel.INFO, (Object)"Jetty6 Service started");
        Object var4_4 = null;
        if (this._MdoStart) {
            this._cm.exitCallback("doStart", var4_4);
        }
    }

    protected void doStop() throws ServiceException {
        if (this._MdoStop) {
            this._cm.entryCallback("doStop");
        }
        super.doStop();
        if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.isStarted() && this._getserver() != null) {
            try {
                this._getserver().stop();
                this._getserver().destroy();
                this._setserver(null);
                Jetty6Service.getLogger().log(BasicLevel.INFO, (Object)"Jetty6 Service stopped");
            }
            catch (Exception eExc) {
                Jetty6Service.getLogger().log(BasicLevel.LEVEL_ERROR, (Object)("error has occured while stopping Jetty server using configuration file " + config), (Throwable)eExc);
            }
        }
        Object var2_2 = null;
        if (this._MdoStop) {
            this._cm.exitCallback("doStop", var2_2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doRegisterWar(Context var1_1) throws JWebContainerServiceException {
        if (this._MdoRegisterWarjavax_naming_Context) {
            this._cm.entryCallback("doRegisterWarjavax_naming_Context");
        }
        unpackedWarURL = null;
        contextRoot = null;
        java2DelegationModel = true;
        try {
            unpackedWarURL = (URL)ctx.lookup("unpackedWarURL");
            contextRoot = (String)ctx.lookup("contextRoot");
            bool = (Boolean)ctx.lookup("java2DelegationModel");
            java2DelegationModel = bool;
        }
        catch (NamingException e) {
            err = "Error while getting parameter from context param ";
            Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            var7_10 = new JWebContainerServiceException(err, (Throwable)e);
            if (this._MdoRegisterWarjavax_naming_Context) {
                this._cm.exitCallback("doRegisterWarjavax_naming_Context", (Object)var7_10);
            }
            throw var7_10;
        }
        webClassLoader = null;
        try {
            webClassLoader = (ClassLoader)ctx.lookup("parentCL");
        }
        catch (NamingException e) {
            err = "error while getting parameter from context param ";
            Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            var9_14 = new JWebContainerServiceException(err, (Throwable)e);
            if (this._MdoRegisterWarjavax_naming_Context) {
                this._cm.exitCallback("doRegisterWarjavax_naming_Context", (Object)var9_14);
            }
            throw var9_14;
        }
        hostName = null;
        try {
            hostName = (String)ctx.lookup("hostName");
        }
        catch (NamingException e) {
            hostName = "";
        }
        earAppName = null;
        try {
            earAppName = (String)ctx.lookup("earAppName");
        }
        catch (NamingException e) {
            earAppName = null;
        }
        if (contextRoot.equals("/")) {
            contextRoot = "";
        } else if (contextRoot.equalsIgnoreCase("ROOT")) {
            contextRoot = "";
        }
        fWar = new File(unpackedWarURL.getFile());
        fileName = fWar.getAbsolutePath();
        if (this._getserver() != null) {
            try {
                webAppContext = new WebAppContext();
                webAppContext.setContextPath("/" + contextRoot);
                webAppContext.setWar(unpackedWarURL.toString());
                if (hostName != null && hostName.length() > 0) {
                    webAppContext.setConnectorNames(new String[]{hostName});
                }
                webAppContext.setAttribute("J2EEDomainName", (Object)this.getDomainName());
                webAppContext.setAttribute("J2EEServerName", (Object)this.getJonasServerName());
                webAppContext.setAttribute("J2EEApplicationName", (Object)earAppName);
                webDefaults = new File(Jetty6Service.JETTY_DEFAULT_WEB_XML_FILE);
                if (webDefaults.exists()) {
                    webAppContext.setDefaultsDescriptor(webDefaults.toURL().toExternalForm());
                } else {
                    Jetty6Service.getLogger().log(BasicLevel.WARN, (Object)("The file '" + Jetty6Service.JETTY_DEFAULT_WEB_XML_FILE + "' is not present. Check that your JONAS_BASE is up-to-date."));
                }
                webAppContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)this.getJOnASClassPath(webClassLoader));
                webAppContext.setParentLoaderPriority(java2DelegationModel);
                if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Webapp class loader java 2 delegation model set to " + java2DelegationModel));
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server starting web app " + fileName));
                }
                this._getwebAppContexts().addHandler((Handler)webAppContext);
                oldCL = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(webClassLoader);
                try {
                    webAppContext.start();
                    Thread.currentThread().setContextClassLoader(oldCL);
                }
                catch (Throwable var15_26) {
                    Thread.currentThread().setContextClassLoader(oldCL);
                    var16_27 = var15_26;
                    if (this._MdoRegisterWarjavax_naming_Context) {
                        this._cm.exitCallback("doRegisterWarjavax_naming_Context", (Object)var16_27);
                    }
                    throw var16_27;
                }
                if (!Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) ** GOTO lbl101
                Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server is running web app " + fileName));
            }
            catch (IOException ioeExc) {
                err = "Cannot install this web application " + ioeExc;
                Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)err);
                var17_28 = new JWebContainerServiceException(err, (Throwable)ioeExc);
                if (this._MdoRegisterWarjavax_naming_Context) {
                    this._cm.exitCallback("doRegisterWarjavax_naming_Context", (Object)var17_28);
                }
                throw var17_28;
            }
            catch (Exception eExc) {
                err = "Cannot start this web application " + eExc;
                Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)err);
                var18_29 = new JWebContainerServiceException(err, (Throwable)eExc);
                if (this._MdoRegisterWarjavax_naming_Context) {
                    this._cm.exitCallback("doRegisterWarjavax_naming_Context", (Object)var18_29);
                }
                throw var18_29;
            }
        } else if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("No Jetty server to install web app " + fileName));
        }
lbl101:
        // 5 sources

        try {
            ctx.rebind("WebModule", (Object)this.getDummyJSR77ObjectName(hostName, contextRoot, earAppName));
        }
        catch (Exception e) {
            err = "Cannot rebind WebModule ObjectName in Context";
            Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)err, (Throwable)e);
            var19_30 = new JWebContainerServiceException(err, (Throwable)e);
            if (this._MdoRegisterWarjavax_naming_Context) {
                this._cm.exitCallback("doRegisterWarjavax_naming_Context", (Object)var19_30);
            }
            throw var19_30;
        }
        var20_31 = null;
        if (this._MdoRegisterWarjavax_naming_Context) {
            this._cm.exitCallback("doRegisterWarjavax_naming_Context", var20_31);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ObjectName getDummyJSR77ObjectName(String string, String string2, String string3) throws MalformedObjectNameException {
        void earAppName;
        void contextRoot;
        if (this._MgetDummyJSR77ObjectNamejava_lang_Stringjava_lang_Stringjava_lang_String) {
            this._cm.entryCallback("getDummyJSR77ObjectNamejava_lang_Stringjava_lang_Stringjava_lang_String");
        }
        ObjectName objectName = ObjectName.getInstance(this.getDomainName() + ":j2eeType=WebModule,name=" + "/" + (String)contextRoot + ",J2EEApplication=" + (String)earAppName + ",J2EEServer=" + this.getJonasServerName());
        if (this._MgetDummyJSR77ObjectNamejava_lang_Stringjava_lang_Stringjava_lang_String) {
            this._cm.exitCallback("getDummyJSR77ObjectNamejava_lang_Stringjava_lang_Stringjava_lang_String", (Object)objectName);
        }
        return objectName;
    }

    public String getJOnASClassPath(ClassLoader classLoader) {
        if (this._MgetJOnASClassPathjava_lang_ClassLoader) {
            this._cm.entryCallback("getJOnASClassPathjava_lang_ClassLoader");
        }
        StringBuffer classpath = new StringBuffer();
        int n = 0;
        for (ClassLoader tmpLoader = webClassLoader; tmpLoader != null && tmpLoader instanceof URLClassLoader; tmpLoader = tmpLoader.getParent()) {
            URL[] repositories = ((URLClassLoader)tmpLoader).getURLs();
            for (int i = 0; i < repositories.length; ++i) {
                String repository = repositories[i].toString();
                if (repository.startsWith("file://")) {
                    repository = repository.substring("file://".length());
                } else {
                    if (!repository.startsWith("file:")) continue;
                    repository = repository.substring("file:".length());
                }
                if (repository == null) continue;
                if (n > 0) {
                    classpath.append(File.pathSeparator);
                }
                classpath.append(repository);
                ++n;
            }
        }
        String string = classpath.toString();
        if (this._MgetJOnASClassPathjava_lang_ClassLoader) {
            this._cm.exitCallback("getJOnASClassPathjava_lang_ClassLoader", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    protected void doUnRegisterWar(Context context) throws JWebContainerServiceException {
        if (this._MdoUnRegisterWarjavax_naming_Context) {
            this._cm.entryCallback("doUnRegisterWarjavax_naming_Context");
        }
        String contextRoot = null;
        try {
            void ctx;
            contextRoot = (String)ctx.lookup("contextRoot");
        }
        catch (NamingException e) {
            String err = "Error while getting parameter from context param ";
            Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException(err, (Throwable)e);
            if (this._MdoUnRegisterWarjavax_naming_Context) {
                this._cm.exitCallback("doUnRegisterWarjavax_naming_Context", (Object)jWebContainerServiceException);
            }
            throw jWebContainerServiceException;
        }
        if (contextRoot.equals("/")) {
            contextRoot = "";
        } else if (contextRoot.equalsIgnoreCase("ROOT")) {
            contextRoot = "";
        }
        if (this._getserver() != null) {
            Handler[] handlers;
            WebAppContext webAppContext = null;
            for (Handler handler : handlers = this._getwebAppContexts().getHandlers()) {
                WebAppContext tmpContext;
                String contextPath;
                if (!(handler instanceof WebAppContext) || !contextRoot.equals(contextPath = (tmpContext = (WebAppContext)handler).getContextPath())) continue;
                webAppContext = tmpContext;
                break;
            }
            if (webAppContext != null) {
                if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server found and is stopping web app at context " + contextRoot));
                }
                try {
                    webAppContext.stop();
                }
                catch (Exception e) {
                    Jetty6Service.getLogger().log(BasicLevel.LEVEL_DEBUG, (Object)"Jetty server encoutered exception while stopping web application ", (Throwable)e);
                }
                if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server stopped and is removing web app at context " + contextRoot));
                }
                this._getwebAppContexts().removeHandler(webAppContext);
                if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server removed and is destroying web app at context " + contextRoot));
                }
                webAppContext.destroy();
                if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server unloaded web app at context " + contextRoot));
                }
            } else if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server didn't find web app at context " + contextRoot));
            }
        } else if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("No Jetty server to install web app at context " + contextRoot));
        }
        Object var12_15 = null;
        if (this._MdoUnRegisterWarjavax_naming_Context) {
            this._cm.exitCallback("doUnRegisterWarjavax_naming_Context", var12_15);
        }
    }

    protected void updateServerInfos() {
        if (this._MupdateServerInfos) {
            this._cm.entryCallback("updateServerInfos");
        }
        this.setServerName("Jetty");
        this.setServerVersion(Server.getVersion());
        Object var1_1 = null;
        if (this._MupdateServerInfos) {
            this._cm.exitCallback("updateServerInfos", var1_1);
        }
    }

    public String getDefaultHost() throws JWebContainerServiceException {
        Connector[] connectors;
        if (this._MgetDefaultHost) {
            this._cm.entryCallback("getDefaultHost");
        }
        if ((connectors = this._getserver().getConnectors()).length == 0) {
            String err = "Cannot determine default host : Jetty server has no host!";
            JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException(err);
            if (this._MgetDefaultHost) {
                this._cm.exitCallback("getDefaultHost", (Object)jWebContainerServiceException);
            }
            throw jWebContainerServiceException;
        }
        String string = connectors[0].getHost();
        if (this._MgetDefaultHost) {
            this._cm.exitCallback("getDefaultHost", (Object)string);
        }
        return string;
    }

    public String getDefaultHttpPort() throws JWebContainerServiceException {
        if (this._MgetDefaultHttpPort) {
            this._cm.entryCallback("getDefaultHttpPort");
        }
        String string = String.valueOf(this.getFirstListenerFromScheme("http").getPort());
        if (this._MgetDefaultHttpPort) {
            this._cm.exitCallback("getDefaultHttpPort", (Object)string);
        }
        return string;
    }

    public String getDefaultHttpsPort() throws JWebContainerServiceException {
        if (this._MgetDefaultHttpsPort) {
            this._cm.entryCallback("getDefaultHttpsPort");
        }
        String string = String.valueOf(this.getFirstListenerFromScheme("https").getPort());
        if (this._MgetDefaultHttpsPort) {
            this._cm.exitCallback("getDefaultHttpsPort", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private Connector getFirstListenerFromScheme(String string) {
        void myScheme;
        if (this._MgetFirstListenerFromSchemejava_lang_String) {
            this._cm.entryCallback("getFirstListenerFromSchemejava_lang_String");
        }
        Connector[] connectors = this._getserver().getConnectors();
        ArrayList<Connector> matchingConnectors = new ArrayList<Connector>();
        for (int i = 0; i < connectors.length; ++i) {
            Connector connector = connectors[i];
            String scheme = connector.getIntegralScheme();
            if (!scheme.equalsIgnoreCase((String)myScheme)) continue;
            matchingConnectors.add(connector);
        }
        if (matchingConnectors.isEmpty()) {
            String err = "Cannot determine default '" + (String)myScheme + "' port :" + " Jetty server has 0 '" + (String)myScheme + "' Listener";
            JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException(err);
            if (this._MgetFirstListenerFromSchemejava_lang_String) {
                this._cm.exitCallback("getFirstListenerFromSchemejava_lang_String", (Object)jWebContainerServiceException);
            }
            throw jWebContainerServiceException;
        }
        Connector firstConnector = (Connector)matchingConnectors.get(0);
        if (matchingConnectors.size() > 1 && Jetty6Service.getLogger().isLoggable(BasicLevel.WARN)) {
            Jetty6Service.getLogger().log(BasicLevel.WARN, (Object)("Found multiple Listener for scheme '" + (String)myScheme + "'" + ", using first by default! (port:" + firstConnector.getPort() + ")"));
        }
        Connector connector = firstConnector;
        if (this._MgetFirstListenerFromSchemejava_lang_String) {
            this._cm.exitCallback("getFirstListenerFromSchemejava_lang_String", (Object)connector);
        }
        return connector;
    }

    private void _setComponentManager(InstanceManager instanceManager) {
        this._cm = instanceManager;
        Set set = this._cm.getRegistredFields();
        if (set != null) {
            if (set.contains("defaultHandler")) {
                this._FdefaultHandler = true;
            }
            if (set.contains("handlers")) {
                this._Fhandlers = true;
            }
            if (set.contains("JETTY_CONFIGURATION_FILE")) {
                this._FJETTY_CONFIGURATION_FILE = true;
            }
            if (set.contains("config")) {
                this._Fconfig = true;
            }
            if (set.contains("requestLogHandler")) {
                this._FrequestLogHandler = true;
            }
            if (set.contains("webAppContexts")) {
                this._FwebAppContexts = true;
            }
            if (set.contains("server")) {
                this._Fserver = true;
            }
            if (set.contains("JETTY_DEFAULT_WEB_XML_FILE")) {
                this._FJETTY_DEFAULT_WEB_XML_FILE = true;
            }
        }
        if ((set = this._cm.getRegistredMethods()) != null) {
            if (set.contains("$initorg_apache_felix_ipojo_InstanceManager")) {
                this._M$initorg_apache_felix_ipojo_InstanceManager = true;
            }
            if (set.contains("initHandlers")) {
                this._MinitHandlers = true;
            }
            if (set.contains("doStart")) {
                this._MdoStart = true;
            }
            if (set.contains("doStop")) {
                this._MdoStop = true;
            }
            if (set.contains("doRegisterWarjavax_naming_Context")) {
                this._MdoRegisterWarjavax_naming_Context = true;
            }
            if (set.contains("getDummyJSR77ObjectNamejava_lang_Stringjava_lang_Stringjava_lang_String")) {
                this._MgetDummyJSR77ObjectNamejava_lang_Stringjava_lang_Stringjava_lang_String = true;
            }
            if (set.contains("getJOnASClassPathjava_lang_ClassLoader")) {
                this._MgetJOnASClassPathjava_lang_ClassLoader = true;
            }
            if (set.contains("doUnRegisterWarjavax_naming_Context")) {
                this._MdoUnRegisterWarjavax_naming_Context = true;
            }
            if (set.contains("updateServerInfos")) {
                this._MupdateServerInfos = true;
            }
            if (set.contains("getDefaultHost")) {
                this._MgetDefaultHost = true;
            }
            if (set.contains("getDefaultHttpPort")) {
                this._MgetDefaultHttpPort = true;
            }
            if (set.contains("getDefaultHttpsPort")) {
                this._MgetDefaultHttpsPort = true;
            }
            if (set.contains("getFirstListenerFromSchemejava_lang_String")) {
                this._MgetFirstListenerFromSchemejava_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this._cm;
    }
}

