/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite.service.provides;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.composite.service.provides.ProvidedService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceExporter
implements ServiceListener {
    private BundleContext m_destination;
    private ServiceContext m_origin;
    private String m_specification;
    private Filter m_filter;
    private String m_filterStr;
    private boolean m_aggregate = false;
    private boolean m_optional = false;
    private ProvidedService m_ps;
    private boolean m_isValid;
    private List m_records = new ArrayList();

    public ServiceExporter(String specification, String filter, boolean multiple, boolean optional, ServiceContext from, BundleContext to, ProvidedService exp) {
        this.m_destination = to;
        this.m_origin = from;
        this.m_ps = exp;
        try {
            this.m_filter = to.createFilter(filter);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return;
        }
        this.m_aggregate = multiple;
        this.m_specification = specification;
        this.m_optional = optional;
    }

    public synchronized void start() {
        try {
            ServiceReference[] refs = this.m_origin.getServiceReferences(this.m_specification, null);
            if (refs != null) {
                for (int i = 0; i < refs.length; ++i) {
                    if (!this.m_filter.match(refs[i])) continue;
                    Record rec = new Record();
                    rec.m_ref = refs[i];
                    this.m_records.add(rec);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        if (this.m_records.size() > 0) {
            if (this.m_aggregate) {
                for (int i = 0; i < this.m_records.size(); ++i) {
                    Record rec = (Record)this.m_records.get(i);
                    rec.m_svcObject = this.m_origin.getService(rec.m_ref);
                    rec.m_reg = this.m_destination.registerService(this.m_specification, rec.m_svcObject, this.getProps(rec.m_ref));
                }
            } else {
                Record rec = (Record)this.m_records.get(0);
                if (rec.m_reg == null) {
                    rec.m_svcObject = this.m_origin.getService(rec.m_ref);
                    rec.m_reg = this.m_destination.registerService(this.m_specification, rec.m_svcObject, this.getProps(rec.m_ref));
                }
            }
        }
        try {
            this.m_origin.addServiceListener(this, "(objectClass=" + this.m_specification + ")");
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        this.m_isValid = this.isSatisfied();
    }

    private Dictionary getProps(ServiceReference ref) {
        Properties prop = new Properties();
        String[] keys = ref.getPropertyKeys();
        for (int i = 0; i < keys.length; ++i) {
            prop.put(keys[i], ref.getProperty(keys[i]));
        }
        prop.put("instance.name", this.m_ps.getManager().getInstanceName());
        prop.put("factory.name", this.m_ps.getManager().getFactory().getName());
        return prop;
    }

    public synchronized void stop() {
        this.m_origin.removeServiceListener(this);
        for (int i = 0; i < this.m_records.size(); ++i) {
            Record rec = (Record)this.m_records.get(i);
            rec.m_svcObject = null;
            if (rec.m_reg == null) continue;
            rec.m_reg.unregister();
            this.m_origin.ungetService(rec.m_ref);
            rec.m_ref = null;
        }
        this.m_records.clear();
    }

    public boolean isSatisfied() {
        return this.m_optional || this.m_records.size() > 0;
    }

    public boolean isPublishing() {
        return this.m_records.size() > 0;
    }

    private List getRecordsByRef(ServiceReference ref) {
        ArrayList<Record> l = new ArrayList<Record>();
        for (int i = 0; i < this.m_records.size(); ++i) {
            Record rec = (Record)this.m_records.get(i);
            if (rec.m_ref != ref) continue;
            l.add(rec);
        }
        return l;
    }

    public void serviceChanged(ServiceEvent ev) {
        if (ev.getType() == 1) {
            this.arrivalManagement(ev.getServiceReference());
        }
        if (ev.getType() == 4) {
            this.departureManagement(ev.getServiceReference());
        }
        if (ev.getType() == 2) {
            if (this.m_filter.match(ev.getServiceReference())) {
                List l = this.getRecordsByRef(ev.getServiceReference());
                if (l.size() > 0) {
                    for (int i = 0; i < l.size(); ++i) {
                        Record rec = (Record)l.get(i);
                        if (rec.m_reg == null) continue;
                        rec.m_reg.setProperties(this.getProps(rec.m_ref));
                    }
                } else {
                    this.arrivalManagement(ev.getServiceReference());
                }
            } else {
                List l = this.getRecordsByRef(ev.getServiceReference());
                if (l.size() > 0) {
                    this.departureManagement(ev.getServiceReference());
                }
            }
        }
    }

    private void arrivalManagement(ServiceReference ref) {
        if (this.m_filter.match(ref)) {
            Record rec = new Record();
            rec.m_ref = ref;
            this.m_records.add(rec);
            if (this.m_records.size() == 1 || this.m_aggregate) {
                rec.m_svcObject = this.m_origin.getService(rec.m_ref);
                rec.m_reg = this.m_destination.registerService(this.m_specification, rec.m_svcObject, this.getProps(rec.m_ref));
            }
            if (!this.m_isValid && this.isSatisfied()) {
                this.m_isValid = true;
                this.m_ps.validating(this);
            }
        }
    }

    private void departureManagement(ServiceReference ref) {
        List l = this.getRecordsByRef(ref);
        for (int i = 0; i < l.size(); ++i) {
            Record rec = (Record)l.get(i);
            if (rec.m_reg == null) continue;
            rec.m_svcObject = null;
            rec.m_reg.unregister();
            rec.m_reg = null;
            this.m_origin.ungetService(rec.m_ref);
        }
        this.m_records.removeAll(l);
        if (this.m_records.size() > 0) {
            Record rec;
            if (!this.m_aggregate && (rec = (Record)this.m_records.get(0)).m_svcObject == null) {
                rec.m_svcObject = this.m_origin.getService(rec.m_ref);
                rec.m_reg = this.m_destination.registerService(this.m_specification, rec.m_svcObject, this.getProps(rec.m_ref));
            }
        } else if (!this.m_optional) {
            this.m_isValid = false;
            this.m_ps.invalidating(this);
        }
    }

    protected String getSpecification() {
        return this.m_specification;
    }

    public String getFilter() {
        return this.m_filterStr;
    }

    private class Record {
        private ServiceReference m_ref;
        private ServiceRegistration m_reg;
        private Object m_svcObject;

        private Record() {
        }
    }
}

