/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulation;

import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

public class ConstructorCodeAdapter
extends GeneratorAdapter
implements Opcodes {
    private String m_owner;
    private boolean m_superDetected;
    private Set m_fields;
    private String m_desc;
    static /* synthetic */ Class class$java$lang$Object;

    public ConstructorCodeAdapter(MethodVisitor mv, String owner, Set fields, int access, String name, String desc) {
        super(mv, access, name, desc);
        this.m_owner = owner;
        this.m_superDetected = false;
        this.m_fields = fields;
        this.m_desc = desc;
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (this.m_fields.contains(name) && this.m_owner.equals(owner)) {
            if (opcode == 180) {
                String gDesc = "()" + desc;
                this.visitMethodInsn(183, owner, "_get" + name, gDesc);
                return;
            }
            if (opcode == 181) {
                String sDesc = "(" + desc + ")V";
                this.visitMethodInsn(183, owner, "_set" + name, sDesc);
                return;
            }
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (!this.m_superDetected) {
            this.m_superDetected = true;
            this.mv.visitVarInsn(25, 0);
            this.mv.visitMethodInsn(opcode, owner, name, desc);
            this.mv.visitVarInsn(25, 0);
            this.mv.visitVarInsn(25, 1);
            this.mv.visitMethodInsn(183, this.m_owner, "_setComponentManager", "(Lorg/apache/felix/ipojo/InstanceManager;)V");
            this.methodEntry();
        } else {
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    public void visitVarInsn(int opcode, int var) {
        if (!this.m_superDetected) {
            return;
        }
        if (var == 0) {
            this.mv.visitVarInsn(opcode, var);
        } else {
            this.mv.visitVarInsn(opcode, var + 1);
        }
    }

    public void visitIincInsn(int var, int increment) {
        if (var != 0) {
            this.mv.visitIincInsn(var + 1, increment);
        } else {
            this.mv.visitIincInsn(var, increment);
        }
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (index == 0) {
            this.mv.visitLocalVariable(name, desc, signature, start, end, index);
            this.mv.visitLocalVariable("_manager", "Lorg/apache/felix/ipojo/InstanceManager;", null, start, end, 1);
        }
        this.mv.visitLocalVariable(name, desc, signature, start, end, index + 1);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.mv.visitMaxs(maxStack + 1, maxLocals + 2);
    }

    public void visitInsn(int opcode) {
        switch (opcode) {
            case 177: {
                this.onMethodExit(opcode);
                break;
            }
        }
        super.visitInsn(opcode);
    }

    private void methodEntry() {
        Type[] args = Type.getArgumentTypes(this.m_desc);
        String name = "$init";
        for (int i = 0; i < args.length; ++i) {
            String cn = args[i].getClassName();
            if (cn.endsWith("[]")) {
                cn = cn.replace('[', '$');
                cn = cn.substring(0, cn.length() - 1);
            }
            cn = cn.replace('.', '_');
            name = name + cn;
        }
        String flag = "_M" + name;
        Label l0 = new Label();
        this.mv.visitLabel(l0);
        this.mv.visitVarInsn(25, 0);
        this.mv.visitFieldInsn(180, this.m_owner, flag, "Z");
        Label l1 = new Label();
        this.mv.visitJumpInsn(153, l1);
        this.mv.visitVarInsn(25, 0);
        this.mv.visitFieldInsn(180, this.m_owner, "_cm", "Lorg/apache/felix/ipojo/InstanceManager;");
        this.mv.visitLdcInsn(name);
        this.mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", "entryCallback", "(Ljava/lang/String;)V");
        this.mv.visitLabel(l1);
    }

    protected void onMethodExit(int opcode) {
        Type[] args = Type.getArgumentTypes(this.m_desc);
        String name = "$init";
        for (int i = 0; i < args.length; ++i) {
            String cn = args[i].getClassName();
            if (cn.endsWith("[]")) {
                cn = cn.replace('[', '$');
                cn = cn.substring(0, cn.length() - 1);
            }
            cn = cn.replace('.', '_');
            name = name + cn;
        }
        String flag = "_M" + name;
        int local = this.newLocal(Type.getType(class$java$lang$Object == null ? (class$java$lang$Object = ConstructorCodeAdapter.class$("java.lang.Object")) : class$java$lang$Object));
        this.visitInsn(1);
        this.mv.visitVarInsn(58, ++local);
        this.mv.visitVarInsn(25, 0);
        this.mv.visitFieldInsn(180, this.m_owner, flag, "Z");
        Label l5 = new Label();
        this.mv.visitJumpInsn(153, l5);
        this.mv.visitVarInsn(25, 0);
        this.mv.visitFieldInsn(180, this.m_owner, "_cm", "Lorg/apache/felix/ipojo/InstanceManager;");
        this.mv.visitLdcInsn(name);
        this.mv.visitVarInsn(25, local);
        this.mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", "exitCallback", "(Ljava/lang/String;Ljava/lang/Object;)V");
        this.mv.visitLabel(l5);
    }

    protected void onMethodEnter() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

