/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulation;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.manipulation.ClassChecker;
import org.apache.felix.ipojo.manipulation.ManipulationProperty;
import org.apache.felix.ipojo.manipulation.MethodDescriptor;
import org.apache.felix.ipojo.manipulation.PojoAdapter;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class Manipulator {
    private Map m_fields;
    private List m_interfaces;
    private List m_methods;
    private String m_superClass;

    public boolean manipulate(String name, File outputDirectory) throws Exception {
        String path = outputDirectory + "/" + name.replace('.', '/') + ".class";
        File clazz = new File(path);
        if (!clazz.exists()) {
            return false;
        }
        URL url = clazz.toURL();
        ManipulationProperty.getLogger().log(0, "Manipulate the class file : " + clazz.getAbsolutePath());
        InputStream is1 = url.openStream();
        ClassReader ckReader = new ClassReader(is1);
        ClassChecker ck = new ClassChecker();
        ckReader.accept(ck, 4);
        is1.close();
        this.m_fields = ck.getFields();
        this.m_interfaces = ck.getInterfaces();
        this.m_superClass = ck.getSuperClass();
        this.m_methods = ck.getMethods();
        if (!ck.isalreadyManipulated()) {
            InputStream is2 = url.openStream();
            ClassReader cr0 = new ClassReader(is2);
            ClassWriter cw0 = new ClassWriter(1);
            PojoAdapter preprocess = new PojoAdapter(cw0, this.m_fields);
            cr0.accept(preprocess, 4);
            is2.close();
            try {
                FileOutputStream fos = new FileOutputStream(clazz);
                fos.write(cw0.toByteArray());
                fos.close();
                ManipulationProperty.getLogger().log(0, "Put the file " + clazz.getAbsolutePath() + " in the jar file");
            }
            catch (Exception e) {
                System.err.println("Problem to write the adapted class on the file system  [ " + clazz.getAbsolutePath() + " ] " + e.getMessage());
                e.printStackTrace();
            }
        }
        return true;
    }

    public byte[] manipulate(byte[] origin) throws IOException {
        ByteArrayInputStream is1 = new ByteArrayInputStream(origin);
        ClassReader ckReader = new ClassReader(is1);
        ClassChecker ck = new ClassChecker();
        ckReader.accept(ck, 4);
        ((InputStream)is1).close();
        this.m_fields = ck.getFields();
        this.m_interfaces = ck.getInterfaces();
        this.m_superClass = ck.getSuperClass();
        this.m_methods = ck.getMethods();
        ClassWriter finalWriter = null;
        if (!ck.isalreadyManipulated()) {
            ByteArrayInputStream is2 = new ByteArrayInputStream(origin);
            ClassReader cr0 = new ClassReader(is2);
            ClassWriter cw0 = new ClassWriter(1);
            PojoAdapter preprocess = new PojoAdapter(cw0, this.m_fields);
            cr0.accept(preprocess, 4);
            ((InputStream)is2).close();
            finalWriter = cw0;
        }
        if (ck.isalreadyManipulated()) {
            return new byte[0];
        }
        return finalWriter.toByteArray();
    }

    public Element getManipulationMetadata() {
        Element elem = new Element("Manipulation", "");
        if (this.m_superClass != null) {
            elem.addAttribute(new Attribute("super", this.m_superClass));
        }
        for (int j = 0; j < this.m_interfaces.size(); ++j) {
            Element itf = new Element("Interface", "");
            Attribute att = new Attribute("name", this.m_interfaces.get(j).toString());
            itf.addAttribute(att);
            elem.addElement(itf);
        }
        Iterator it = this.m_fields.keySet().iterator();
        while (it.hasNext()) {
            Element field = new Element("Field", "");
            String name = (String)it.next();
            String type = (String)this.m_fields.get(name);
            Attribute attName = new Attribute("name", name);
            Attribute attType = new Attribute("type", type);
            field.addAttribute(attName);
            field.addAttribute(attType);
            elem.addElement(field);
        }
        for (int j = 0; j < this.m_methods.size(); ++j) {
            MethodDescriptor method = (MethodDescriptor)this.m_methods.get(j);
            elem.addElement(method.getElement());
        }
        return elem;
    }
}

