/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.common.impl.xml.merge;

import java.util.ArrayList;
import java.util.List;
import org.ow2.util.ee.metadata.common.api.ICommonClassMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonFieldMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonMethodMetadata;
import org.ow2.util.ee.metadata.common.api.interfaces.IEnvironmentRefAccessor;
import org.ow2.util.ee.metadata.common.api.interfaces.ISharedMetadata;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationResource;
import org.ow2.util.ee.metadata.common.api.struct.IJEjbEJB;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.ee.metadata.common.impl.struct.EnvEntry;
import org.ow2.util.ee.metadata.common.impl.struct.JAnnotationResource;
import org.ow2.util.ee.metadata.common.impl.struct.JEjbEJB;
import org.ow2.util.ee.metadata.common.impl.struct.JaxwsWebServiceRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.AbsEJBRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.AbsEnvironment;
import org.ow2.util.ee.metadata.common.impl.xml.struct.AroundInvoke;
import org.ow2.util.ee.metadata.common.impl.xml.struct.EJBLocalRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.EJBRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.InjectionTarget;
import org.ow2.util.ee.metadata.common.impl.xml.struct.LifeCycleCallback;
import org.ow2.util.ee.metadata.common.impl.xml.struct.MessageDestinationRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.ResourceEnvRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.ResourceRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.ServiceRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetadataMerge {
    public static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private static Log logger = LogFactory.getLog(MetadataMerge.class);

    protected void applyJndiEnvironmentRefsGroup(AbsEnvironment envGroup, IEnvironmentRefAccessor classAnnotationMetadata) {
        this.applyLifeCycle(envGroup.getPostConstructCallbackList(), classAnnotationMetadata, "post-construct");
        this.applyLifeCycle(envGroup.getPreDestroyCallbackList(), classAnnotationMetadata, "pre-destroy");
        this.applyEjbRef(envGroup.getEJBRefList(), classAnnotationMetadata);
        this.applyEjbLocalRef(envGroup.getEJBLocalRefList(), classAnnotationMetadata);
        this.applyResourceRef(envGroup.getResourceRefList(), classAnnotationMetadata);
        this.applyResourceEnvRef(envGroup.getResourceEnvRefList(), classAnnotationMetadata);
        this.applyMessageDestinationRef(envGroup.getMessageDestinationRefList(), classAnnotationMetadata);
        this.applyEnvEntry(envGroup.getEnvEntryList(), classAnnotationMetadata);
        this.applyServiceRef(envGroup.getServiceRefList(), classAnnotationMetadata);
    }

    protected void applyServiceRef(List<ServiceRef> serviceRefList, IEnvironmentRefAccessor classAnnotationMetadata) {
        if (serviceRefList == null) {
            return;
        }
        for (ServiceRef serviceRef : serviceRefList) {
            List<InjectionTarget> injectionTargetList = serviceRef.getInjectionTargetList();
            if (injectionTargetList != null) {
                for (InjectionTarget target : injectionTargetList) {
                    ISharedMetadata sharedMetadata = this.getInjectionTarget(classAnnotationMetadata, target);
                    IJaxwsWebServiceRef wsr = sharedMetadata.getJaxwsWebServiceRef();
                    if (wsr != null) {
                        this.mergeWebServiceRef(serviceRef, wsr);
                        continue;
                    }
                    sharedMetadata.setJaxwsWebServiceRef(this.createJaxwsWebServiceRefFromXML(serviceRef));
                }
                continue;
            }
            String name = serviceRef.getName();
            List<IJaxwsWebServiceRef> metadatas = this.findJaxwsWebServiceRefMetadata(classAnnotationMetadata, name);
            if (metadatas.isEmpty()) {
                IJaxwsWebServiceRef existing = classAnnotationMetadata.getJaxwsWebServiceRef();
                ArrayList<IJaxwsWebServiceRef> webServiceRefs = classAnnotationMetadata.getJaxwsWebServiceRefs();
                if (webServiceRefs == null) {
                    webServiceRefs = new ArrayList<IJaxwsWebServiceRef>();
                    classAnnotationMetadata.setJaxwsWebServiceRefs(webServiceRefs);
                }
                if (existing != null) {
                    webServiceRefs.add(existing);
                    classAnnotationMetadata.setJaxwsWebServiceRef(null);
                }
                webServiceRefs.add(this.createJaxwsWebServiceRefFromXML(serviceRef));
                continue;
            }
            if (metadatas.size() > 1) {
                throw new IllegalStateException("Too many matching WebServiceRef metadata for '" + name + "' service-ref of class '" + classAnnotationMetadata.getEnvironmentName() + "'");
            }
            this.mergeWebServiceRef(serviceRef, metadatas.get(0));
        }
    }

    private List<IJaxwsWebServiceRef> findJaxwsWebServiceRefMetadata(IEnvironmentRefAccessor classAnnotationMetadata, String name) {
        List webServiceRefs;
        ArrayList<IJaxwsWebServiceRef> elements = new ArrayList<IJaxwsWebServiceRef>();
        IJaxwsWebServiceRef classAnnotation = classAnnotationMetadata.getJaxwsWebServiceRef();
        if (classAnnotation != null && name.equals(classAnnotation.getName())) {
            elements.add(classAnnotation);
        }
        if ((webServiceRefs = classAnnotationMetadata.getJaxwsWebServiceRefs()) != null) {
            for (IJaxwsWebServiceRef ref : webServiceRefs) {
                if (!name.equals(ref.getName())) continue;
                elements.add(classAnnotation);
            }
        }
        return elements;
    }

    private IJaxwsWebServiceRef createJaxwsWebServiceRefFromXML(ServiceRef ref) {
        JaxwsWebServiceRef metadata = new JaxwsWebServiceRef();
        metadata.setName(ref.getName());
        metadata.setWsdlLocation(ref.getWsdlFile().toString());
        metadata.setType(ref.getServiceRefType());
        metadata.setValue(ref.getServiceInterface());
        return metadata;
    }

    private void mergeWebServiceRef(ServiceRef serviceRef, IJaxwsWebServiceRef annotation) {
        if (serviceRef.getWsdlFile() != null) {
            annotation.setWsdlLocation(serviceRef.getWsdlFile().toString());
        }
        if (serviceRef.getServiceInterface() != null) {
            if (annotation.getValue() == null) {
                annotation.setType(serviceRef.getServiceInterface());
            } else if (annotation.getType() == null) {
                annotation.setValue(serviceRef.getServiceInterface());
            }
        }
        if (serviceRef.getServiceRefType() != null) {
            annotation.setType(serviceRef.getServiceRefType());
        }
        annotation.setName(serviceRef.getName());
    }

    protected void applyMessageDestinationRef(List<MessageDestinationRef> messageDestinationRefList, IEnvironmentRefAccessor classAnnotationMetadata) {
        if (messageDestinationRefList == null) {
            return;
        }
        for (MessageDestinationRef messageDestinationRef : messageDestinationRefList) {
            JAnnotationResource jResource = new JAnnotationResource();
            jResource.setName(messageDestinationRef.getName());
            jResource.setType(messageDestinationRef.getType());
            jResource.setMappedName(messageDestinationRef.getMappedName());
            this.applyJResource(jResource, classAnnotationMetadata, messageDestinationRef.getInjectionTargetList());
        }
    }

    protected void applyResourceRef(List<ResourceRef> resourceRefList, IEnvironmentRefAccessor classAnnotationMetadata) {
        if (resourceRefList == null) {
            return;
        }
        for (ResourceRef resourceRef : resourceRefList) {
            JAnnotationResource jResource = new JAnnotationResource();
            jResource.setName(resourceRef.getResRefName());
            jResource.setType(resourceRef.getResRefType());
            jResource.setMappedName(resourceRef.getMappedName());
            this.applyJResource(jResource, classAnnotationMetadata, resourceRef.getInjectionTargetList());
        }
    }

    protected void applyResourceEnvRef(List<ResourceEnvRef> resourceEnvRefList, IEnvironmentRefAccessor classAnnotationMetadata) {
        if (resourceEnvRefList == null) {
            return;
        }
        for (ResourceEnvRef resourceEnvRef : resourceEnvRefList) {
            JAnnotationResource jResource = new JAnnotationResource();
            jResource.setName(resourceEnvRef.getResourceEnvRefName());
            jResource.setType(resourceEnvRef.getResourceEnvRefType());
            jResource.setMappedName(resourceEnvRef.getMappedName());
            this.applyJResource(jResource, classAnnotationMetadata, resourceEnvRef.getInjectionTargetList());
        }
    }

    protected void applyEnvEntry(List<org.ow2.util.ee.metadata.common.impl.xml.struct.EnvEntry> envEntryList, IEnvironmentRefAccessor classAnnotationMetadata) {
        if (envEntryList == null) {
            return;
        }
        ArrayList<EnvEntry> structEnvEntryList = new ArrayList<EnvEntry>();
        for (org.ow2.util.ee.metadata.common.impl.xml.struct.EnvEntry envEntry : envEntryList) {
            EnvEntry builtEntry = new EnvEntry(envEntry.getEnvEntryName(), envEntry.getEnvEntryType(), envEntry.getEnvEntryValue());
            structEnvEntryList.add(builtEntry);
            List<InjectionTarget> injectionTargetList = envEntry.getInjectionTargetList();
            if (injectionTargetList == null) continue;
            for (InjectionTarget injectionTarget : injectionTargetList) {
                JAnnotationResource jResource = new JAnnotationResource();
                jResource.setName(envEntry.getEnvEntryName());
                jResource.setType(envEntry.getEnvEntryType());
                this.getInjectionTarget(classAnnotationMetadata, injectionTarget).setJAnnotationResource((IJAnnotationResource)jResource);
            }
        }
        classAnnotationMetadata.setEnvEntryCollection(structEnvEntryList);
    }

    protected void applyEjbRef(List<EJBRef> ejbRefList, IEnvironmentRefAccessor classAnnotationMetadata) {
        if (ejbRefList == null) {
            return;
        }
        for (EJBRef ejbRef : ejbRefList) {
            JEjbEJB jEJB = this.buildEJB(ejbRef);
            if (ejbRef.getHome() != null) {
                jEJB.setBeanInterface(ejbRef.getHome());
            } else if (ejbRef.getRemote() != null) {
                jEJB.setBeanInterface(ejbRef.getRemote());
            }
            this.applyJEJB(jEJB, classAnnotationMetadata, ejbRef.getInjectionTargetList());
        }
    }

    protected void applyEjbLocalRef(List<EJBLocalRef> ejbLocalRefList, IEnvironmentRefAccessor classAnnotationMetadata) {
        if (ejbLocalRefList == null) {
            return;
        }
        for (EJBLocalRef ejbLocalRef : ejbLocalRefList) {
            JEjbEJB jEJB = this.buildEJB(ejbLocalRef);
            if (ejbLocalRef.getLocalHome() != null) {
                jEJB.setBeanInterface(ejbLocalRef.getLocalHome());
            } else if (ejbLocalRef.getLocal() != null) {
                jEJB.setBeanInterface(ejbLocalRef.getLocal());
            }
            this.applyJEJB(jEJB, classAnnotationMetadata, ejbLocalRef.getInjectionTargetList());
        }
    }

    private void applyJResource(JAnnotationResource jResource, IEnvironmentRefAccessor classAnnotationMetadata, List<InjectionTarget> injectionTargetList) {
        IJAnnotationResource existingJResource = classAnnotationMetadata.getJAnnotationResource();
        ArrayList<IJAnnotationResource> jResources = classAnnotationMetadata.getJAnnotationResources();
        if (jResources == null) {
            jResources = new ArrayList<IJAnnotationResource>();
            classAnnotationMetadata.setJAnnotationResources(jResources);
        }
        if (existingJResource != null) {
            jResources.add(existingJResource);
            classAnnotationMetadata.setJAnnotationResource(null);
        }
        jResources.add(jResource);
        if (injectionTargetList != null) {
            for (InjectionTarget injectionTarget : injectionTargetList) {
                this.getInjectionTarget(classAnnotationMetadata, injectionTarget).setJAnnotationResource((IJAnnotationResource)jResource);
            }
        }
    }

    private ISharedMetadata getInjectionTarget(IEnvironmentRefAccessor classAnnotationMetadata, InjectionTarget injectionTarget) {
        String injectionTargetName = injectionTarget.getTargetName();
        ICommonMethodMetadata<?, ?, ?> method = this.getMethod(classAnnotationMetadata, injectionTarget);
        if (method != null) {
            return method;
        }
        ICommonFieldMetadata<?, ?, ?> field = this.getField(classAnnotationMetadata, injectionTarget);
        if (field == null) {
            throw new IllegalArgumentException("No method or field for injection target name '" + injectionTargetName + "' found in the class '" + classAnnotationMetadata.getEnvironmentName() + "'.");
        }
        return field;
    }

    private ICommonMethodMetadata<?, ?, ?> getMethod(IEnvironmentRefAccessor classAnnotationMetadata, InjectionTarget injectionTarget) {
        String clName = injectionTarget.getClassname();
        clName = clName == null ? this.findDefaultClassForEnvironment(classAnnotationMetadata) : clName.replace(".", "/");
        String methodName = injectionTarget.getTargetName();
        ICommonClassMetadata<?, ?, ?> foundClassMetadata = this.getClassMetadata(clName);
        if (foundClassMetadata == null) {
            throw new IllegalArgumentException("Cannot find the class metadata named '" + clName + "'.");
        }
        List methods = foundClassMetadata.searchStandardMethodMetadata(methodName);
        if (methods.size() == 0) {
            return null;
        }
        if (methods.size() > 1) {
            throw new IllegalArgumentException("Too many methods with name '" + methodName + "' found in the class '" + clName + "'.");
        }
        return (ICommonMethodMetadata)methods.get(0);
    }

    private ICommonFieldMetadata<?, ?, ?> getField(IEnvironmentRefAccessor classAnnotationMetadata, InjectionTarget injectionTarget) {
        String clName = injectionTarget.getClassname();
        clName = clName == null ? this.findDefaultClassForEnvironment(classAnnotationMetadata) : clName.replace(".", "/");
        String fieldName = injectionTarget.getTargetName();
        ICommonClassMetadata<?, ?, ?> foundClassMetadata = this.getClassMetadata(clName);
        if (foundClassMetadata == null) {
            throw new IllegalArgumentException("Cannot find the class metadata named '" + clName + "'.");
        }
        List fields = foundClassMetadata.searchStandardFieldMetadata(fieldName);
        if (fields.size() == 0) {
            return null;
        }
        if (fields.size() > 1) {
            throw new IllegalArgumentException("Too many fields with name '" + fieldName + "' found in the class '" + clName + "'.");
        }
        return (ICommonFieldMetadata)fields.get(0);
    }

    private void applyJEJB(JEjbEJB jEJB, IEnvironmentRefAccessor classAnnotationMetadata, List<InjectionTarget> injectionTargetList) {
        IJEjbEJB existingJEjbEJB = classAnnotationMetadata.getJEjbEJB();
        ArrayList<IJEjbEJB> jEjbEJBs = classAnnotationMetadata.getJEjbEJBs();
        if (jEjbEJBs == null) {
            jEjbEJBs = new ArrayList<IJEjbEJB>();
            classAnnotationMetadata.setJEjbEJBs(jEjbEJBs);
        }
        if (existingJEjbEJB != null) {
            jEjbEJBs.add(existingJEjbEJB);
            classAnnotationMetadata.setJEjbEJB(null);
        }
        jEjbEJBs.add(jEJB);
        if (injectionTargetList != null) {
            for (InjectionTarget injectionTarget : injectionTargetList) {
                this.getInjectionTarget(classAnnotationMetadata, injectionTarget).setJEjbEJB((IJEjbEJB)jEJB);
            }
        }
    }

    private JEjbEJB buildEJB(AbsEJBRef ref) {
        JEjbEJB jEJB = new JEjbEJB();
        if (ref.getEjbRefName() != null) {
            jEJB.setName(ref.getEjbRefName());
        }
        if (ref.getMappedName() != null) {
            jEJB.setMappedName(ref.getMappedName());
        }
        if (ref.getEjbLink() != null) {
            jEJB.setBeanName(ref.getEjbLink());
        }
        return jEJB;
    }

    protected void applyAroundInvoke(List<AroundInvoke> aroundInvokeList, IEnvironmentRefAccessor classAnnotationMetadata, String type) {
        for (AroundInvoke aroundInvoke : aroundInvokeList) {
            String interceptorClassName = null;
            interceptorClassName = aroundInvoke.getClassName() == null ? this.findDefaultClassForEnvironment(classAnnotationMetadata) : MetadataMerge.encode(aroundInvoke.getClassName());
            String searchMethodName = aroundInvoke.getMethodName();
            if (searchMethodName == null) {
                throw new IllegalStateException("Invalid null method name for the callback '" + interceptorClassName + "'.");
            }
            this.applyInterceptor(type, interceptorClassName, searchMethodName, classAnnotationMetadata);
        }
    }

    protected void applyLifeCycle(List<LifeCycleCallback> lifecycleList, IEnvironmentRefAccessor classAnnotationMetadata, String type) {
        if (lifecycleList == null) {
            return;
        }
        for (LifeCycleCallback lifecycleCallback : lifecycleList) {
            String interceptorClassName = null;
            interceptorClassName = lifecycleCallback.getLifecycleCallbackClass() == null ? this.findDefaultClassForEnvironment(classAnnotationMetadata) : MetadataMerge.encode(lifecycleCallback.getLifecycleCallbackClass());
            String searchMethodName = lifecycleCallback.getLifecycleCallbackMethod();
            if (searchMethodName == null) {
                throw new IllegalStateException("Invalid null method name for the callback '" + interceptorClassName + "'.");
            }
            this.applyInterceptor(type, interceptorClassName, searchMethodName, classAnnotationMetadata);
        }
    }

    private void applyInterceptor(String type, String interceptorClassName, String methodName, IEnvironmentRefAccessor classAnnotationMetadata) {
        if (classAnnotationMetadata == null || !interceptorClassName.equals(this.findDefaultClassForEnvironment(classAnnotationMetadata))) {
            // empty if block
        }
        ICommonMethodMetadata foundMethod = null;
        ICommonClassMetadata<?, ?, ?> interceptorMetadata = this.getClassMetadata(interceptorClassName);
        boolean loop = true;
        while (foundMethod == null && loop) {
            List listMethods = interceptorMetadata.searchStandardMethodMetadata(methodName);
            if (listMethods.size() == 1) {
                foundMethod = (ICommonMethodMetadata)listMethods.get(0);
                continue;
            }
            if (listMethods.size() > 1) {
                throw new IllegalStateException("Method with name '" + methodName + "' was found more than once on the class '" + interceptorMetadata.getJClass().getName() + "'.");
            }
            String superClassName = interceptorMetadata.getJClass().getSuperName();
            if (!superClassName.equals(JAVA_LANG_OBJECT)) {
                interceptorMetadata = this.getClassMetadata(superClassName);
                continue;
            }
            loop = false;
        }
        if (foundMethod == null) {
            throw new IllegalStateException("The method named '" + methodName + "' was not found in the class '" + interceptorMetadata.getJClass().getName() + "' and all its super-classes.");
        }
        if ("post-construct".equals(type)) {
            if (!foundMethod.isPostConstruct()) {
                foundMethod.setPostConstruct(true);
            }
        } else if ("pre-destroy".equals(type) && !foundMethod.isPreDestroy()) {
            foundMethod.setPreDestroy(true);
        }
    }

    protected static String encode(String className) {
        return className.replace(".", "/");
    }

    public abstract ICommonClassMetadata<?, ?, ?> getClassMetadata(String var1);

    public abstract String findDefaultClassForEnvironment(IEnvironmentRefAccessor var1);
}

