/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Properties;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.CompositeManager;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.FactoryStateListener;
import org.apache.felix.ipojo.Handler;
import org.apache.felix.ipojo.HandlerManager;
import org.apache.felix.ipojo.IPojoContext;
import org.apache.felix.ipojo.MissingHandlerException;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.UnacceptableConfiguration;
import org.apache.felix.ipojo.architecture.ComponentDescription;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.util.Tracker;
import org.apache.felix.ipojo.util.TrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class CompositeFactory
extends ComponentFactory
implements Factory {
    private ServiceRegistration m_sr;
    static /* synthetic */ Class class$org$apache$felix$ipojo$Factory;

    public CompositeFactory(BundleContext bc, Element cm) {
        super(bc, cm);
    }

    public boolean check(Element cm) {
        this.m_factoryName = cm.getAttribute("name");
        if (this.m_factoryName == null) {
            System.err.println("A composite needs a name");
            return false;
        }
        return true;
    }

    public boolean match(ComponentFactory.HandlerIdentifier hi, ServiceReference ref) {
        String name = (String)ref.getProperty("handler.name");
        String ns = (String)ref.getProperty("handler.namespace");
        String type = (String)ref.getProperty("handler.type");
        if ("composite".equals(type)) {
            if ("org.apache.felix.ipojo".equals(ns)) {
                return name.equals(hi.getName()) && hi.getNamespace() == null;
            }
            return name.equals(hi.getName()) && ns.equals(hi.getNamespace());
        }
        return false;
    }

    protected void computeRequiredHandlers() {
        ComponentFactory.HandlerIdentifier hi;
        Element[] elems = this.m_componentMetadata.getElements();
        for (int i = 0; i < elems.length; ++i) {
            Element current = elems[i];
            ComponentFactory.HandlerIdentifier hi2 = new ComponentFactory.HandlerIdentifier(current.getName(), current.getNameSpace());
            if (this.m_handlerIdentifiers.contains(hi2)) continue;
            this.m_handlerIdentifiers.add(hi2);
        }
        String arch = this.m_componentMetadata.getAttribute("architecture");
        if ((arch == null || arch.equalsIgnoreCase("true")) && !this.m_handlerIdentifiers.contains(hi = new ComponentFactory.HandlerIdentifier("architecture", null))) {
            this.m_handlerIdentifiers.add(hi);
        }
    }

    public synchronized void stop() {
        if (this.m_tracker != null) {
            this.m_tracker.close();
        }
        Collection col = this.m_componentInstances.values();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            CompositeManager ci = (CompositeManager)it.next();
            if (ci.getState() != -1) {
                ci.kill();
            }
            m_instancesName.remove(ci.getInstanceName());
        }
        this.m_componentInstances.clear();
        if (this.m_sr != null) {
            this.m_sr.unregister();
            this.m_sr = null;
        }
        this.m_tracker = null;
        this.m_componentDesc = null;
        this.m_state = 0;
    }

    public synchronized void start() {
        if (this.m_componentDesc != null) {
            return;
        }
        if (this.m_handlerIdentifiers.size() != 0) {
            try {
                String filter = "(&(objectClass=" + (class$org$apache$felix$ipojo$Factory == null ? (class$org$apache$felix$ipojo$Factory = CompositeFactory.class$("org.apache.felix.ipojo.Factory")) : class$org$apache$felix$ipojo$Factory).getName() + ")" + "(" + "handler.type" + "=" + "composite" + ")" + "(factory.state=1)" + ")";
                this.m_tracker = new Tracker(this.m_context, this.m_context.createFilter(filter), (TrackerCustomizer)this);
                this.m_tracker.open();
            }
            catch (InvalidSyntaxException e) {
                this.m_logger.log(1, "A factory filter is not valid: " + e.getMessage());
                this.stop();
                return;
            }
        }
        try {
            this.computeFactoryState();
        }
        catch (ConfigurationException e) {
            this.m_logger.log(1, "The component type metadata are not correct : " + e.getMessage());
            this.stop();
            return;
        }
        if (this.m_isPublic) {
            this.m_sr = this.m_context.registerService(new String[]{(class$org$apache$felix$ipojo$Factory == null ? (class$org$apache$felix$ipojo$Factory = CompositeFactory.class$("org.apache.felix.ipojo.Factory")) : class$org$apache$felix$ipojo$Factory).getName()}, (Object)this, (Dictionary)this.getProperties());
        }
    }

    protected Properties getProperties() {
        Properties props = new Properties();
        if (this.m_componentDesc != null) {
            props.put("component.providedServiceSpecifications", this.m_componentDesc.getprovidedServiceSpecification());
            props.put("component.properties", this.m_componentDesc.getProperties());
            props.put("component.description", this.m_componentDesc);
        }
        props.put("factory.state", "" + this.m_state);
        props.put("factory.name", this.m_factoryName);
        return props;
    }

    public String getClassName() {
        return "composite";
    }

    public synchronized ComponentInstance createComponentInstance(Dictionary configuration) throws UnacceptableConfiguration, MissingHandlerException, ConfigurationException {
        return this.createComponentInstance(configuration, null);
    }

    public synchronized ComponentInstance createComponentInstance(Dictionary configuration, ServiceContext serviceContext) throws UnacceptableConfiguration, MissingHandlerException, ConfigurationException {
        if (configuration == null) {
            configuration = new Properties();
        }
        try {
            this.checkAcceptability(configuration);
        }
        catch (UnacceptableConfiguration e) {
            this.m_logger.log(1, "The configuration is not acceptable : " + e.getMessage());
            throw new UnacceptableConfiguration("The configuration " + configuration + " is not acceptable for " + this.m_factoryName + ": " + e.getMessage());
        }
        String in = null;
        if (configuration.get("name") != null) {
            in = (String)configuration.get("name");
        } else {
            in = this.generateName();
            configuration.put("name", in);
        }
        if (m_instancesName.contains(in)) {
            throw new UnacceptableConfiguration("Name already used : " + in + "(" + m_instancesName + ")");
        }
        m_instancesName.add(in);
        IPojoContext context = null;
        context = serviceContext == null ? new IPojoContext(this.m_context) : new IPojoContext(this.m_context, serviceContext);
        CompositeManager instance = null;
        ArrayList<HandlerManager> handlers = new ArrayList<HandlerManager>();
        for (int i = 0; i < this.m_handlerIdentifiers.size(); ++i) {
            ComponentFactory.HandlerIdentifier hi = (ComponentFactory.HandlerIdentifier)this.m_handlerIdentifiers.get(i);
            handlers.add(this.getHandlerInstance(hi, serviceContext));
        }
        CompositeManager inst = new CompositeManager(this, context, handlers.toArray(new HandlerManager[0]));
        inst.configure(this.m_componentMetadata, configuration);
        instance = inst;
        this.m_componentInstances.put(in, instance);
        instance.start();
        return instance;
    }

    public synchronized void reconfigure(Dictionary properties) throws UnacceptableConfiguration, MissingHandlerException {
        if (properties == null || properties.get("name") == null) {
            throw new UnacceptableConfiguration("The configuration does not contains the \"name\" property");
        }
        String name = (String)properties.get("name");
        CompositeManager cm = (CompositeManager)this.m_componentInstances.get(name);
        if (cm == null) {
            return;
        }
        cm.reconfigure(properties);
    }

    protected void computeFactoryState() throws ConfigurationException {
        int i;
        boolean isValid = true;
        for (i = 0; isValid && i < this.m_handlerIdentifiers.size(); ++i) {
            ComponentFactory.HandlerIdentifier hi = (ComponentFactory.HandlerIdentifier)this.m_handlerIdentifiers.get(i);
            isValid = hi.getReference() != null;
        }
        if (isValid && this.m_componentDesc == null) {
            this.computeDescription();
        }
        if (isValid && this.m_state == 0) {
            this.m_state = 1;
            if (this.m_sr != null) {
                this.m_sr.setProperties((Dictionary)this.getProperties());
            }
            for (i = 0; i < this.m_listeners.size(); ++i) {
                ((FactoryStateListener)this.m_listeners.get(i)).stateChanged(this, 1);
            }
            return;
        }
        if (!isValid && this.m_state == 1) {
            this.m_state = 0;
            Collection col = this.m_componentInstances.values();
            Iterator it = col.iterator();
            while (it.hasNext()) {
                CompositeManager ci = (CompositeManager)it.next();
                ci.kill();
                m_instancesName.remove(ci.getInstanceName());
            }
            this.m_componentInstances.clear();
            if (this.m_sr != null) {
                this.m_sr.setProperties((Dictionary)this.getProperties());
            }
            for (int i2 = 0; i2 < this.m_listeners.size(); ++i2) {
                ((FactoryStateListener)this.m_listeners.get(i2)).stateChanged(this, 0);
            }
            return;
        }
    }

    public void computeDescription() throws ConfigurationException {
        ComponentFactory.HandlerIdentifier hi;
        int i;
        ArrayList<String> l = new ArrayList<String>();
        for (i = 0; i < this.m_handlerIdentifiers.size(); ++i) {
            hi = (ComponentFactory.HandlerIdentifier)this.m_handlerIdentifiers.get(i);
            l.add(hi.getFullName());
        }
        this.m_componentDesc = new ComponentDescription(this);
        for (i = 0; i < this.m_handlerIdentifiers.size(); ++i) {
            hi = (ComponentFactory.HandlerIdentifier)this.m_handlerIdentifiers.get(i);
            HandlerManager hm = this.getHandlerInstance(hi, null);
            hm.getHandler();
            Handler ch = hm.getHandler();
            ch.initializeComponentFactory(this.m_componentDesc, this.m_componentMetadata);
            ((Pojo)((Object)ch)).getComponentInstance().dispose();
        }
    }

    private HandlerManager getHandlerInstance(ComponentFactory.HandlerIdentifier handler, ServiceContext sc) {
        Factory factory = (Factory)this.m_context.getService(handler.getReference());
        try {
            return (HandlerManager)factory.createComponentInstance(null, sc);
        }
        catch (MissingHandlerException e) {
            this.m_logger.log(1, "The creation of the composite handler " + handler.getFullName() + " has failed: " + e.getMessage());
            this.stop();
            return null;
        }
        catch (UnacceptableConfiguration e) {
            this.m_logger.log(1, "The creation of the composite handler " + handler.getFullName() + " has failed (UnacceptableConfiguration): " + e.getMessage());
            this.stop();
            return null;
        }
        catch (ConfigurationException e) {
            this.m_logger.log(1, "The creation of the composite handler " + handler.getFullName() + " has failed (ConfigurationException): " + e.getMessage());
            this.stop();
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

