/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite.service.importer;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import org.apache.felix.ipojo.PolicyServiceContext;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.composite.service.importer.ImportHandler;
import org.apache.felix.ipojo.util.Tracker;
import org.apache.felix.ipojo.util.TrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceImporter
implements TrackerCustomizer {
    private ServiceContext m_destination;
    private ServiceContext m_origin;
    private String m_specification;
    private Filter m_filter;
    private String m_filterStr;
    private boolean m_aggregate = false;
    private boolean m_optional = false;
    private boolean m_isValid;
    private int m_policy;
    private Tracker m_tracker;
    private ImportHandler m_handler;
    private List m_records = new ArrayList();
    private String m_id;
    private boolean m_isServiceLevelRequirement;

    public ServiceImporter(String specification, String filter, boolean multiple, boolean optional, BundleContext from, ServiceContext to, int policy, String id, ImportHandler in) {
        this.m_destination = to;
        try {
            this.m_filter = from.createFilter(filter);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return;
        }
        this.m_aggregate = multiple;
        this.m_specification = specification;
        this.m_optional = optional;
        this.m_handler = in;
        this.m_id = this.m_id == null ? this.m_specification : id;
        this.m_policy = policy == -1 ? 1 : policy;
    }

    public void start() {
        this.m_origin = new PolicyServiceContext(this.m_handler.getCompositeManager().getGlobalContext(), this.m_handler.getCompositeManager().getParentServiceContext(), this.m_policy);
        this.m_tracker = new Tracker((BundleContext)this.m_origin, this.m_filter, (TrackerCustomizer)this);
        this.m_tracker.open();
        this.m_isValid = this.isSatisfied();
    }

    private Dictionary getProps(ServiceReference ref) {
        Properties prop = new Properties();
        String[] keys = ref.getPropertyKeys();
        for (int i = 0; i < keys.length; ++i) {
            prop.put(keys[i], ref.getProperty(keys[i]));
        }
        return prop;
    }

    public void stop() {
        this.m_tracker.close();
        for (int i = 0; i < this.m_records.size(); ++i) {
            Record rec = (Record)this.m_records.get(i);
            rec.m_svcObject = null;
            if (rec.m_reg == null) continue;
            rec.m_reg.unregister();
            this.m_tracker.ungetService(rec.m_ref);
            rec.m_ref = null;
        }
        this.m_tracker = null;
        this.m_records.clear();
    }

    public boolean isSatisfied() {
        return this.m_optional || this.m_records.size() > 0;
    }

    private List getRecordsByRef(ServiceReference ref) {
        ArrayList<Record> l = new ArrayList<Record>();
        for (int i = 0; i < this.m_records.size(); ++i) {
            Record rec = (Record)this.m_records.get(i);
            if (rec.m_ref != ref) continue;
            l.add(rec);
        }
        return l;
    }

    public String getSpecification() {
        return this.m_specification;
    }

    protected List getProviders() {
        ArrayList<Object> l = new ArrayList<Object>();
        for (int i = 0; i < this.m_records.size(); ++i) {
            l.add(((Record)this.m_records.get(i)).m_ref.getProperty("instance.name"));
        }
        return l;
    }

    public String getFilter() {
        return this.m_filterStr;
    }

    public void setServiceLevelDependency() {
        this.m_isServiceLevelRequirement = true;
        this.m_policy = 0;
    }

    public String getId() {
        return this.m_id;
    }

    public boolean isServiceLevelRequirement() {
        return this.m_isServiceLevelRequirement;
    }

    public boolean isAggregate() {
        return this.m_aggregate;
    }

    public boolean isOptional() {
        return this.m_optional;
    }

    public boolean addingService(ServiceReference reference) {
        for (int i = 0; i < this.m_records.size(); ++i) {
            Record rec = (Record)this.m_records.get(i);
            if (rec.m_ref != reference) continue;
            return false;
        }
        return true;
    }

    public void addedService(ServiceReference reference) {
        Record rec = new Record();
        rec.m_ref = reference;
        this.m_records.add(rec);
        if (this.m_records.size() == 1 || this.m_aggregate) {
            rec.m_svcObject = this.m_tracker.getService(rec.m_ref);
            rec.m_reg = this.m_destination.registerService(this.m_specification, rec.m_svcObject, this.getProps(rec.m_ref));
        }
        if (!this.m_isValid && this.isSatisfied()) {
            this.m_isValid = true;
            this.m_handler.validating(this);
        }
    }

    public void modifiedService(ServiceReference reference, Object service) {
        List l = this.getRecordsByRef(reference);
        for (int i = 0; i < l.size(); ++i) {
            Record rec = (Record)l.get(i);
            if (rec.m_reg == null) continue;
            rec.m_reg.setProperties(this.getProps(rec.m_ref));
        }
    }

    public void removedService(ServiceReference reference, Object service) {
        List l = this.getRecordsByRef(reference);
        for (int i = 0; i < l.size(); ++i) {
            Record rec = (Record)l.get(i);
            if (rec.m_reg == null) continue;
            rec.m_svcObject = null;
            rec.m_reg.unregister();
            rec.m_reg = null;
            this.m_tracker.ungetService(rec.m_ref);
        }
        this.m_records.removeAll(l);
        if (this.m_records.size() > 0) {
            Record rec;
            if (!this.m_aggregate && (rec = (Record)this.m_records.get(0)).m_svcObject == null) {
                rec.m_svcObject = this.m_tracker.getService(rec.m_ref);
                rec.m_reg = this.m_destination.registerService(this.m_specification, rec.m_svcObject, this.getProps(rec.m_ref));
            }
        } else if (!this.m_optional) {
            this.m_isValid = false;
            this.m_handler.invalidating(this);
        }
    }

    private class Record {
        private ServiceReference m_ref;
        private ServiceRegistration m_reg;
        private Object m_svcObject;

        private Record() {
        }

        public boolean equals(Object o) {
            if (o instanceof Record) {
                Record rec = (Record)o;
                return rec.m_ref == this.m_ref;
            }
            return false;
        }
    }
}

