/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.annotation.processor.handler;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ow2.util.annotation.processor.ProcessorException;
import org.ow2.util.annotation.processor.handler.AbstractAnnotationHandler;

public abstract class AbstractInjectionHandler
extends AbstractAnnotationHandler {
    protected void doInjectMethod(Method method, Object target, Object value) throws ProcessorException {
        boolean accessibility = method.isAccessible();
        try {
            method.setAccessible(true);
            method.invoke(target, value);
        }
        catch (IllegalArgumentException e) {
            throw new ProcessorException("Cannot inject '" + method + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new ProcessorException("Cannot inject '" + method + "'", e);
        }
        catch (InvocationTargetException e) {
            throw new ProcessorException("Cannot inject '" + method + "'", e);
        }
        finally {
            method.setAccessible(accessibility);
        }
    }

    protected void doInjectField(Field field, Object target, Object value) throws ProcessorException {
        boolean accessibility = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (IllegalArgumentException e) {
            throw new ProcessorException("Cannot inject '" + field + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new ProcessorException("Cannot inject '" + field + "'", e);
        }
        finally {
            field.setAccessible(accessibility);
        }
    }
}

