/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.osgi.loader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.ow2.cmi.lb.loader.ArchiveId;

public class LoaderUtil {
    public static URL fileToURL2(File file) throws Exception {
        if (file == null) {
            throw new Exception("Invalid File. It is null");
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new Exception("Cannot get URL from the given file '" + file + "'.", e);
        }
    }

    public static URL[] getArchiveUrls(File file) {
        ArrayList<URL> clUser = new ArrayList<URL>();
        try {
            clUser.add(LoaderUtil.fileToURL2(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clUser.toArray(new URL[0]);
    }

    public static File createTempJarFile(String archiveName, byte[] archiveData) throws IOException {
        File tempFile = File.createTempFile(archiveName, ".jar");
        tempFile.deleteOnExit();
        FileOutputStream tempFos = new FileOutputStream(tempFile);
        tempFos.write(archiveData);
        tempFos.close();
        return tempFile;
    }

    public static ArchiveId buildArchiveId(String archiveHost, String location) {
        return new ArchiveId(archiveHost, location);
    }

    public static ArchiveId buildArchiveIdFromFormattedId(String stringArchiveId) {
        String archiveHost = stringArchiveId.substring(0, stringArchiveId.indexOf(ArchiveId.SEPARATOR));
        String archiveLocation = stringArchiveId.substring(stringArchiveId.indexOf(ArchiveId.SEPARATOR) + 1, stringArchiveId.length());
        ArchiveId ret = LoaderUtil.buildArchiveId(archiveHost, archiveLocation);
        ret.setName(LoaderUtil.getNameFromLocation(ret.getLocation()));
        return ret;
    }

    private static String getNameFromLocation(String location) {
        if (location == null) {
            return "NONAME";
        }
        int ind = location.lastIndexOf("/");
        if (ind != -1) {
            return location.substring(ind + 1, location.length() - 4);
        }
        return location.substring(0, location.length() - 4);
    }
}

