/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util.factory;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.cxf.common.util.factory.CachingPool;
import org.apache.cxf.common.util.factory.Factory;
import org.apache.cxf.common.util.factory.Pool;

public class ThreadSingletonPool
implements Pool {
    private transient ThreadLocalCache cache = new ThreadLocalCache();

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.cache = new ThreadLocalCache();
    }

    public Object getInstance(Factory factory) throws Throwable {
        return this.cache.getPool().getInstance(factory);
    }

    public Object getPooledInstance(Object def) {
        return this.cache.getPool().getPooledInstance(def);
    }

    public boolean isPooled() {
        return this.cache.getPool().isPooled();
    }

    private static final class ThreadLocalCache
    extends ThreadLocal {
        private ThreadLocalCache() {
        }

        protected Object initialValue() {
            return new CachingPool();
        }

        CachingPool getPool() {
            return (CachingPool)this.get();
        }
    }
}

