/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resourcemonitor.internal;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.resourcemonitor.ResourceMonitorService;
import org.ow2.jonas.resourcemonitor.internal.JOnASResourceMonitorServiceMBean;
import org.ow2.jonas.service.ServiceException;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.bindings.deploymentplan.Deployment;
import org.ow2.util.plan.deploy.deployable.api.DeploymentPlanDeployable;
import org.ow2.util.plan.deployer.api.FragmentDeploymentException;
import org.ow2.util.plan.deployer.api.FragmentUndeploymentException;
import org.ow2.util.plan.deployer.api.IDeploymentPlanDeployer;
import org.ow2.util.plan.fetcher.api.IResourceFetcher;
import org.ow2.util.plan.monitor.api.IResourceMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASResourceMonitorService
extends AbsServiceImpl
implements ResourceMonitorService,
JOnASResourceMonitorServiceMBean,
Pojo {
    private InstanceManager _cm;
    private static final long DEFAULT_MONITOR_TIME_INTERVAL = 60000L;
    private boolean _Flogger;
    private Log logger;
    private boolean _FresourceMonitor;
    private IResourceMonitor resourceMonitor;
    private boolean _FmonitorInterval;
    private Long monitorInterval;
    private boolean _FjmxService;
    private JmxService jmxService;
    private boolean _FdeploymentPlanDeployer;
    private IDeploymentPlanDeployer deploymentPlanDeployer;
    private boolean _FmonitoringThread;
    private MonitoringThread monitoringThread;
    private boolean _M$initorg_apache_felix_ipojo_InstanceManager;
    private boolean _MdoStart;
    private boolean _MdoStop;
    private boolean _MgetMonitoredResourcesCount;
    private boolean _MgetMonitoredResourcesDescriptions;
    private boolean _MgetMonitoringInterval;
    private boolean _MsetMonitoringIntervaljava_lang_Long;
    private boolean _MsetResourceMonitororg_ow2_util_plan_monitor_api_IResourceMonitor;
    private boolean _MgetResourceMonitor;
    private boolean _MgetJmxService;
    private boolean _MsetJmxServiceorg_ow2_jonas_jmx_JmxService;
    private boolean _MsetDeploymentPlanDeployerorg_ow2_util_plan_deployer_api_IDeploymentPlanDeployer;
    private boolean _MgetDeploymentPlanDeployer;

    private Log _getlogger() {
        if (!this._Flogger) {
            return this.logger;
        }
        return (Log)this._cm.getterCallback("logger");
    }

    private void _setlogger(Log log) {
        if (!this._Flogger) {
            this.logger = log;
            return;
        }
        this._cm.setterCallback("logger", (Object)log);
    }

    private IResourceMonitor _getresourceMonitor() {
        if (!this._FresourceMonitor) {
            return this.resourceMonitor;
        }
        return (IResourceMonitor)this._cm.getterCallback("resourceMonitor");
    }

    private void _setresourceMonitor(IResourceMonitor iResourceMonitor) {
        if (!this._FresourceMonitor) {
            this.resourceMonitor = iResourceMonitor;
            return;
        }
        this._cm.setterCallback("resourceMonitor", (Object)iResourceMonitor);
    }

    private Long _getmonitorInterval() {
        if (!this._FmonitorInterval) {
            return this.monitorInterval;
        }
        return (Long)this._cm.getterCallback("monitorInterval");
    }

    private void _setmonitorInterval(Long l) {
        if (!this._FmonitorInterval) {
            this.monitorInterval = l;
            return;
        }
        this._cm.setterCallback("monitorInterval", (Object)l);
    }

    private JmxService _getjmxService() {
        if (!this._FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this._cm.getterCallback("jmxService");
    }

    private void _setjmxService(JmxService jmxService) {
        if (!this._FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this._cm.setterCallback("jmxService", (Object)jmxService);
    }

    private IDeploymentPlanDeployer _getdeploymentPlanDeployer() {
        if (!this._FdeploymentPlanDeployer) {
            return this.deploymentPlanDeployer;
        }
        return (IDeploymentPlanDeployer)this._cm.getterCallback("deploymentPlanDeployer");
    }

    private void _setdeploymentPlanDeployer(IDeploymentPlanDeployer iDeploymentPlanDeployer) {
        if (!this._FdeploymentPlanDeployer) {
            this.deploymentPlanDeployer = iDeploymentPlanDeployer;
            return;
        }
        this._cm.setterCallback("deploymentPlanDeployer", (Object)iDeploymentPlanDeployer);
    }

    private MonitoringThread _getmonitoringThread() {
        if (!this._FmonitoringThread) {
            return this.monitoringThread;
        }
        return (MonitoringThread)this._cm.getterCallback("monitoringThread");
    }

    private void _setmonitoringThread(MonitoringThread monitoringThread) {
        if (!this._FmonitoringThread) {
            this.monitoringThread = monitoringThread;
            return;
        }
        this._cm.setterCallback("monitoringThread", (Object)monitoringThread);
    }

    public JOnASResourceMonitorService(InstanceManager _manager) {
        this._setComponentManager(_manager);
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.entryCallback("$initorg_apache_felix_ipojo_InstanceManager");
        }
        this._setlogger(LogFactory.getLog(JOnASResourceMonitorService.class));
        this._setresourceMonitor(null);
        this._setmonitorInterval(null);
        this._setjmxService(null);
        this._setdeploymentPlanDeployer(null);
        this._setmonitoringThread(new MonitoringThread());
        Object var3_2 = null;
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.exitCallback("$initorg_apache_felix_ipojo_InstanceManager", var3_2);
        }
    }

    protected void doStart() throws ServiceException {
        if (this._MdoStart) {
            this._cm.entryCallback("doStart");
        }
        if (this._getjmxService() != null) {
            try {
                ObjectName objectName = JonasObjectName.resourceMonitor((String)this.getDomainName());
                this._getjmxService().registerMBean((Object)this, objectName);
            }
            catch (Exception e) {
                this._getlogger().error((Object)"JMX registration error, {0}", new Object[]{e});
                ServiceException serviceException = new ServiceException("JMX registration error", (Throwable)e);
                if (this._MdoStart) {
                    this._cm.exitCallback("doStart", (Object)serviceException);
                }
                throw serviceException;
            }
        }
        if (this._getmonitorInterval() == null) {
            this._setmonitorInterval(60000L);
        }
        this._getmonitoringThread().start();
        this._getlogger().info((Object)"Resource Monitor Service Started", new Object[0]);
        Object var3_4 = null;
        if (this._MdoStart) {
            this._cm.exitCallback("doStart", var3_4);
        }
    }

    protected void doStop() throws ServiceException {
        if (this._MdoStop) {
            this._cm.entryCallback("doStop");
        }
        this._getmonitoringThread().isStopping = true;
        if (this._getjmxService() != null) {
            try {
                ObjectName objectName = JonasObjectName.resourceMonitor((String)this.getDomainName());
                this._getjmxService().unregisterMBean(objectName);
            }
            catch (Exception e) {
                this._getlogger().error((Object)"JMX registration error, {0}", new Object[]{e});
                ServiceException serviceException = new ServiceException("JMX registration error", (Throwable)e);
                if (this._MdoStop) {
                    this._cm.exitCallback("doStop", (Object)serviceException);
                }
                throw serviceException;
            }
        }
        this._getlogger().info((Object)"Resource Monitor Service Stopped", new Object[0]);
        Object var3_4 = null;
        if (this._MdoStop) {
            this._cm.exitCallback("doStop", var3_4);
        }
    }

    @Override
    public Integer getMonitoredResourcesCount() {
        if (this._MgetMonitoredResourcesCount) {
            this._cm.entryCallback("getMonitoredResourcesCount");
        }
        Integer n = this._getresourceMonitor().getMonitoredResourcesCount();
        if (this._MgetMonitoredResourcesCount) {
            this._cm.exitCallback("getMonitoredResourcesCount", (Object)n);
        }
        return n;
    }

    @Override
    public List<String> getMonitoredResourcesDescriptions() {
        if (this._MgetMonitoredResourcesDescriptions) {
            this._cm.entryCallback("getMonitoredResourcesDescriptions");
        }
        List list = this._getresourceMonitor().getMonitoredResourcesDescriptions();
        if (this._MgetMonitoredResourcesDescriptions) {
            this._cm.exitCallback("getMonitoredResourcesDescriptions", (Object)list);
        }
        return list;
    }

    @Override
    public Long getMonitoringInterval() {
        if (this._MgetMonitoringInterval) {
            this._cm.entryCallback("getMonitoringInterval");
        }
        Long l = this._getmonitorInterval();
        if (this._MgetMonitoringInterval) {
            this._cm.exitCallback("getMonitoringInterval", (Object)l);
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMonitoringInterval(Long l) {
        void interval;
        if (this._MsetMonitoringIntervaljava_lang_Long) {
            this._cm.entryCallback("setMonitoringIntervaljava_lang_Long");
        }
        this._getlogger().info((Object)"Monitoring interval set to {0}", new Object[]{interval});
        this._setmonitorInterval((Long)interval);
        Object var2_2 = null;
        if (this._MsetMonitoringIntervaljava_lang_Long) {
            this._cm.exitCallback("setMonitoringIntervaljava_lang_Long", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setResourceMonitor(IResourceMonitor iResourceMonitor) {
        void resourceMonitor;
        if (this._MsetResourceMonitororg_ow2_util_plan_monitor_api_IResourceMonitor) {
            this._cm.entryCallback("setResourceMonitororg_ow2_util_plan_monitor_api_IResourceMonitor");
        }
        this._setresourceMonitor((IResourceMonitor)resourceMonitor);
        Object var2_2 = null;
        if (this._MsetResourceMonitororg_ow2_util_plan_monitor_api_IResourceMonitor) {
            this._cm.exitCallback("setResourceMonitororg_ow2_util_plan_monitor_api_IResourceMonitor", var2_2);
        }
    }

    public IResourceMonitor getResourceMonitor() {
        if (this._MgetResourceMonitor) {
            this._cm.entryCallback("getResourceMonitor");
        }
        IResourceMonitor iResourceMonitor = this._getresourceMonitor();
        if (this._MgetResourceMonitor) {
            this._cm.exitCallback("getResourceMonitor", (Object)iResourceMonitor);
        }
        return iResourceMonitor;
    }

    public JmxService getJmxService() {
        if (this._MgetJmxService) {
            this._cm.entryCallback("getJmxService");
        }
        JmxService jmxService = this._getjmxService();
        if (this._MgetJmxService) {
            this._cm.exitCallback("getJmxService", (Object)jmxService);
        }
        return jmxService;
    }

    /*
     * WARNING - void declaration
     */
    public void setJmxService(JmxService jmxService) {
        void jmxService2;
        if (this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService) {
            this._cm.entryCallback("setJmxServiceorg_ow2_jonas_jmx_JmxService");
        }
        this._setjmxService((JmxService)jmxService2);
        Object var2_2 = null;
        if (this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService) {
            this._cm.exitCallback("setJmxServiceorg_ow2_jonas_jmx_JmxService", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDeploymentPlanDeployer(IDeploymentPlanDeployer iDeploymentPlanDeployer) {
        void deploymentPlanDeployer;
        if (this._MsetDeploymentPlanDeployerorg_ow2_util_plan_deployer_api_IDeploymentPlanDeployer) {
            this._cm.entryCallback("setDeploymentPlanDeployerorg_ow2_util_plan_deployer_api_IDeploymentPlanDeployer");
        }
        this._setdeploymentPlanDeployer((IDeploymentPlanDeployer)deploymentPlanDeployer);
        Object var2_2 = null;
        if (this._MsetDeploymentPlanDeployerorg_ow2_util_plan_deployer_api_IDeploymentPlanDeployer) {
            this._cm.exitCallback("setDeploymentPlanDeployerorg_ow2_util_plan_deployer_api_IDeploymentPlanDeployer", var2_2);
        }
    }

    public IDeploymentPlanDeployer getDeploymentPlanDeployer() {
        if (this._MgetDeploymentPlanDeployer) {
            this._cm.entryCallback("getDeploymentPlanDeployer");
        }
        IDeploymentPlanDeployer iDeploymentPlanDeployer = this._getdeploymentPlanDeployer();
        if (this._MgetDeploymentPlanDeployer) {
            this._cm.exitCallback("getDeploymentPlanDeployer", (Object)iDeploymentPlanDeployer);
        }
        return iDeploymentPlanDeployer;
    }

    private void _setComponentManager(InstanceManager instanceManager) {
        this._cm = instanceManager;
        Set set = this._cm.getRegistredFields();
        if (set != null) {
            if (set.contains("deploymentPlanDeployer")) {
                this._FdeploymentPlanDeployer = true;
            }
            if (set.contains("DEFAULT_MONITOR_TIME_INTERVAL")) {
                this._FDEFAULT_MONITOR_TIME_INTERVAL = true;
            }
            if (set.contains("resourceMonitor")) {
                this._FresourceMonitor = true;
            }
            if (set.contains("monitorInterval")) {
                this._FmonitorInterval = true;
            }
            if (set.contains("logger")) {
                this._Flogger = true;
            }
            if (set.contains("monitoringThread")) {
                this._FmonitoringThread = true;
            }
            if (set.contains("jmxService")) {
                this._FjmxService = true;
            }
        }
        if ((set = this._cm.getRegistredMethods()) != null) {
            if (set.contains("$initorg_apache_felix_ipojo_InstanceManager")) {
                this._M$initorg_apache_felix_ipojo_InstanceManager = true;
            }
            if (set.contains("doStart")) {
                this._MdoStart = true;
            }
            if (set.contains("doStop")) {
                this._MdoStop = true;
            }
            if (set.contains("getMonitoredResourcesCount")) {
                this._MgetMonitoredResourcesCount = true;
            }
            if (set.contains("getMonitoredResourcesDescriptions")) {
                this._MgetMonitoredResourcesDescriptions = true;
            }
            if (set.contains("getMonitoringInterval")) {
                this._MgetMonitoringInterval = true;
            }
            if (set.contains("setMonitoringIntervaljava_lang_Long")) {
                this._MsetMonitoringIntervaljava_lang_Long = true;
            }
            if (set.contains("setResourceMonitororg_ow2_util_plan_monitor_api_IResourceMonitor")) {
                this._MsetResourceMonitororg_ow2_util_plan_monitor_api_IResourceMonitor = true;
            }
            if (set.contains("getResourceMonitor")) {
                this._MgetResourceMonitor = true;
            }
            if (set.contains("getJmxService")) {
                this._MgetJmxService = true;
            }
            if (set.contains("setJmxServiceorg_ow2_jonas_jmx_JmxService")) {
                this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("setDeploymentPlanDeployerorg_ow2_util_plan_deployer_api_IDeploymentPlanDeployer")) {
                this._MsetDeploymentPlanDeployerorg_ow2_util_plan_deployer_api_IDeploymentPlanDeployer = true;
            }
            if (set.contains("getDeploymentPlanDeployer")) {
                this._MgetDeploymentPlanDeployer = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this._cm;
    }

    private class MonitoringThread
    extends Thread {
        boolean isStopping = false;

        private MonitoringThread() {
        }

        public void run() {
            block2: while (true) {
                try {
                    Thread.sleep(JOnASResourceMonitorService.this.monitorInterval);
                }
                catch (InterruptedException e) {
                    JOnASResourceMonitorService.this.logger.warn((Object)"Sleep interrupted", new Object[0]);
                }
                if (this.isStopping) {
                    return;
                }
                Iterator i$ = JOnASResourceMonitorService.this.resourceMonitor.getChangedResources().iterator();
                do {
                    if (!i$.hasNext()) continue block2;
                    IResourceFetcher resourceFetcher = (IResourceFetcher)i$.next();
                    this.processResource(resourceFetcher);
                } while (!this.isStopping);
                break;
            }
        }

        private void processResource(IResourceFetcher resourceFetcher) {
            JOnASResourceMonitorService.this.resourceMonitor.removeMonitoredResource(resourceFetcher);
            try {
                JOnASResourceMonitorService.this.deploymentPlanDeployer.undeployDeployment((Deployment)resourceFetcher.getDeployment());
            }
            catch (FragmentUndeploymentException e) {
                JOnASResourceMonitorService.this.logger.error((Object)"Exception while trying to redeploy deployment {0} (during undeployment) - trying to go on.", new Object[]{resourceFetcher.getDeployment()});
            }
            try {
                JOnASResourceMonitorService.this.deploymentPlanDeployer.deployDeployment((Deployment)resourceFetcher.getDeployment());
                JOnASResourceMonitorService.this.logger.info((Object)"Resource {0} changed and was redeployed", new Object[]{resourceFetcher.getDeployment()});
            }
            catch (FragmentDeploymentException e) {
                JOnASResourceMonitorService.this.logger.error((Object)"Exception while trying to redeploy deployment {0} (during deployment) - aborting", new Object[]{resourceFetcher.getDeployment()});
                DeploymentPlanDeployable deploymentPlanDeployable = JOnASResourceMonitorService.this.deploymentPlanDeployer.getOwnerDeploymentPlanDeployable((Deployment)resourceFetcher.getDeployment());
                if (deploymentPlanDeployable == null) {
                    JOnASResourceMonitorService.this.logger.error((Object)"Could not find which deployment plan owns the deployment {0} - stopping undeployment", new Object[]{resourceFetcher.getDeployment()});
                }
                try {
                    JOnASResourceMonitorService.this.deploymentPlanDeployer.undeploy((IDeployable)deploymentPlanDeployable);
                }
                catch (DeployerException deployerException) {
                    JOnASResourceMonitorService.this.logger.error((Object)"Could not undeploy deployment plan {0}", new Object[]{deploymentPlanDeployable});
                }
            }
        }
    }
}

