/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.metainfo.lib;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.ScalarField;
import org.objectweb.jorm.metainfo.lib.BasicPrimitiveElement;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.util.monolog.api.BasicLevel;

public class BasicScalarField
extends BasicPrimitiveElement
implements ScalarField {
    private String nullvalueStr = null;
    private Object nullValue = null;
    private boolean hasNullValue = false;

    public BasicScalarField(String name, PType type, int size, int scale, MetaObject parent) {
        super(name, type, size, scale, parent);
    }

    public void setNullValue(String value) {
        block2: {
            this.nullvalueStr = value;
            this.hasNullValue = true;
            try {
                this.nullValue = BasicScalarField.parseValue(this.getType(), value);
            }
            catch (Exception e) {
                this.hasNullValue = false;
                if (this.logger == null) break block2;
                this.logger.log(BasicLevel.WARN, (Object)("The null value specified for the field '" + this.getName() + "' is malformed:"), (Throwable)e);
            }
        }
    }

    public String getNullValue() {
        return this.nullvalueStr;
    }

    public Object getNullValueObject() {
        return this.nullValue;
    }

    public boolean hasNullValue() {
        return this.hasNullValue;
    }

    public static Object parseValue(PType type, String value) throws NumberFormatException, ParseException, PException {
        if (type != null) {
            if (value == null) {
                return null;
            }
            switch (type.getTypeCode()) {
                case 2: 
                case 10: {
                    return Byte.valueOf(value);
                }
                case 1: 
                case 9: {
                    return new Character(value.charAt(0));
                }
                case 3: 
                case 11: {
                    return Short.valueOf(value);
                }
                case 4: 
                case 12: {
                    return Integer.valueOf(value);
                }
                case 5: 
                case 13: {
                    return Long.valueOf(value);
                }
                case 17: {
                    return new SimpleDateFormat().parse(value);
                }
                case 18: {
                    return value.toCharArray();
                }
                case 19: {
                    return value.getBytes();
                }
                case 16: {
                    return value;
                }
                case 22: {
                    return new BigDecimal(value);
                }
                case 21: {
                    return new BigInteger(value);
                }
            }
            throw new PException("Impossible to parse with unkknwon type: " + type.getJormName());
        }
        throw new PException("Impossible to parse without type: " + type.getJormName());
    }
}

