/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.expression.lib;

import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.lib.BasicUnaryOperator;
import org.objectweb.medor.expression.lib.BasicVariableOperand;

public class StringTrim
extends BasicUnaryOperator {
    private static final long serialVersionUID = 6140861475272691834L;
    private String trimSpec = "both";
    private String trimChar = " ";

    public StringTrim() {
        super(PTypeSpace.STRING);
    }

    public StringTrim(String inputTrimSpec, String inputTrimChar, Expression strOperand) {
        super(PTypeSpace.STRING, strOperand);
        this.trimChar = inputTrimChar;
        this.trimSpec = inputTrimSpec;
    }

    public String getOperatorString() {
        return "trim";
    }

    public Operand evaluate(ParameterOperand[] pos, Object o) throws ExpressionException {
        if (this.expressions[0] == null) {
            throw new MalformedExpressionException("Null children value");
        }
        if (this.result == null) {
            throw new ExpressionException("Expression not compiled");
        }
        this.result.setValue(this.evaluate(this.getExpression(0).evaluate(pos, o).getString()));
        return this.result;
    }

    public Operand compileExpression() throws ExpressionException, MalformedExpressionException {
        this.compileOperands();
        this.compileOperands();
        this.checkOperands(new PType[][]{{PTypeSpace.STRING}});
        this.result = new BasicVariableOperand(this.type);
        this.verified = true;
        return this.result;
    }

    public String evaluate(String str) {
        if (str == null) {
            return null;
        }
        if (this.trimChar == " ") {
            if (this.trimSpec.equalsIgnoreCase("leading")) {
                if (str.startsWith(" ")) {
                    return str.substring(1);
                }
                return str;
            }
            if (this.trimSpec.equalsIgnoreCase("trailing")) {
                if (str.endsWith(" ")) {
                    return str.substring(0, str.length() - 1);
                }
                return str;
            }
            return str.trim();
        }
        if (this.trimSpec.equalsIgnoreCase("leading")) {
            if (str.startsWith(this.trimChar)) {
                return str.substring(1);
            }
            return str;
        }
        if (this.trimSpec.equalsIgnoreCase("trailing")) {
            if (str.endsWith(this.trimChar)) {
                return str.substring(0, str.length() - 1);
            }
            return str;
        }
        if (str.startsWith(this.trimChar)) {
            if (str.endsWith(this.trimChar)) {
                return str.substring(1, str.length() - 1);
            }
            return str.substring(1);
        }
        if (str.endsWith(this.trimChar)) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    public String getTrimSpec() {
        return this.trimSpec;
    }

    public String getTrimCharacter() {
        return this.trimChar;
    }
}

