/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.TupleStructure;
import org.objectweb.medor.clone.api.Cloneable;
import org.objectweb.medor.clone.lib.BasicCloneable;
import org.objectweb.medor.lib.Log;
import org.objectweb.util.monolog.api.Logger;

public class BasicTupleStructure
extends BasicCloneable
implements TupleStructure {
    protected ArrayList fields = new ArrayList();
    protected HashMap name2field = new HashMap();
    protected transient Logger logger = Log.getLoggerFactory().getLogger(this.getClass().getName());

    protected BasicTupleStructure() {
    }

    public BasicTupleStructure(Field[] fields) throws MedorException {
        this();
        for (int cpt = 0; cpt < fields.length; ++cpt) {
            this.fields.add(fields[cpt]);
            if (this.name2field.put(fields[cpt].getName(), fields[cpt]) == null) continue;
            throw new MedorException("Duplicated Field Name: " + fields[cpt].getName());
        }
    }

    public Object clone(Object clone, Map obj2clone) throws CloneNotSupportedException {
        clone = super.clone(clone, obj2clone);
        BasicTupleStructure bts = (BasicTupleStructure)clone;
        bts.fields = new ArrayList(this.fields.size());
        bts.name2field = new HashMap();
        for (int i = 0; i < this.fields.size(); ++i) {
            Field f = (Field)BasicTupleStructure.getClone((Cloneable)this.fields.get(i), obj2clone);
            bts.fields.add(f);
            bts.name2field.put(f.getName(), f);
        }
        return clone;
    }

    public Field[] getFields() {
        return this.fields.toArray(new Field[this.fields.size()]);
    }

    public Field getField(String fieldname) throws MedorException {
        Field res = (Field)this.name2field.get(fieldname);
        if (res == null) {
            throw new MedorException("Field name error: " + fieldname);
        }
        return res;
    }

    public Field getField(int fieldrank) throws MedorException {
        Field f = (Field)this.fields.get(fieldrank - 1);
        if (f == null) {
            throw new MedorException("Field rank error : " + fieldrank);
        }
        return f;
    }

    public int getFieldRank(Field f) throws MedorException {
        int idx = this.fields.indexOf(f);
        if (idx == -1) {
            throw new MedorException("Field not found: " + f.getName());
        }
        return idx + 1;
    }

    public int getSize() {
        return this.fields.size();
    }

    public boolean contains(Field f) {
        return this.fields.contains(f);
    }

    public boolean contains(String fieldName) {
        return this.name2field.containsKey(fieldName);
    }
}

