/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.query.lib;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.clone.api.Cloneable;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.query.api.CalculatedField;
import org.objectweb.medor.query.api.NestedField;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.lib.BasicCalculatedField;
import org.objectweb.medor.query.lib.BasicPropagatedField;
import org.objectweb.medor.query.lib.BasicQueryTree;
import org.objectweb.medor.tuple.api.TupleLoader;
import org.objectweb.util.monolog.api.BasicLevel;

public abstract class BasicQueryNode
extends BasicQueryTree
implements QueryNode {
    protected ArrayList children = new ArrayList();
    protected HashSet inner = new HashSet();
    protected TupleLoader tupleLoader = null;
    protected Expression filter = null;
    protected int[] indexes;

    public BasicQueryNode() {
    }

    public BasicQueryNode(String name) {
        super(name);
    }

    public Object clone(Object clone, Map obj2clone) throws CloneNotSupportedException {
        clone = super.clone(clone, obj2clone);
        BasicQueryNode bqn = (BasicQueryNode)clone;
        bqn.filter = (Expression)BasicQueryNode.getClone(this.filter, obj2clone);
        bqn.tupleLoader = this.tupleLoader;
        bqn.children = new ArrayList(this.children.size());
        for (int i = 0; i < this.children.size(); ++i) {
            bqn.children.add(BasicQueryNode.getClone((Cloneable)this.children.get(i), obj2clone));
        }
        bqn.inner = new HashSet(this.inner.size());
        Iterator it = this.inner.iterator();
        while (it.hasNext()) {
            bqn.inner.add(BasicQueryNode.getClone((Cloneable)it.next(), obj2clone));
        }
        if (this.indexes != null) {
            bqn.indexes = new int[this.indexes.length];
            System.arraycopy(this.indexes, 0, bqn.indexes, 0, this.indexes.length);
        }
        return clone;
    }

    public PropagatedField addPropagatedField(String name, PType type, QueryTreeField[] anc) throws MedorException {
        String fn = this.getFieldName(this.name, name);
        if (this.name2field.containsKey(fn)) {
            throw new MedorException("Two fields with the same name: " + fn);
        }
        BasicPropagatedField newField = new BasicPropagatedField(fn, type, this, anc);
        this.addField(newField);
        for (int i = 0; i < anc.length; ++i) {
            this.addChild(anc[i].getQueryTree());
        }
        return newField;
    }

    public CalculatedField addCalculatedField(String name, PType type, Expression exp) throws MedorException {
        String fn = this.getFieldName(this.name, name);
        if (this.name2field.containsKey(fn)) {
            throw new MedorException("Two fields with the same name: " + fn);
        }
        BasicCalculatedField newField = new BasicCalculatedField(fn, type, this, exp);
        this.addField(newField);
        this.addChildrenFromExpression(exp);
        return newField;
    }

    public QueryTreeField removeField(String name) throws MedorException {
        boolean debug;
        boolean bl = debug = this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("QueryNode: Removing field " + name));
        }
        Field toRemove = this.getField(name);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Found the field " + toRemove));
        }
        if (this.removeField(toRemove)) {
            this.updateChildren();
            return (QueryTreeField)toRemove;
        }
        return null;
    }

    public QueryTree[] getChildren() {
        boolean debug;
        boolean bl = debug = this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Calculating children for QueryNode " + this));
        }
        QueryTree[] theChildren = this.children.toArray(new QueryTree[0]);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Found " + theChildren.length + " child(ren)"));
            for (int i = 0; i < theChildren.length; ++i) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Child: " + theChildren[i]));
            }
        }
        return theChildren;
    }

    public boolean isOuter(QueryTree child) {
        if (!this.children.contains(child)) {
            throw new IllegalArgumentException("not a child: " + child);
        }
        return !this.inner.contains(child);
    }

    public void setOuter(QueryTree child, boolean value) {
        if (!this.children.contains(child)) {
            throw new IllegalArgumentException("not a child: " + child);
        }
        if (value) {
            this.inner.remove(child);
        } else {
            this.inner.add(child);
        }
    }

    public QueryTreeField replace(QueryTreeField old, QueryTreeField neo) {
        int idx;
        boolean debug;
        boolean bl = debug = this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)"Replacing field");
        }
        if ((idx = this.fields.indexOf(old)) == -1) {
            if (debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Have not found field " + old));
            }
            return null;
        }
        this.fields.set(idx, neo);
        this.name2field.remove(old.getName());
        this.name2field.put(neo.getName(), neo);
        this.updateChildren();
        return old;
    }

    public void setQueryFilter(Expression filter) throws UnsupportedOperationException {
        this.filter = filter;
        this.updateChildren();
    }

    public Expression getQueryFilter() {
        return this.filter;
    }

    public abstract short getType();

    public TupleLoader getTupleLoader() {
        return this.tupleLoader;
    }

    public void setTupleLoader(TupleLoader loader) {
        this.tupleLoader = loader;
    }

    public void updatePropagatedField(String name, QueryTreeField[] previous) throws MedorException {
        Field f = (Field)this.name2field.get(name);
        if (f == null) {
            throw new MedorException("No field found");
        }
        if (!(f instanceof PropagatedField)) {
            throw new MedorException("Bad type: " + f.getClass().getName());
        }
        ((PropagatedField)f).replacePreviousField(previous);
        this.updateChildren();
    }

    public void updateCalculatedField(String name, Expression e) throws MedorException {
        Field f = (Field)this.name2field.get(name);
        if (f == null) {
            throw new MedorException("No field found");
        }
        if (!(f instanceof CalculatedField)) {
            throw new MedorException("Bad type: " + f.getClass().getName());
        }
        ((CalculatedField)f).setExpression(e);
        this.updateChildren();
    }

    protected synchronized void addField(Field f) {
        this.name2field.put(f.getName(), f);
        this.fields.add(f);
    }

    private boolean removeField(Field f) {
        if (this.name2field.remove(f.getName()) == null) {
            return false;
        }
        this.fields.remove(f);
        return true;
    }

    protected void updateChildren() {
        this.children.clear();
        Field[] fs = this.getFields();
        for (int i = 0; i < fs.length; ++i) {
            int j;
            if (fs[i] instanceof PropagatedField) {
                Field[] anc = ((PropagatedField)fs[i]).getPreviousFields();
                for (j = 0; j < anc.length; ++j) {
                    this.addChild(((QueryTreeField)anc[j]).getQueryTree());
                }
                continue;
            }
            if (fs[i] instanceof NestedField) {
                Field[] grouped = ((NestedField)fs[i]).getFields();
                for (j = 0; j < grouped.length; ++j) {
                    this.addChild(((QueryTreeField)grouped[j]).getQueryTree());
                }
                continue;
            }
            if (!(fs[i] instanceof CalculatedField)) continue;
            this.addChildrenFromExpression(((CalculatedField)fs[i]).getExpression());
        }
        this.addChildrenFromExpression(this.getQueryFilter());
    }

    private void addChildrenFromExpression(Expression exp) {
        if (exp instanceof FieldOperand) {
            this.addChild(((QueryTreeField)((FieldOperand)exp).getField()).getQueryTree());
        } else if (exp instanceof Operator) {
            Operator op = (Operator)exp;
            for (int i = 0; i < op.getOperandNumber(); ++i) {
                this.addChildrenFromExpression(op.getExpression(i));
            }
        }
    }

    protected String getFieldName(String nodeName, String fieldName) {
        if (nodeName == null || nodeName.length() == 0) {
            return fieldName;
        }
        return nodeName + "." + fieldName;
    }

    protected void addChild(QueryTree qt) {
        if (!this.children.contains(qt)) {
            this.children.add(qt);
        }
    }
}

