/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.tuple.lib;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.clone.lib.BasicCloneable;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.TypingException;
import org.objectweb.medor.expression.api.VariableOperand;
import org.objectweb.medor.expression.lib.BasicVariableOperand;
import org.objectweb.medor.tuple.api.Tuple;
import org.objectweb.medor.tuple.api.TupleCollection;

public class MemoryTuple
extends BasicCloneable
implements Tuple {
    private VariableOperand[] uplet;

    public MemoryTuple() {
    }

    public MemoryTuple(PType[] types) {
        this.uplet = new BasicVariableOperand[this.uplet.length];
        for (int cpt = 0; cpt < types.length; ++cpt) {
            this.uplet[cpt] = new BasicVariableOperand(types[cpt]);
        }
    }

    public MemoryTuple(VariableOperand[] fields) {
        this.uplet = fields;
    }

    public MemoryTuple(Operand[] fields) throws TypingException {
        this.uplet = new BasicVariableOperand[fields.length];
        block13: for (int i = 0; i < this.uplet.length; ++i) {
            PType type = fields[i].getType();
            this.uplet[i] = new BasicVariableOperand(type);
            switch (type.getTypeCode()) {
                case 4: {
                    this.uplet[i].setValue(fields[i].getInt());
                    continue block13;
                }
                case 3: {
                    this.uplet[i].setValue(fields[i].getShort());
                    continue block13;
                }
                case 2: {
                    this.uplet[i].setValue(fields[i].getByte());
                    continue block13;
                }
                case 5: {
                    this.uplet[i].setValue(fields[i].getLong());
                    continue block13;
                }
                case 7: {
                    this.uplet[i].setValue(fields[i].getDouble());
                    continue block13;
                }
                case 0: {
                    this.uplet[i].setValue(fields[i].getBoolean());
                    continue block13;
                }
                case 6: {
                    this.uplet[i].setValue(fields[i].getFloat());
                    continue block13;
                }
                case 16: {
                    this.uplet[i].setValue(fields[i].getString());
                    continue block13;
                }
                case 1: {
                    this.uplet[i].setValue(fields[i].getChar());
                    continue block13;
                }
                case 17: {
                    this.uplet[i].setValue(fields[i].getDate());
                    continue block13;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    this.uplet[i].setValue(fields[i].getObject());
                }
            }
        }
    }

    public Object clone(Object clone, Map obj2clone) throws CloneNotSupportedException {
        clone = super.clone(clone, obj2clone);
        if (this.uplet != null) {
            MemoryTuple mt = (MemoryTuple)clone;
            mt.uplet = new VariableOperand[this.uplet.length];
            for (int i = 0; i < this.uplet.length; ++i) {
                mt.uplet[i] = (VariableOperand)MemoryTuple.getClone(this.uplet[i], obj2clone);
            }
        }
        return clone;
    }

    public boolean isDefined(int i) {
        return this.uplet[i - 1].isDefined();
    }

    public int getSize() {
        return this.uplet.length;
    }

    public Operand[] toOperandArray() {
        return this.uplet;
    }

    public int getInt(int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            return this.uplet[i - 1].getInt();
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public void setInt(int x, int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            this.uplet[i - 1].setValue(x);
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public byte getByte(int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            return this.uplet[i - 1].getByte();
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public byte[] getByteArray(int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            return this.uplet[i - 1].getByteArray();
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public void setByte(byte x, int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            this.uplet[i - 1].setValue(x);
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public double getDouble(int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            return this.uplet[i - 1].getDouble();
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public void setBigDecimal(BigDecimal x, int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            this.uplet[i - 1].setValue(x);
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public BigDecimal getBigDecimal(int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            return this.uplet[i - 1].getBigDecimal();
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public void setBigInteger(BigInteger x, int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            this.uplet[i - 1].setValue(x);
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public BigInteger getBigInteger(int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            return this.uplet[i - 1].getBigInteger();
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public void setDouble(double x, int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            this.uplet[i - 1].setValue(x);
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public float getFloat(int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            return this.uplet[i - 1].getFloat();
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public void setFloat(float x, int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            this.uplet[i - 1].setValue(x);
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public short getShort(int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            return this.uplet[i - 1].getShort();
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public void setShort(short x, int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            this.uplet[i - 1].setValue(x);
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public String getString(int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            return this.uplet[i - 1].getString();
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public void setString(String x, int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            this.uplet[i - 1].setValue(x);
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public long getLong(int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            return this.uplet[i - 1].getLong();
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public void setLong(long x, int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            this.uplet[i - 1].setValue(x);
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public Object getObject(int i) throws MedorException {
        Object result = null;
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            switch (this.uplet[i - 1].getType().getTypeCode()) {
                case 4: {
                    result = new Integer(this.uplet[i - 1].getInt());
                    break;
                }
                case 3: {
                    result = new Short(this.uplet[i - 1].getShort());
                    break;
                }
                case 2: {
                    result = new Byte(this.uplet[i - 1].getByte());
                    break;
                }
                case 5: {
                    result = new Long(this.uplet[i - 1].getLong());
                    break;
                }
                case 7: {
                    result = new Double(this.uplet[i - 1].getDouble());
                    break;
                }
                case 0: {
                    result = new Boolean(this.uplet[i - 1].getBoolean());
                    break;
                }
                case 6: {
                    result = new Float(this.uplet[i - 1].getFloat());
                    break;
                }
                case 16: {
                    String s = this.uplet[i - 1].getString();
                    result = s == null ? null : new String(s);
                    break;
                }
                case 1: {
                    result = new Character(this.uplet[i - 1].getChar());
                    break;
                }
                case 17: {
                    result = this.uplet[i - 1].getDate();
                    break;
                }
                default: {
                    if (this.uplet[i - 1].getType().getJormName().equalsIgnoreCase("collection")) {
                        result = this.uplet[i - 1].getObject();
                        break;
                    }
                    result = this.uplet[i - 1].getObject();
                    break;
                }
            }
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
        return result;
    }

    public boolean getBoolean(int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            return this.uplet[i - 1].getBoolean();
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public void setBoolean(boolean x, int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            this.uplet[i - 1].setValue(x);
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public char getChar(int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            return this.uplet[i - 1].getChar();
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public char[] getCharArray(int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            return this.uplet[i - 1].getCharArray();
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public void setChar(char x, int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            this.uplet[i - 1].setValue(x);
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public Date getDate(int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            return this.uplet[i - 1].getDate();
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public void setDate(Date x, int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        try {
            this.uplet[i - 1].setValue(x);
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
    }

    public TupleCollection getTupleCollection(int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        return (TupleCollection)this.uplet[i - 1].getObject();
    }

    public Operand getLikeOperand(int i) throws MedorException {
        if (i <= 0 || i > this.uplet.length) {
            throw new MedorException("Invalid Field index: " + i);
        }
        return this.uplet[i - 1];
    }
}

