/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.perseus.concurrency.lib;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.perseus.concurrency.lib.Semaphore;

public class TimeStamp
extends Semaphore {
    private long timeStamp;
    private Map ctxtTimeStamp = new HashMap();
    public Object oid;
    private int reservations = 0;

    public TimeStamp(Object oid) {
        this.oid = oid;
    }

    public void readIntention(Object ctxt) {
        if (this.ctxtTimeStamp.get(ctxt) == null) {
            this.ctxtTimeStamp.put(ctxt, new Long(this.timeStamp << 1));
        }
        --this.reservations;
    }

    public void writeIntention(Object ctxt) {
        long l;
        boolean dirty;
        Long lts = (Long)this.ctxtTimeStamp.get(ctxt);
        if (lts == null) {
            lts = new Long(this.timeStamp << 1);
            this.ctxtTimeStamp.put(ctxt, lts);
        }
        boolean bl = dirty = ((l = lts.longValue()) & 1L) != 0L;
        if (!dirty) {
            long ts = l >>> 1;
            this.ctxtTimeStamp.put(ctxt, new Long(ts + 1L << 1 | 1L));
        }
        --this.reservations;
    }

    public boolean validate(Object ctxt) {
        Long l = (Long)this.ctxtTimeStamp.get(ctxt);
        if (l != null) {
            long ts;
            long v = l;
            boolean dirty = (v & 1L) != 0L;
            long l2 = ts = dirty ? (v >>> 1) - 1L : v >>> 1;
            if (ts != this.timeStamp) {
                return false;
            }
        }
        return true;
    }

    public void finalize(Object ctxt) {
        Long l = (Long)this.ctxtTimeStamp.get(ctxt);
        if (l != null) {
            this.timeStamp = l >>> 1;
        }
    }

    public boolean close(Object ctxt) {
        this.ctxtTimeStamp.remove(ctxt);
        return this.reservations == 0 && this.ctxtTimeStamp.isEmpty();
    }

    public void reserve() {
        ++this.reservations;
    }

    public boolean isDirty(Object ctx) {
        Long l = (Long)this.ctxtTimeStamp.get(ctx);
        if (l != null) {
            long v = l;
            return (v & 1L) != 0L;
        }
        return false;
    }
}

