/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSDocInfoStore;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.EnvelopeIdResolver;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.PKIPathSecurity;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectStatement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WSSecurityEngine {
    private static final String VALUE_TYPE = "ValueType";
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$WSSecurityEngine == null ? (class$org$apache$ws$security$WSSecurityEngine = WSSecurityEngine.class$("org.apache.ws.security.WSSecurityEngine")) : class$org$apache$ws$security$WSSecurityEngine).getName());
    private static Log tlog = LogFactory.getLog((String)"org.apache.ws.security.TIME");
    private static final Class[] constructorType = new Class[]{class$org$apache$ws$security$WSSConfig == null ? (class$org$apache$ws$security$WSSConfig = WSSecurityEngine.class$("org.apache.ws.security.WSSConfig")) : class$org$apache$ws$security$WSSConfig, class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = WSSecurityEngine.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element};
    private static WSSecurityEngine engine = null;
    private byte[] decryptedBytes = null;
    private boolean doDebug = false;
    protected WSSConfig wssConfig = WSSConfig.getDefaultWSConfig();
    protected QName binaryToken;
    protected QName usernameToken;
    protected QName timeStamp;
    protected static final QName SIGNATURE = new QName("http://www.w3.org/2000/09/xmldsig#", "Signature");
    protected static final QName ENCRYPTED_KEY = new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
    protected static final QName REFERENCE_LIST = new QName("http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
    protected static final QName SAML_TOKEN = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
    static /* synthetic */ Class class$org$apache$ws$security$WSSecurityEngine;
    static /* synthetic */ Class class$org$apache$ws$security$WSSConfig;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$org$apache$ws$security$message$token$X509Security;
    static /* synthetic */ Class class$org$apache$ws$security$message$token$PKIPathSecurity;

    public WSSecurityEngine() {
        this(WSSConfig.getDefaultWSConfig());
    }

    public WSSecurityEngine(WSSConfig wssConfig) {
        this.wssConfig = wssConfig;
        this.binaryToken = new QName(wssConfig.getWsseNS(), "BinarySecurityToken");
        this.usernameToken = new QName(wssConfig.getWsseNS(), "UsernameToken");
        this.timeStamp = new QName(wssConfig.getWsuNS(), "Timestamp");
    }

    public static synchronized WSSecurityEngine getInstance() {
        if (engine == null) {
            engine = new WSSecurityEngine();
        }
        return engine;
    }

    public static synchronized WSSecurityEngine getInstance(WSSConfig wssConfig) {
        if (engine == null) {
            engine = new WSSecurityEngine(wssConfig);
        }
        return engine;
    }

    public Vector processSecurityHeader(Document doc, String actor, CallbackHandler cb, Crypto crypto) throws WSSecurityException {
        return this.processSecurityHeader(doc, actor, cb, crypto, crypto);
    }

    public Vector processSecurityHeader(Document doc, String actor, CallbackHandler cb, Crypto sigCrypto, Crypto decCrypto) throws WSSecurityException {
        this.doDebug = log.isDebugEnabled();
        if (this.doDebug) {
            log.debug((Object)"enter processSecurityHeader()");
        }
        if (actor == null) {
            actor = "";
        }
        Vector wsResult = null;
        SOAPConstants sc = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
        Element elem = WSSecurityUtil.getSecurityHeader(this.wssConfig, doc, actor, sc);
        if (elem != null) {
            if (this.doDebug) {
                log.debug((Object)("Processing WS-Security header for '" + actor + "' actor."));
            }
            wsResult = this.processSecurityHeader(elem, cb, sigCrypto, decCrypto);
        }
        return wsResult;
    }

    protected Vector processSecurityHeader(Element securityHeader, CallbackHandler cb, Crypto sigCrypto, Crypto decCrypto) throws WSSecurityException {
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        WSDocInfo wsDocInfo = new WSDocInfo(securityHeader.getOwnerDocument().hashCode());
        wsDocInfo.setCrypto(sigCrypto);
        NodeList list = securityHeader.getChildNodes();
        int len = list.getLength();
        Principal lastPrincipalFound = null;
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        Vector<WSSecurityEngineResult> returnResults = new Vector<WSSecurityEngineResult>();
        for (int i = 0; i < len; ++i) {
            Node elem = list.item(i);
            if (elem.getNodeType() != 1) continue;
            QName el = new QName(elem.getNamespaceURI(), elem.getLocalName());
            if (el.equals(SIGNATURE)) {
                if (this.doDebug) {
                    log.debug((Object)"Found signature element");
                }
                WSDocInfoStore.store(wsDocInfo);
                X509Certificate[] returnCert = new X509Certificate[1];
                Vector[] returnQname = new Vector[1];
                try {
                    lastPrincipalFound = this.verifyXMLSignature((Element)elem, sigCrypto, returnCert, returnQname);
                }
                catch (WSSecurityException ex) {
                    throw ex;
                }
                finally {
                    WSDocInfoStore.delete(wsDocInfo);
                }
                if (lastPrincipalFound instanceof WSUsernameTokenPrincipal) {
                    returnResults.add(0, new WSSecurityEngineResult(64, lastPrincipalFound, null, returnQname[0]));
                    continue;
                }
                returnResults.add(0, new WSSecurityEngineResult(2, lastPrincipalFound, returnCert[0], returnQname[0]));
                continue;
            }
            if (el.equals(ENCRYPTED_KEY)) {
                if (this.doDebug) {
                    log.debug((Object)"Found encrypted key element");
                }
                if (decCrypto == null) {
                    throw new WSSecurityException(0, "noDecCryptoFile");
                }
                if (cb == null) {
                    throw new WSSecurityException(0, "noCallback");
                }
                this.handleEncryptedKey((Element)elem, cb, decCrypto);
                returnResults.add(0, new WSSecurityEngineResult(4, null, null, null));
                continue;
            }
            if (el.equals(REFERENCE_LIST)) {
                if (this.doDebug) {
                    log.debug((Object)"Found reference list element");
                }
                if (cb == null) {
                    throw new WSSecurityException(0, "noCallback");
                }
                this.handleReferenceList((Element)elem, cb);
                returnResults.add(0, new WSSecurityEngineResult(4, null, null, null));
                continue;
            }
            if (el.equals(this.usernameToken)) {
                if (this.doDebug) {
                    log.debug((Object)"Found UsernameToken list element");
                }
                lastPrincipalFound = this.handleUsernameToken((Element)elem, cb);
                returnResults.add(0, new WSSecurityEngineResult(1, lastPrincipalFound, null, null));
                continue;
            }
            if (el.equals(SAML_TOKEN)) {
                if (this.doDebug) {
                    log.debug((Object)"Found SAML Assertion element");
                }
                SAMLAssertion assertion = this.handleSAMLToken((Element)elem);
                wsDocInfo.setAssertion((Element)elem);
                returnResults.add(0, new WSSecurityEngineResult(8, assertion));
                continue;
            }
            if (el.equals(this.timeStamp)) {
                if (this.doDebug) {
                    log.debug((Object)"Found Timestamp list element");
                }
                Timestamp timestamp = new Timestamp(this.wssConfig, (Element)elem);
                this.handleTimestamp(timestamp);
                returnResults.add(0, new WSSecurityEngineResult(32, timestamp));
                continue;
            }
            if (!this.doDebug) continue;
            log.debug((Object)("Unknown Element: " + elem.getLocalName() + " " + elem.getNamespaceURI()));
        }
        if (tlog.isDebugEnabled()) {
            t2 = System.currentTimeMillis();
            tlog.debug((Object)("processHeader: total= " + (t2 - t0) + ", prepare= " + (t1 - t0) + ", handle= " + (t2 - t1)));
        }
        return returnResults;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Principal verifyXMLSignature(Element elem, Crypto crypto, X509Certificate[] returnCert, Vector[] returnQname) throws WSSecurityException {
        if (this.doDebug) {
            log.debug((Object)"Verify XML Signature");
        }
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        XMLSignature sig = null;
        try {
            sig = new XMLSignature(elem, null);
        }
        catch (XMLSecurityException e2) {
            throw new WSSecurityException(6, "noXMLSig");
        }
        sig.addResourceResolver(EnvelopeIdResolver.getInstance(this.wssConfig));
        X509Certificate[] certs = null;
        KeyInfo info = sig.getKeyInfo();
        byte[] secretKey = null;
        UsernameToken ut = null;
        if (info != null) {
            Node node = this.wssConfig.getProcessNonCompliantMessages() ? WSSecurityUtil.getDirectChildWSSE(info.getElement(), "SecurityTokenReference") : WSSecurityUtil.getDirectChild(info.getElement(), "SecurityTokenReference", this.wssConfig.getWsseNS());
            if (node == null) {
                throw new WSSecurityException(3, "unsupportedKeyInfo");
            }
            SecurityTokenReference secRef = new SecurityTokenReference(this.wssConfig, (Element)node);
            int docHash = elem.getOwnerDocument().hashCode();
            WSDocInfo wsDocInfo = WSDocInfoStore.lookup(docHash);
            if (secRef.containsReference()) {
                Element token = secRef.getTokenElement(elem.getOwnerDocument(), wsDocInfo);
                QName el = new QName(token.getNamespaceURI(), token.getLocalName());
                if (token.getLocalName().equals(UsernameToken.TOKEN)) {
                    ut = new UsernameToken(this.wssConfig, token);
                    secretKey = ut.getSecretKey();
                } else {
                    if (crypto == null) {
                        throw new WSSecurityException(0, "noSigCryptoFile");
                    }
                    if (token.getLocalName().equals(this.binaryToken.getLocalPart())) {
                        certs = this.getCertificatesTokenReference(token, crypto);
                    } else {
                        if (!el.equals(SAML_TOKEN)) throw new WSSecurityException(3, "unsupportedKeyInfo", new Object[]{el.toString()});
                        certs = this.getCertificatesFromSAML(token, crypto);
                    }
                }
            } else if (secRef.containsX509IssuerSerial()) {
                certs = secRef.getX509IssuerSerial(crypto);
            } else {
                if (!secRef.containsKeyIdentifier()) throw new WSSecurityException(3, "unsupportedKeyInfo", new Object[]{node.toString()});
                certs = secRef.getKeyIdentifier(crypto);
            }
        } else {
            if (crypto == null) {
                throw new WSSecurityException(0, "noSigCryptoFile");
            }
            if (crypto.getDefaultX509Alias() == null) throw new WSSecurityException(3, "unsupportedKeyInfo");
            certs = crypto.getCertificates(crypto.getDefaultX509Alias());
        }
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        if ((certs == null || certs.length == 0 || certs[0] == null) && secretKey == null) {
            throw new WSSecurityException(6);
        }
        if (certs != null) {
            try {
                certs[0].checkValidity();
            }
            catch (CertificateExpiredException e) {
                throw new WSSecurityException(6, "invalidCert");
            }
            catch (CertificateNotYetValidException e) {
                throw new WSSecurityException(6, "invalidCert");
            }
        }
        try {
            boolean signatureOk = false;
            signatureOk = certs != null ? sig.checkSignatureValue(certs[0]) : sig.checkSignatureValue(sig.createSecretKey(secretKey));
            if (!signatureOk) throw new WSSecurityException(6);
            if (tlog.isDebugEnabled()) {
                t2 = System.currentTimeMillis();
                tlog.debug((Object)("Verify: total= " + (t2 - t0) + ", prepare-cert= " + (t1 - t0) + ", verify= " + (t2 - t1)));
            }
            SignedInfo si = sig.getSignedInfo();
            int numReferences = si.getLength();
            Vector<QName> qvec = new Vector<QName>(numReferences);
            for (int i = 0; i < numReferences; ++i) {
                Reference siRef;
                try {
                    siRef = si.item(i);
                }
                catch (XMLSecurityException e3) {
                    throw new WSSecurityException(6);
                }
                String uri = siRef.getURI();
                Element se = WSSecurityUtil.getElementByWsuId(this.wssConfig, elem.getOwnerDocument(), uri);
                if (se == null) {
                    se = WSSecurityUtil.getElementByGenId(elem.getOwnerDocument(), uri);
                }
                if (se == null) {
                    throw new WSSecurityException(6);
                }
                QName qn = new QName(se.getNamespaceURI(), se.getLocalName());
                qvec.add(qn);
            }
            returnQname[0] = qvec;
            if (certs != null) {
                returnCert[0] = certs[0];
                return certs[0].getSubjectDN();
            }
            WSUsernameTokenPrincipal principal = new WSUsernameTokenPrincipal(ut.getName(), ut.isHashed());
            principal.setNonce(ut.getNonce());
            principal.setPassword(ut.getPassword());
            principal.setCreatedTime(ut.getCreated());
            return principal;
        }
        catch (XMLSignatureException e1) {
            throw new WSSecurityException(6);
        }
    }

    public X509Certificate[] getCertificatesTokenReference(Element elem, Crypto crypto) throws WSSecurityException {
        BinarySecurity token = this.createSecurityToken(elem);
        if (token instanceof PKIPathSecurity) {
            return ((PKIPathSecurity)token).getX509Certificates(false, crypto);
        }
        if (token instanceof X509Security) {
            X509Certificate cert = ((X509Security)token).getX509Certificate(crypto);
            X509Certificate[] certs = new X509Certificate[]{cert};
            return certs;
        }
        throw new WSSecurityException(1, "unhandledToken", new Object[]{token.getClass().getName()});
    }

    protected X509Certificate[] getCertificatesFromSAML(Element elem, Crypto crypto) throws WSSecurityException {
        SAMLAssertion assertion;
        try {
            assertion = new SAMLAssertion(elem);
        }
        catch (SAMLException e) {
            throw new WSSecurityException(0, "invalidSAMLToken", new Object[]{"for Signature (cannot parse)"});
        }
        SAMLSubjectStatement samlSubjS = null;
        Iterator it = assertion.getStatements();
        while (it.hasNext()) {
            SAMLObject so = (SAMLObject)it.next();
            if (!(so instanceof SAMLSubjectStatement)) continue;
            samlSubjS = (SAMLSubjectStatement)so;
            break;
        }
        SAMLSubject samlSubj = null;
        if (samlSubjS != null) {
            samlSubj = samlSubjS.getSubject();
        }
        if (samlSubj == null) {
            throw new WSSecurityException(0, "invalidSAMLToken", new Object[]{"for Signature (no Subject)"});
        }
        Element e = samlSubj.getKeyInfo();
        X509Certificate[] certs = null;
        try {
            KeyInfo ki = new KeyInfo(e, null);
            if (ki.containsX509Data()) {
                X509Data data = ki.itemX509Data(0);
                XMLX509Certificate certElem = null;
                if (data != null && data.containsCertificate()) {
                    certElem = data.itemCertificate(0);
                }
                if (certElem != null) {
                    X509Certificate cert = certElem.getX509Certificate();
                    certs = new X509Certificate[]{cert};
                }
            }
        }
        catch (XMLSecurityException e3) {
            throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate (key holder)"});
        }
        return certs;
    }

    private BinarySecurity createSecurityToken(Element element) throws WSSecurityException {
        BinarySecurity token = new BinarySecurity(this.wssConfig, element);
        String type = token.getValueType();
        Class clazz = null;
        if (this.wssConfig.getProcessNonCompliantMessages() || this.wssConfig.isBSTValuesPrefixed()) {
            if (type.endsWith("X509v3")) {
                clazz = class$org$apache$ws$security$message$token$X509Security == null ? (class$org$apache$ws$security$message$token$X509Security = WSSecurityEngine.class$("org.apache.ws.security.message.token.X509Security")) : class$org$apache$ws$security$message$token$X509Security;
            } else if (type.endsWith("X509PKIPathv1")) {
                clazz = class$org$apache$ws$security$message$token$PKIPathSecurity == null ? (class$org$apache$ws$security$message$token$PKIPathSecurity = WSSecurityEngine.class$("org.apache.ws.security.message.token.PKIPathSecurity")) : class$org$apache$ws$security$message$token$PKIPathSecurity;
            }
        } else if (type.equals(X509Security.getType(this.wssConfig))) {
            clazz = class$org$apache$ws$security$message$token$X509Security == null ? (class$org$apache$ws$security$message$token$X509Security = WSSecurityEngine.class$("org.apache.ws.security.message.token.X509Security")) : class$org$apache$ws$security$message$token$X509Security;
        } else if (type.equals(PKIPathSecurity.getType(this.wssConfig))) {
            Class clazz2 = clazz = class$org$apache$ws$security$message$token$PKIPathSecurity == null ? (class$org$apache$ws$security$message$token$PKIPathSecurity = WSSecurityEngine.class$("org.apache.ws.security.message.token.PKIPathSecurity")) : class$org$apache$ws$security$message$token$PKIPathSecurity;
        }
        if (clazz == null) {
            throw new WSSecurityException(1, "unsupportedBinaryTokenType", new Object[]{type});
        }
        try {
            Constructor constructor = clazz.getConstructor(constructorType);
            if (constructor == null) {
                throw new WSSecurityException(0, "invalidConstructor", new Object[]{clazz});
            }
            return (BinarySecurity)constructor.newInstance(this.wssConfig, element);
        }
        catch (InvocationTargetException e) {
            Throwable ee = e.getTargetException();
            if (ee instanceof WSSecurityException) {
                throw (WSSecurityException)ee;
            }
            throw new WSSecurityException(0, null, null, e);
        }
        catch (NoSuchMethodException e) {
            throw new WSSecurityException(0, null, null, e);
        }
        catch (InstantiationException e) {
            throw new WSSecurityException(0, null, null, e);
        }
        catch (IllegalAccessException e) {
            throw new WSSecurityException(0, null, null, e);
        }
    }

    public WSUsernameTokenPrincipal handleUsernameToken(Element token, CallbackHandler cb) throws WSSecurityException {
        WSPasswordCallback pwCb;
        UsernameToken ut = new UsernameToken(this.wssConfig, token);
        String user = ut.getName();
        String password = ut.getPassword();
        String nonce = ut.getNonce();
        String createdTime = ut.getCreated();
        String pwType = ut.getPasswordType();
        if (this.doDebug) {
            log.debug((Object)("UsernameToken user " + user));
            log.debug((Object)("UsernameToken password " + password));
        }
        Callback[] callbacks = new Callback[1];
        if (ut.isHashed()) {
            String passDigest;
            if (cb == null) {
                throw new WSSecurityException(0, "noCallback");
            }
            pwCb = new WSPasswordCallback(user, 2);
            callbacks[0] = pwCb;
            try {
                cb.handle(callbacks);
            }
            catch (IOException e) {
                throw new WSSecurityException(0, "noPassword", new Object[]{user});
            }
            catch (UnsupportedCallbackException e) {
                throw new WSSecurityException(0, "noPassword", new Object[]{user});
            }
            String origPassword = pwCb.getPassword();
            if (this.doDebug) {
                log.debug((Object)("UsernameToken callback password " + origPassword));
            }
            if (origPassword == null) {
                throw new WSSecurityException(0, "noPassword", new Object[]{user});
            }
            if (nonce != null && createdTime != null && !(passDigest = UsernameToken.doPasswordDigest(nonce, createdTime, origPassword)).equals(password)) {
                throw new WSSecurityException(5);
            }
        } else if (cb != null) {
            pwCb = new WSPasswordCallback(user, password, pwType, 5);
            callbacks[0] = pwCb;
            try {
                cb.handle(callbacks);
            }
            catch (IOException e) {
                throw new WSSecurityException(0, "noPassword", new Object[]{user});
            }
            catch (UnsupportedCallbackException e) {
                throw new WSSecurityException(0, "noPassword", new Object[]{user});
            }
        }
        WSUsernameTokenPrincipal principal = new WSUsernameTokenPrincipal(user, ut.isHashed());
        principal.setNonce(nonce);
        principal.setPassword(password);
        principal.setCreatedTime(createdTime);
        principal.setPasswordType(pwType);
        return principal;
    }

    public SAMLAssertion handleSAMLToken(Element token) throws WSSecurityException {
        boolean result = false;
        SAMLAssertion assertion = null;
        try {
            assertion = new SAMLAssertion(token);
            result = true;
            if (this.doDebug) {
                log.debug((Object)("SAML Assertion issuer " + assertion.getIssuer()));
            }
        }
        catch (SAMLException e) {
            throw new WSSecurityException(0, "invalidSAMLsecurity", null, e);
        }
        if (!result) {
            throw new WSSecurityException(5);
        }
        return assertion;
    }

    public void handleTimestamp(Timestamp timestamp) throws WSSecurityException {
        if (this.doDebug) {
            log.debug((Object)"Preparing to verify the timestamp");
            XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
            log.debug((Object)("Current time: " + zulu.format(Calendar.getInstance().getTime())));
            log.debug((Object)("Timestamp created: " + zulu.format(timestamp.getCreated().getTime())));
            log.debug((Object)("Timestamp expires: " + zulu.format(timestamp.getExpires().getTime())));
        }
        Calendar rightNow = Calendar.getInstance();
        if (timestamp.getExpires().before(rightNow)) {
            throw new WSSecurityException(3, "invalidTimestamp", new Object[]{"The security semantics of message have expired"});
        }
    }

    public void handleEncryptedKey(Element xencEncryptedKey, CallbackHandler cb, Crypto crypto) throws WSSecurityException {
        this.handleEncryptedKey(xencEncryptedKey, cb, crypto, null);
    }

    public void handleEncryptedKey(Element xencEncryptedKey, PrivateKey privatekey) throws WSSecurityException {
        this.handleEncryptedKey(xencEncryptedKey, null, null, privatekey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleEncryptedKey(Element xencEncryptedKey, CallbackHandler cb, Crypto crypto, PrivateKey privateKey) throws WSSecurityException {
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        Document doc = xencEncryptedKey.getOwnerDocument();
        Node tmpE = null;
        tmpE = (Element)WSSecurityUtil.getDirectChild(xencEncryptedKey, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#");
        String keyEncAlgo = null;
        if (tmpE != null) {
            keyEncAlgo = tmpE.getAttribute("Algorithm");
        }
        if (keyEncAlgo == null) {
            throw new WSSecurityException(2, "noEncAlgo");
        }
        Cipher cipher = WSSecurityUtil.getCipherInstance(keyEncAlgo);
        Element xencCipherValue = null;
        tmpE = (Element)WSSecurityUtil.getDirectChild(xencEncryptedKey, "CipherData", "http://www.w3.org/2001/04/xmlenc#");
        if (tmpE != null) {
            xencCipherValue = (Element)WSSecurityUtil.getDirectChild(tmpE, "CipherValue", "http://www.w3.org/2001/04/xmlenc#");
        }
        if (xencCipherValue == null) {
            throw new WSSecurityException(3, "noCipher");
        }
        if (privateKey == null) {
            String alias;
            Element keyInfo = (Element)WSSecurityUtil.getDirectChild(xencEncryptedKey, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
            if (keyInfo != null) {
                Element secRefToken = this.wssConfig.getProcessNonCompliantMessages() ? (Element)WSSecurityUtil.getDirectChildWSSE(keyInfo, "SecurityTokenReference") : (Element)WSSecurityUtil.getDirectChild(keyInfo, "SecurityTokenReference", this.wssConfig.getWsseNS());
                if (secRefToken == null) {
                    secRefToken = (Element)WSSecurityUtil.getDirectChild(keyInfo, "KeyName", "http://www.w3.org/2000/09/xmldsig#");
                }
                if (secRefToken == null) {
                    throw new WSSecurityException(3, "noSecTokRef");
                }
                SecurityTokenReference secRef = new SecurityTokenReference(this.wssConfig, secRefToken);
                alias = null;
                if (secRef.containsX509IssuerSerial()) {
                    alias = secRef.getX509IssuerSerialAlias(crypto);
                    if (this.doDebug) {
                        log.debug((Object)("X509IssuerSerial alias: " + alias));
                    }
                } else if (secRef.containsKeyIdentifier()) {
                    X509Certificate[] certs = secRef.getKeyIdentifier(crypto);
                    if (certs == null || certs.length < 1 || certs[0] == null) {
                        throw new WSSecurityException(0, "invalidX509Data", new Object[]{"for decryption (KeyId)"});
                    }
                    alias = crypto.getAliasForX509Cert(certs[0]);
                    if (this.doDebug) {
                        log.debug((Object)("cert: " + certs[0]));
                        log.debug((Object)("KeyIdentifier Alias: " + alias));
                    }
                } else if (secRef.containsReference()) {
                    Element bstElement = secRef.getTokenElement(doc, null);
                    QName el = new QName(bstElement.getNamespaceURI(), bstElement.getLocalName());
                    if (!el.equals(this.binaryToken)) throw new WSSecurityException(3, "unsupportedToken", null);
                    X509Security token = null;
                    String value = bstElement.getAttribute(VALUE_TYPE);
                    if (this.wssConfig.getProcessNonCompliantMessages()) {
                        for (int i = 0; i < WSConstants.WSSE_NS_ARRAY.length && value.length() == 0; ++i) {
                            String ns = WSConstants.WSSE_NS_ARRAY[i];
                            value = bstElement.getAttributeNS(ns, VALUE_TYPE);
                        }
                    }
                    if (!value.endsWith("X509v3") || (token = new X509Security(this.wssConfig, bstElement)) == null) {
                        throw new WSSecurityException(1, "unsupportedBinaryTokenType", new Object[]{"for decryption (BST)"});
                    }
                    X509Certificate cert = token.getX509Certificate(crypto);
                    if (cert == null) {
                        throw new WSSecurityException(0, "invalidX509Data", new Object[]{"for decryption"});
                    }
                    alias = crypto.getAliasForX509Cert(cert);
                    if (this.doDebug) {
                        log.debug((Object)("BST Alias: " + alias));
                    }
                } else {
                    if (!secRef.containsKeyName()) throw new WSSecurityException(0, "unsupportedKeyId");
                    alias = crypto.getAliasForX509Cert(secRef.getKeyNameValue());
                    if (this.doDebug) {
                        log.debug((Object)("KeyName alias: " + alias));
                    }
                }
            } else {
                if (crypto.getDefaultX509Alias() == null) throw new WSSecurityException(3, "noKeyinfo");
                alias = crypto.getDefaultX509Alias();
            }
            WSPasswordCallback pwCb = new WSPasswordCallback(alias, 1);
            Callback[] callbacks = new Callback[]{pwCb};
            try {
                cb.handle(callbacks);
            }
            catch (IOException e) {
                throw new WSSecurityException(0, "noPassword", new Object[]{alias});
            }
            catch (UnsupportedCallbackException e) {
                throw new WSSecurityException(0, "noPassword", new Object[]{alias});
            }
            String password = pwCb.getPassword();
            if (password == null) {
                throw new WSSecurityException(0, "noPassword", new Object[]{alias});
            }
            try {
                privateKey = crypto.getPrivateKey(alias, password);
            }
            catch (Exception e) {
                throw new WSSecurityException(8, null, null, e);
            }
        }
        try {
            cipher.init(2, privateKey);
        }
        catch (Exception e1) {
            throw new WSSecurityException(8, null, null, e1);
        }
        try {
            this.decryptedBytes = cipher.doFinal(WSSecurityEngine.getDecodedBase64EncodedData(xencCipherValue));
        }
        catch (IllegalStateException e2) {
            throw new WSSecurityException(8, null, null, e2);
        }
        catch (IllegalBlockSizeException e2) {
            throw new WSSecurityException(8, null, null, e2);
        }
        catch (BadPaddingException e2) {
            throw new WSSecurityException(8, null, null, e2);
        }
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        String dataRefURI = null;
        Element refList = (Element)WSSecurityUtil.getDirectChild(xencEncryptedKey, "ReferenceList", "http://www.w3.org/2001/04/xmlenc#");
        if (refList != null) {
            for (tmpE = refList.getFirstChild(); tmpE != null; tmpE = tmpE.getNextSibling()) {
                if (tmpE.getNodeType() != 1 || !tmpE.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#") || !tmpE.getLocalName().equals("DataReference")) continue;
                dataRefURI = ((Element)tmpE).getAttribute("URI");
                this.decryptDataRef(doc, dataRefURI, this.decryptedBytes);
            }
        }
        if (!tlog.isDebugEnabled()) return;
        t2 = System.currentTimeMillis();
        tlog.debug((Object)("XMLDecrypt: total= " + (t2 - t0) + ", get-sym-key= " + (t1 - t0) + ", decrypt= " + (t2 - t1)));
    }

    private void decryptDataRef(Document doc, String dataRefURI, byte[] decryptedData) throws WSSecurityException {
        if (this.doDebug) {
            log.debug((Object)("found data refernce: " + dataRefURI));
        }
        Element encBodyData = null;
        encBodyData = WSSecurityUtil.getElementByWsuId(this.wssConfig, doc, dataRefURI);
        if (encBodyData == null) {
            encBodyData = WSSecurityUtil.getElementByGenId(doc, dataRefURI);
        }
        if (encBodyData == null) {
            throw new WSSecurityException(3, "dataRef", new Object[]{dataRefURI});
        }
        boolean content = this.isContent(encBodyData);
        String symEncAlgo = this.getEncAlgo(encBodyData);
        SecretKey symmetricKey = WSSecurityUtil.prepareSecretKey(symEncAlgo, decryptedData);
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance(symEncAlgo);
            xmlCipher.init(2, symmetricKey);
        }
        catch (XMLEncryptionException e) {
            throw new WSSecurityException(2, null, null, e);
        }
        if (content) {
            encBodyData = (Element)encBodyData.getParentNode();
        }
        try {
            xmlCipher.doFinal(doc, encBodyData, content);
        }
        catch (Exception e1) {
            throw new WSSecurityException(8, null, null, e1);
        }
    }

    private void handleReferenceList(Element elem, CallbackHandler cb) throws WSSecurityException {
        Document doc = elem.getOwnerDocument();
        Node tmpE = null;
        for (tmpE = elem.getFirstChild(); tmpE != null; tmpE = tmpE.getNextSibling()) {
            if (tmpE.getNodeType() != 1 || !tmpE.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#") || !tmpE.getLocalName().equals("DataReference")) continue;
            String dataRefURI = ((Element)tmpE).getAttribute("URI");
            this.decryptDataRefEmbedded(doc, dataRefURI, cb);
        }
    }

    public void decryptDataRefEmbedded(Document doc, String dataRefURI, CallbackHandler cb) throws WSSecurityException {
        if (this.doDebug) {
            log.debug((Object)("Embedded found data refernce: " + dataRefURI));
        }
        Element encBodyData = null;
        encBodyData = WSSecurityUtil.getElementByWsuId(this.wssConfig, doc, dataRefURI);
        if (encBodyData == null) {
            encBodyData = WSSecurityUtil.getElementByGenId(doc, dataRefURI);
        }
        if (encBodyData == null) {
            throw new WSSecurityException(3, "dataRef", new Object[]{dataRefURI});
        }
        boolean content = this.isContent(encBodyData);
        String symEncAlgo = this.getEncAlgo(encBodyData);
        Element tmpE = (Element)WSSecurityUtil.findElement(encBodyData, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        SecretKey symmetricKey = this.getSharedKey(tmpE, symEncAlgo, cb);
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance(symEncAlgo);
            xmlCipher.init(2, symmetricKey);
        }
        catch (XMLEncryptionException e1) {
            throw new WSSecurityException(2, null, null, e1);
        }
        if (content) {
            encBodyData = (Element)encBodyData.getParentNode();
        }
        try {
            xmlCipher.doFinal(doc, encBodyData, content);
        }
        catch (Exception e) {
            throw new WSSecurityException(8, null, null, e);
        }
    }

    private boolean isContent(Node encBodyData) {
        Element tmpE = (Element)WSSecurityUtil.findElement(encBodyData, "EncryptedData", "http://www.w3.org/2001/04/xmlenc#");
        String typeStr = null;
        boolean content = true;
        if (tmpE != null) {
            typeStr = tmpE.getAttribute("Type");
        }
        if (typeStr != null) {
            content = typeStr.equals("http://www.w3.org/2001/04/xmlenc#Content");
        }
        return content;
    }

    private String getEncAlgo(Node encBodyData) throws WSSecurityException {
        Element tmpE = (Element)WSSecurityUtil.findElement(encBodyData, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#");
        String symEncAlgo = null;
        if (tmpE != null) {
            symEncAlgo = tmpE.getAttribute("Algorithm");
        }
        if (symEncAlgo == null) {
            throw new WSSecurityException(2, "noEncAlgo");
        }
        if (this.doDebug) {
            log.debug((Object)("Sym Enc Algo: " + symEncAlgo));
        }
        return symEncAlgo;
    }

    protected SecretKey getSharedKey(Element keyInfoElem, String algorithm, CallbackHandler cb) throws WSSecurityException {
        String keyName = null;
        Element keyNmElem = (Element)WSSecurityUtil.getDirectChild(keyInfoElem, "KeyName", "http://www.w3.org/2000/09/xmldsig#");
        if (keyNmElem != null) {
            keyNmElem.normalize();
            Node tmpN = keyNmElem.getFirstChild();
            if (tmpN != null && tmpN.getNodeType() == 3) {
                keyName = tmpN.getNodeValue();
            }
        }
        if (keyName == null) {
            throw new WSSecurityException(3, "noKeyname");
        }
        WSPasswordCallback pwCb = new WSPasswordCallback(keyName, 4);
        Callback[] callbacks = new Callback[]{pwCb};
        try {
            cb.handle(callbacks);
        }
        catch (IOException e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{keyName});
        }
        catch (UnsupportedCallbackException e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{keyName});
        }
        byte[] decryptedData = pwCb.getKey();
        if (decryptedData == null) {
            throw new WSSecurityException(0, "noPassword", new Object[]{keyName});
        }
        return WSSecurityUtil.prepareSecretKey(algorithm, decryptedData);
    }

    public static byte[] getDecodedBase64EncodedData(Element element) throws WSSecurityException {
        StringBuffer sb = new StringBuffer();
        NodeList children = element.getChildNodes();
        int iMax = children.getLength();
        for (int i = 0; i < iMax; ++i) {
            Node curr = children.item(i);
            if (curr.getNodeType() != 3) continue;
            sb.append(((Text)curr).getData());
        }
        String encodedData = sb.toString();
        return Base64.decode(encodedData);
    }

    public byte[] getDecryptedBytes() {
        return this.decryptedBytes;
    }

    public void setPrecisionInMilliSeconds(boolean precisionInMilliSeconds) {
        this.wssConfig.setPrecisionInMilliSeconds(precisionInMilliSeconds);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

