/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Channel;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.objectweb.joram.mom.dest.AdminTopic;
import org.objectweb.joram.mom.proxies.AdminNotification;
import org.objectweb.joram.mom.proxies.FlowControl;
import org.objectweb.joram.mom.proxies.MultiCnxSync;
import org.objectweb.joram.mom.proxies.RequestNot;
import org.objectweb.joram.mom.proxies.UserAgent;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.JmsRequestGroup;
import org.objectweb.joram.shared.client.ProducerMessages;
import org.objectweb.util.monolog.api.BasicLevel;

public class ConnectionManager {
    public static final String MULTI_CNX_SYNC = "org.objectweb.joram.mom.proxies.ConnectionManager.multiCnxSync";
    public static final String MULTI_CNX_SYNC_DELAY = "org.objectweb.joram.mom.proxies.ConnectionManager.multiCnxSyncDelay";
    private static boolean multiCnxSync = Boolean.getBoolean("org.objectweb.joram.mom.proxies.ConnectionManager.multiCnxSync");
    private static long multiThreadSyncDelay = Long.getLong("org.objectweb.joram.mom.proxies.ConnectionManager.multiCnxSyncDelay", 1L);
    private static Hashtable multiCnxSyncTable = new Hashtable();
    public static int inFlow = -1;

    public static final void sendToProxy(AgentId proxyId, int cnxKey, AbstractJmsRequest req, Object msg) {
        RequestNot rn = new RequestNot(cnxKey, msg);
        if (multiCnxSync && (req instanceof ProducerMessages || req instanceof JmsRequestGroup)) {
            MultiCnxSync mcs = ConnectionManager.getMultiCnxSync(proxyId);
            mcs.send(rn);
        } else {
            Channel.sendTo(proxyId, rn);
        }
        if (req instanceof ProducerMessages) {
            FlowControl.flowControl();
        }
    }

    public static final long getMultiThreadSyncDelay() {
        return multiThreadSyncDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiCnxSync getMultiCnxSync(AgentId proxyId) {
        Hashtable hashtable = multiCnxSyncTable;
        synchronized (hashtable) {
            MultiCnxSync mcs = (MultiCnxSync)multiCnxSyncTable.get(proxyId);
            if (mcs == null) {
                mcs = new MultiCnxSync(proxyId);
                multiCnxSyncTable.put(proxyId, mcs);
            }
            return mcs;
        }
    }

    public static void init(String args, boolean firstTime) throws Exception {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("ConnectionManager.init(" + args + ',' + firstTime + ')'));
        }
        if (!firstTime) {
            return;
        }
        AdminTopic adminTopic = new AdminTopic();
        adminTopic.deploy();
        inFlow = Integer.getInteger("ConnectionManager.inFlow", inFlow);
        if (args != null) {
            String initialAdminName = null;
            String initialAdminPass = null;
            StringTokenizer st = new StringTokenizer(args);
            if (st.countTokens() >= 2) {
                initialAdminName = st.nextToken();
                initialAdminPass = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                try {
                    inFlow = Integer.parseInt(st.nextToken());
                }
                catch (Exception exc) {
                    inFlow = -1;
                }
            }
            if (initialAdminName != null && initialAdminPass != null) {
                UserAgent userAgent = new UserAgent(AgentId.JoramAdminPxStamp);
                userAgent.deploy();
                AdminNotification adminNot = new AdminNotification(userAgent.getId(), initialAdminName, initialAdminPass);
                Channel.sendTo(adminTopic.getId(), adminNot);
            }
        }
    }

    public static void stopService() {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)"ConnectionManager.stop()");
        }
    }
}

