/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.jaxws.http.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ow2.jonas.ws.jaxws.IWSRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletRequestAdapter
implements IWSRequest {
    private HttpServletRequest request;
    private Map<Class<?>, Object> attributes;

    public ServletRequestAdapter(HttpServletRequest request) {
        this.request = request;
        this.attributes = new Hashtable();
    }

    public <T> T getAttribute(Class<T> type) {
        return type.cast(this.attributes.get(type));
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public URI getRequestURI() {
        try {
            return new URI(this.request.getScheme(), null, this.request.getServerName(), this.request.getServerPort(), this.request.getRequestURI(), this.request.getQueryString(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public <T> T setAttribute(Class<T> type, T value) {
        Object old = this.attributes.put(type, value);
        return type.cast(old);
    }
}

