/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployer;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.loader.EasyBeansClassLoader;
import org.ow2.easybeans.persistence.PersistenceUnitManager;
import org.ow2.easybeans.persistence.xml.PersistenceXmlFileAnalyzer;
import org.ow2.easybeans.persistence.xml.PersistenceXmlFileAnalyzerException;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.LibDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.impl.helper.EarUnpackOpts;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsDeployer
implements IDeployer {
    public static final String DEFAULT_FOLDER = "EasyBeans-Deployer";
    private static Log logger = LogFactory.getLog(AbsDeployer.class);
    private EZBServer embedded = null;

    public EZBServer getEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(EZBServer embedded) {
        this.embedded = embedded;
    }

    protected ClassLoader getClassLoaderForEAR(EARDeployable earDeployable) throws DeployerException {
        List ejbs = earDeployable.getEJBDeployables();
        List libs = earDeployable.getLibDeployables();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (EJBDeployable ejb : ejbs) {
            try {
                urls.add(ejb.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the Archive '" + ejb.getArchive() + "'.", (Throwable)e);
            }
        }
        for (LibDeployable lib : libs) {
            try {
                urls.add(lib.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the Archive '" + lib.getArchive() + "'.", (Throwable)e);
            }
        }
        final URL[] arrayURLs = urls.toArray(new URL[urls.size()]);
        PrivilegedAction<EasyBeansClassLoader> privilegedAction = new PrivilegedAction<EasyBeansClassLoader>(){

            @Override
            public EasyBeansClassLoader run() {
                return new EasyBeansClassLoader(arrayURLs, Thread.currentThread().getContextClassLoader());
            }
        };
        return AccessController.doPrivileged(privilegedAction);
    }

    protected PersistenceUnitManager getPersistenceUnitManager(EARDeployable earDeployable, ClassLoader appClassLoader) {
        List libs = earDeployable.getLibDeployables();
        PersistenceUnitManager persistenceUnitManager = null;
        for (LibDeployable lib : libs) {
            PersistenceUnitManager builtPersistenceUnitManager = null;
            try {
                builtPersistenceUnitManager = PersistenceXmlFileAnalyzer.analyzePersistenceXmlFile(lib.getArchive(), appClassLoader);
            }
            catch (PersistenceXmlFileAnalyzerException e) {
                throw new IllegalStateException("Failure when analyzing the persistence.xml file", e);
            }
            if (persistenceUnitManager != null) {
                if (builtPersistenceUnitManager == null) continue;
                persistenceUnitManager.addExtraPersistenceUnitInfos(builtPersistenceUnitManager.getPersistenceUnitInfos());
                continue;
            }
            persistenceUnitManager = builtPersistenceUnitManager;
        }
        return persistenceUnitManager;
    }

    protected List<IArchive> getLibArchives(EARDeployable earDeployable) {
        ArrayList<IArchive> libArchives = new ArrayList<IArchive>();
        for (LibDeployable lib : earDeployable.getLibDeployables()) {
            libArchives.add(lib.getArchive());
        }
        return libArchives;
    }

    protected void deployEJB(EJBDeployable ejbDeployable) throws DeployerException {
        logger.info((Object)"Deploying {0}", new Object[]{ejbDeployable});
        EZBContainer container = this.getEmbedded().createContainer(ejbDeployable.getArchive());
        try {
            container.start();
        }
        catch (EZBContainerException e) {
            this.getEmbedded().removeContainer(container);
            throw new DeployerException("Cannot deploy the given EJB '" + ejbDeployable + "'.", (Throwable)e);
        }
    }

    protected static Object newInstance(Class clazz) throws DeployerException {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new DeployerException("Cannot make an instance of the class '" + clazz + "'.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DeployerException("Cannot make an instance of the class '" + clazz + "'.", (Throwable)e);
        }
    }

    protected static Object newInstance(Constructor constructor, Object ... parameters) throws DeployerException {
        try {
            return constructor.newInstance(parameters);
        }
        catch (IllegalArgumentException e) {
            throw new DeployerException("Cannot create a classloader with constructor '" + constructor + "'", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new DeployerException("Cannot create a classloader with constructor '" + constructor + "'", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DeployerException("Cannot create a classloader with constructor '" + constructor + "'", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new DeployerException("Cannot create a classloader with constructor '" + constructor + "'", (Throwable)e);
        }
    }

    protected static Class loadClass(String className) throws DeployerException {
        return AbsDeployer.loadClass(className, null);
    }

    protected static Class loadClass(String className, ClassLoader classLoader) throws DeployerException {
        Class<?> clazz = null;
        try {
            clazz = classLoader != null ? classLoader.loadClass(className) : Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new DeployerException("Cannot load the class '" + className + "'", (Throwable)e);
        }
        return clazz;
    }

    protected static Object invoke(Method method, Object object, Object ... args) throws DeployerException {
        try {
            return method.invoke(object, args);
        }
        catch (IllegalArgumentException e) {
            throw new DeployerException("Cannot invoke the method '" + method + "'", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DeployerException("Cannot invoke the method '" + method + "'", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new DeployerException("Cannot invoke the method '" + method + "'", (Throwable)e);
        }
    }

    protected static Method getMethod(Class clazz, String methodName, Class ... parameters) throws DeployerException {
        try {
            return clazz.getMethod(methodName, parameters);
        }
        catch (SecurityException e) {
            throw new DeployerException("Cannot get the Method '" + methodName + "' on the '" + clazz + "' class.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new DeployerException("Cannot get the Method '" + methodName + "' on the '" + clazz + "' class.", (Throwable)e);
        }
    }

    protected void undeployEJB3FromEAR(EARDeployable earDeployable) throws DeployerException {
        EARDeployable workingDeployable = earDeployable;
        EARDeployable unpackedDeployable = (EARDeployable)earDeployable.getUnpackedDeployable();
        if (unpackedDeployable != null) {
            workingDeployable = unpackedDeployable;
        }
        ArrayList<EZBContainer> containers = new ArrayList<EZBContainer>();
        for (EJB3Deployable ejb3 : workingDeployable.getEJB3Deployables()) {
            EZBContainer container = this.getEmbedded().findContainer(ejb3.getArchive());
            if (container == null) {
                logger.warn((Object)"No container found for the archive ''{0}'', creation has maybe failed", new Object[]{ejb3.getArchive()});
                continue;
            }
            containers.add(container);
        }
        for (EZBContainer container : containers) {
            container.stop();
            this.getEmbedded().removeContainer(container);
        }
    }

    protected EARDeployable unpackEARDeployable(EARDeployable earDeployable) throws DeployerException {
        EarUnpackOpts earUnpackOpts = new EarUnpackOpts();
        earUnpackOpts.setWarAutoUnpacked(true);
        return (EARDeployable)UnpackDeployableHelper.unpack((IDeployable)earDeployable, (String)"EE-Deployer", (boolean)false, (EarUnpackOpts)earUnpackOpts);
    }

    public boolean isDeployed(IDeployable<?> deployable) throws DeployerException {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public boolean supports(IDeployable<?> deployable) {
        throw new UnsupportedOperationException("Not yet supported");
    }
}

