/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean;

import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarClassMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJLocal;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJRemote;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JLocal;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JRemote;

public final class InterfaceAnnotatedHelper {
    private InterfaceAnnotatedHelper() {
    }

    public static void resolve(EjbJarClassMetadata sessionBean) throws ResolverException {
        String[] interfaces;
        EjbJarArchiveMetadata ejbJarAnnotationMetadata = sessionBean.getEjbJarArchiveMetadata();
        IJLocal currentLocalInterfaces = sessionBean.getLocalInterfaces();
        IJRemote currentRemoteInterfaces = sessionBean.getRemoteInterfaces();
        for (String itf : interfaces = sessionBean.getInterfaces()) {
            IJRemote jRemote;
            EjbJarClassMetadata itfAnnotationMetadata = ejbJarAnnotationMetadata.getEjbJarClassMetadata(itf);
            if (itfAnnotationMetadata == null) continue;
            IJLocal jLocal = itfAnnotationMetadata.getLocalInterfaces();
            if (jLocal != null) {
                if (currentLocalInterfaces == null) {
                    currentLocalInterfaces = new JLocal();
                    sessionBean.setLocalInterfaces(currentLocalInterfaces);
                }
                String itfName = itfAnnotationMetadata.getClassName();
                if (!currentLocalInterfaces.getInterfaces().contains(itfName)) {
                    currentLocalInterfaces.addInterface(itfName);
                }
            }
            if ((jRemote = itfAnnotationMetadata.getRemoteInterfaces()) == null) continue;
            if (currentRemoteInterfaces == null) {
                currentRemoteInterfaces = new JRemote();
                sessionBean.setRemoteInterfaces(currentRemoteInterfaces);
            }
            String itfName = itfAnnotationMetadata.getClassName();
            if (currentRemoteInterfaces.getInterfaces().contains(itfName)) continue;
            currentRemoteInterfaces.addInterface(itfName);
        }
    }
}

