/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.osgi.binder.listener;

import java.lang.reflect.Method;
import org.osgi.framework.ServiceReference;
import org.ow2.easybeans.osgi.binder.listener.IDependencyListener;
import org.ow2.easybeans.osgi.binder.util.ReflectionHelper;

public class MethodInjectorListener
implements IDependencyListener {
    private final Object bean;
    private final Method binder;
    private final Method unbinder;

    public MethodInjectorListener(Object instance, Method bindMethod, Method unbindMethod) {
        this.bean = instance;
        this.binder = bindMethod;
        this.unbinder = unbindMethod;
    }

    public void added(ServiceReference ref, Object service) {
        if (!ReflectionHelper.isNullableObject(service) && this.binder != null) {
            ReflectionHelper.invokeMethod(this.binder, this.bean, service);
        }
    }

    public void changed(ServiceReference ref, Object service) {
    }

    public void removed(ServiceReference ref, Object service) {
        if (!ReflectionHelper.isNullableObject(service)) {
            Object value = null;
            if (!this.binder.equals(this.unbinder)) {
                value = service;
            }
            ReflectionHelper.invokeMethod(this.unbinder, this.bean, value);
        }
    }
}

